/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.data;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import noobanidus.mods.lootr.api.LootFiller;
import noobanidus.mods.lootr.api.tile.ILootTile;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;

public class ChestData
extends WorldSavedData {
    private BlockPos pos;
    private RegistryKey<World> dimension;
    private UUID entityId;
    private UUID tileId;
    private UUID customId;
    private Map<UUID, SpecialChestInventory> inventories = new HashMap<UUID, SpecialChestInventory>();
    private NonNullList<ItemStack> reference;
    private boolean custom;

    public UUID getEntityId() {
        return this.entityId;
    }

    public static String ID(UUID id) {
        String idString = id.toString();
        return "lootr/" + idString.charAt(0) + "/" + idString.substring(0, 2) + "/" + idString;
    }

    public ChestData(String ID) {
        super(ID);
    }

    public ChestData(RegistryKey<World> dimension, UUID id, @Nullable UUID customId, @Nullable NonNullList<ItemStack> base) {
        super(ChestData.ID(id));
        this.pos = null;
        this.dimension = dimension;
        this.entityId = null;
        this.tileId = id;
        this.reference = base;
        this.custom = true;
        this.customId = customId;
        if (customId == null && base == null) {
            throw new IllegalArgumentException("Both customId and inventory reference cannot be null.");
        }
    }

    public ChestData(RegistryKey<World> dimension, UUID id) {
        super(ChestData.ID(id));
        this.pos = null;
        this.dimension = dimension;
        this.entityId = null;
        this.tileId = id;
        this.reference = null;
        this.custom = false;
        this.customId = null;
    }

    public ChestData(UUID entityId) {
        super(ChestData.ID(entityId));
        this.pos = null;
        this.dimension = null;
        this.tileId = null;
        this.entityId = entityId;
        this.reference = null;
        this.custom = false;
        this.customId = null;
    }

    public LootFiller customInventory() {
        return (player, inventory, table, seed) -> {
            for (int i = 0; i < this.reference.size(); ++i) {
                inventory.func_70299_a(i, ((ItemStack)this.reference.get(i)).func_77946_l());
            }
        };
    }

    public Map<UUID, SpecialChestInventory> getInventories() {
        return this.inventories;
    }

    public void setInventories(Map<UUID, SpecialChestInventory> inventories) {
        this.inventories = inventories;
    }

    public boolean clearInventory(UUID uuid) {
        return this.inventories.remove(uuid) != null;
    }

    @Nullable
    public SpecialChestInventory getInventory(ServerPlayerEntity player) {
        return this.inventories.get(player.func_110124_au());
    }

    public SpecialChestInventory createInventory(ServerPlayerEntity player, LootFiller filler, @Nullable LockableLootTileEntity tile) {
        SpecialChestInventory result;
        ServerWorld world = (ServerWorld)player.field_70170_p;
        LootrChestMinecartEntity cart = null;
        long seed = -1L;
        ResourceLocation lootTable = null;
        if (this.entityId != null) {
            Entity initial = world.func_217461_a(this.entityId);
            if (!(initial instanceof LootrChestMinecartEntity)) {
                return null;
            }
            cart = (LootrChestMinecartEntity)initial;
            NonNullList items = NonNullList.func_191197_a((int)cart.func_70302_i_(), (Object)ItemStack.field_190927_a);
            result = new SpecialChestInventory(this, (NonNullList<ItemStack>)items, cart.func_145748_c_(), this.pos);
            lootTable = cart.field_184290_c;
        } else {
            if (tile == null) {
                return null;
            }
            lootTable = ((ILootTile)tile).getTable();
            NonNullList items = NonNullList.func_191197_a((int)tile.func_70302_i_(), (Object)ItemStack.field_190927_a);
            result = new SpecialChestInventory(this, (NonNullList<ItemStack>)items, tile.func_145748_c_(), this.pos);
        }
        filler.fillWithLoot((PlayerEntity)player, result, lootTable, seed);
        this.inventories.put(player.func_110124_au(), result);
        this.func_76185_a();
        world.func_217481_x().func_212775_b();
        result.setBlockPos(this.pos);
        return result;
    }

    public void func_76184_a(CompoundNBT compound) {
        this.inventories.clear();
        this.pos = null;
        this.dimension = null;
        this.entityId = null;
        this.tileId = null;
        if (compound.func_74764_b("position")) {
            this.pos = BlockPos.func_218283_e((long)compound.func_74763_f("position"));
        }
        if (compound.func_74764_b("dimension")) {
            this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(compound.func_74779_i("dimension")));
        }
        if (compound.func_186855_b("entityId")) {
            this.entityId = compound.func_186857_a("entityId");
        }
        if (compound.func_186855_b("tileId")) {
            this.tileId = compound.func_186857_a("tileId");
        }
        if (compound.func_74764_b("custom")) {
            this.custom = compound.func_74767_n("custom");
        }
        if (compound.func_186855_b("customId")) {
            this.customId = compound.func_186857_a("customId");
        }
        if (compound.func_74764_b("reference") && compound.func_74764_b("referenceSize")) {
            int size = compound.func_74762_e("referenceSize");
            this.reference = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)compound.func_74775_l("reference"), this.reference);
        }
        ListNBT compounds = compound.func_150295_c("inventories", 10);
        for (int i = 0; i < compounds.size(); ++i) {
            CompoundNBT thisTag = compounds.func_150305_b(i);
            CompoundNBT items = thisTag.func_74775_l("chest");
            String name = thisTag.func_74779_i("name");
            UUID uuid = thisTag.func_186857_a("uuid");
            this.inventories.put(uuid, new SpecialChestInventory(this, items, name, this.pos));
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        if (this.pos != null) {
            compound.func_74772_a("position", this.pos.func_218275_a());
        }
        if (this.dimension != null) {
            compound.func_74778_a("dimension", this.dimension.func_240901_a_().toString());
        }
        if (this.entityId != null) {
            compound.func_186854_a("entityId", this.entityId);
        }
        if (this.tileId != null) {
            compound.func_186854_a("tileId", this.tileId);
        }
        if (this.customId != null) {
            compound.func_186854_a("customId", this.customId);
        }
        compound.func_74757_a("custom", this.custom);
        if (this.reference != null) {
            compound.func_74768_a("referenceSize", this.reference.size());
            compound.func_218657_a("reference", (INBT)ItemStackHelper.func_191281_a((CompoundNBT)new CompoundNBT(), this.reference, (boolean)true));
        }
        ListNBT compounds = new ListNBT();
        for (Map.Entry<UUID, SpecialChestInventory> entry : this.inventories.entrySet()) {
            CompoundNBT thisTag = new CompoundNBT();
            thisTag.func_186854_a("uuid", entry.getKey());
            thisTag.func_218657_a("chest", (INBT)entry.getValue().writeItems());
            thisTag.func_74778_a("name", entry.getValue().writeName());
            compounds.add((Object)thisTag);
        }
        compound.func_218657_a("inventories", (INBT)compounds);
        return compound;
    }

    public void clear() {
        this.inventories.clear();
    }

    public void func_215158_a(File pFile) {
        if (this.func_76188_b()) {
            pFile.getParentFile().mkdirs();
        }
        super.func_215158_a(pFile);
    }

    public static ChestData unwrap(ChestData data, RegistryKey<World> dimension, BlockPos position) {
        data.pos = position;
        data.dimension = dimension;
        return data;
    }
}

