/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.event;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import noobanidus.mods.lootr.Lootr;

@Mod.EventBusSubscriber(modid="lootr")
public class HandleMigrate {
    private static void append(StringBuilder builder, int intVal) {
        HandleMigrate.append(builder, intVal, true);
    }

    private static void append(StringBuilder builder, int intVal, boolean sep) {
        if (intVal < 10) {
            builder.append('0').append(intVal);
        } else {
            builder.append(intVal);
        }
        if (sep) {
            builder.append('-');
        }
    }

    @SubscribeEvent
    public static void onServerStarting(FMLServerStartedEvent event) {
        List toMigrate;
        Path data = event.getServer().func_240776_a_(new FolderName("data"));
        Path dataLootr = data.resolve("lootr");
        try {
            toMigrate = Files.walk(event.getServer().func_240776_a_(new FolderName("data")), 1, new FileVisitOption[0]).collect(Collectors.toList());
        }
        catch (IOException e) {
            Lootr.LOG.error("Unable to begin migration of existing data!", (Throwable)e);
            return;
        }
        toMigrate.removeIf(path -> !path.getFileName().toString().startsWith("Lootr-"));
        if (!toMigrate.isEmpty()) {
            Lootr.LOG.info("Backing up {} files...", (Object)toMigrate.size());
            Calendar time = Calendar.getInstance();
            StringBuilder filenameBuilder = new StringBuilder();
            filenameBuilder.append("LootrMigrationBackup-");
            HandleMigrate.append(filenameBuilder, time.get(1));
            HandleMigrate.append(filenameBuilder, time.get(2) + 1);
            HandleMigrate.append(filenameBuilder, time.get(5));
            HandleMigrate.append(filenameBuilder, time.get(11));
            HandleMigrate.append(filenameBuilder, time.get(12));
            HandleMigrate.append(filenameBuilder, time.get(13), false);
            String name = filenameBuilder.toString();
            Path backupName = data.resolve(name + ".zip");
            File backup = backupName.toFile();
            backup.getParentFile().mkdirs();
            int inc = 0;
            while (backup.exists()) {
                backupName = data.resolve(name + "-" + inc + ".zip");
                backup = backupName.toFile();
                if (inc++ < 99) continue;
                throw new IllegalStateException("Unable to create backup for Lootr data files. Reached '" + name + "-" + inc + ".zip' and all files exist!");
            }
            boolean failure = false;
            try {
                FileOutputStream stream = new FileOutputStream(backup);
                Iterator iterator = null;
                try (ZipOutputStream backupZip2 = new ZipOutputStream(stream);){
                    backupZip2.setLevel(0);
                    byte[] readBuffer = new byte[4096];
                    for (Path path2 : toMigrate) {
                        ZipEntry entry = new ZipEntry(path2.getFileName().toString());
                        try {
                            FileInputStream inputStream = new FileInputStream(path2.toFile());
                            Throwable throwable = null;
                            try {
                                int len;
                                backupZip2.putNextEntry(entry);
                                while ((len = inputStream.read(readBuffer)) > 0) {
                                    backupZip2.write(readBuffer, 0, len);
                                }
                                backupZip2.closeEntry();
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (inputStream == null) continue;
                                if (throwable != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                inputStream.close();
                            }
                        }
                        catch (IOException e) {
                            failure = true;
                            Lootr.LOG.error("Unable to fully back-up Lootr data, failure while reading: {}", (Object)path2, (Object)e);
                        }
                    }
                }
                catch (Throwable backupZip2) {
                    iterator = backupZip2;
                    throw backupZip2;
                }
                finally {
                    if (stream != null) {
                        if (iterator != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable backupZip2) {
                                ((Throwable)((Object)iterator)).addSuppressed(backupZip2);
                            }
                        } else {
                            stream.close();
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Unable to create backup for Lootr data files! Backup file couldn't be opened for some reason.", e);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create backup for Lootr data files! Backup file couldn't be written to.", e);
            }
            if (failure) {
                throw new IllegalStateException("Unable to fully back-up Lootr data. Please check log file for details as to which file failed to back-up.");
            }
            Lootr.LOG.info("Completed backup! {} files were backed up to {}", (Object)toMigrate.size(), (Object)backup);
            HashMap<Path, Path> migrations = new HashMap<Path, Path>();
            for (Path path3 : toMigrate) {
                String uuid;
                String fileName = path3.getFileName().toString();
                if (fileName.startsWith("Lootr-AdvancementData") || fileName.startsWith("Lootr-ScoreData") || fileName.startsWith("Lootr-DecayData") || fileName.startsWith("Lootr-RefreshData")) {
                    migrations.put(path3, dataLootr.resolve(path3.getFileName()));
                    continue;
                }
                if (fileName.startsWith("Lootr-chests") || fileName.startsWith("Lootr-custom")) {
                    uuid = fileName.split("-", 4)[3];
                } else if (fileName.startsWith("Lootr-entity")) {
                    uuid = fileName.split("-", 3)[2];
                } else {
                    Lootr.LOG.error("Invalid file name found while traversing data. Could not migrate: '" + path3 + "'");
                    continue;
                }
                String containerId = uuid.substring(0, 2);
                try {
                    Files.createDirectories(dataLootr.resolve(uuid.substring(0, 1)).resolve(containerId), new FileAttribute[0]);
                }
                catch (IOException e) {
                    Lootr.LOG.error("Unable to create 'lootr/" + containerId + "' subdirectory. Could not migrate: '" + path3 + "'", (Throwable)e);
                    continue;
                }
                migrations.put(path3, dataLootr.resolve(uuid.substring(0, 1)).resolve(containerId).resolve(uuid));
            }
            if (!migrations.isEmpty()) {
                Lootr.LOG.info("Migrating Lootr data files to subdirectory...");
                for (Map.Entry migrationEntry : migrations.entrySet()) {
                    try {
                        Files.move((Path)migrationEntry.getKey(), (Path)migrationEntry.getValue(), new CopyOption[0]);
                    }
                    catch (FileAlreadyExistsException e) {
                        Lootr.LOG.info("Unable to migrate from '" + migrationEntry.getKey() + "' to '" + migrationEntry.getValue() + "' as destination already exists! Deleting extraneous file.");
                        try {
                            Files.delete((Path)migrationEntry.getKey());
                        }
                        catch (IOException ex) {
                            Lootr.LOG.error("Unable to migrate from '" + migrationEntry.getKey() + "' to '" + migrationEntry.getValue() + "' as destination already exists! Unable to delete extraneous file. Please manually delete.", (Throwable)e);
                        }
                    }
                    catch (IOException e) {
                        Lootr.LOG.error("Unable to migrate from '" + migrationEntry.getKey() + "' to '" + migrationEntry.getValue() + "'", (Throwable)e);
                    }
                }
                Lootr.LOG.info("Migrated " + migrations.size() + " Lootr data files to subdirectory!");
            }
        }
    }
}

