/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.block.entity;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import noobanidus.mods.lootr.common.api.DataToCopy;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.LootrTags;
import noobanidus.mods.lootr.common.api.PlatformAPI;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.chunk.LoadedChunks;
import org.jetbrains.annotations.Nullable;

public final class BlockEntityTicker {
    private static final Map<class_5321<class_1937>, BlockEntityTicker> TICKERS = new Object2ObjectOpenHashMap();
    private final class_5321<class_1937> levelKey;
    private final Map<class_1923, Entry> blockEntityEntries = new Object2ObjectOpenHashMap();
    private final Map<class_1923, Entry> pendingEntries = new Object2ObjectOpenHashMap();

    private BlockEntityTicker(class_5321<class_1937> levelKey) {
        this.levelKey = levelKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEntity(class_2586 entity, class_1937 level, class_1923 chunkPos) {
        BlockEntityTicker ticker;
        if (LootrAPI.isDisabled()) {
            return;
        }
        class_5321<class_1937> dimension = BlockEntityTicker.getServerDimensionIfValid(level);
        if (dimension == null) {
            return;
        }
        Map<class_5321<class_1937>, BlockEntityTicker> map = TICKERS;
        synchronized (map) {
            ticker = TICKERS.computeIfAbsent(dimension, BlockEntityTicker::new);
        }
        ticker.addEntity(level, entity, chunkPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntity(class_1937 level, class_2586 entity, class_1923 chunkPos) {
        if (!LootrAPI.isWorldBorderSafe(level, chunkPos)) {
            return;
        }
        if (!BlockEntityTicker.isValidEntity(entity)) {
            return;
        }
        Map<class_1923, Entry> map = this.pendingEntries;
        synchronized (map) {
            Entry previousEntry = this.pendingEntries.get(chunkPos);
            if (previousEntry != null) {
                previousEntry.entityPositions.add(entity.method_11016());
            } else {
                HashSet<class_2338> entityPositions = new HashSet<class_2338>();
                entityPositions.add(entity.method_11016());
                Entry entry = new Entry(chunkPos, entityPositions);
                this.pendingEntries.put(chunkPos, entry);
            }
        }
    }

    private static boolean isValidEntity(class_2586 entity) {
        if (!(entity instanceof class_2621)) {
            return false;
        }
        class_2621 validEntity = (class_2621)entity;
        if (LootrAPI.resolveBlockEntity(validEntity) instanceof ILootrBlockEntity) {
            return false;
        }
        return validEntity.method_54869() != null && !LootrAPI.isLootTableBlacklisted((class_5321<class_52>)validEntity.method_54869());
    }

    public static void onServerTick(MinecraftServer server) {
        if (LootrAPI.isDisabled()) {
            return;
        }
        for (BlockEntityTicker ticker : TICKERS.values()) {
            class_3218 level = server.method_3847(ticker.levelKey);
            if (level == null) continue;
            ticker.onServerLevelTick(level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onServerLevelTick(class_3218 level) {
        Set<class_1923> loadedChunks = LoadedChunks.getLoadedChunks((class_5321<class_1937>)level.method_27983());
        Iterator<Entry> iterator = this.blockEntityEntries.values().iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            switch (entry.getChunkLoadStatus(level, loadedChunks).ordinal()) {
                case 0: {
                    iterator.remove();
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    break;
                }
                case 3: {
                    BlockEntityTicker.replaceEntitiesInChunk(level, entry);
                    iterator.remove();
                }
            }
        }
        Map<class_1923, Entry> map = this.pendingEntries;
        synchronized (map) {
            for (Entry entry : this.pendingEntries.values()) {
                this.blockEntityEntries.merge(entry.chunkPos, entry, (entry1, entry2) -> {
                    entry1.entityPositions.addAll(entry2.entityPositions);
                    return entry1;
                });
            }
            this.pendingEntries.clear();
        }
    }

    private static boolean checkStructureValidity(class_3218 level, class_1923 chunkPos, class_2338 position) {
        if (!level.method_8503().method_27728().method_28057().method_28029()) {
            return true;
        }
        class_2378 registry = level.method_30349().method_30530(class_7924.field_41246);
        if (registry.method_40266(LootrTags.Structure.STRUCTURE_BLACKLIST).filter(tag -> tag.method_40247() != 0).isPresent()) {
            return !LootrAPI.isTaggedStructurePresent(level, chunkPos, LootrTags.Structure.STRUCTURE_BLACKLIST, position);
        }
        if (registry.method_40266(LootrTags.Structure.STRUCTURE_WHITELIST).filter(tag -> tag.method_40247() != 0).isPresent()) {
            return LootrAPI.isTaggedStructurePresent(level, chunkPos, LootrTags.Structure.STRUCTURE_WHITELIST, position);
        }
        return true;
    }

    private static void replaceEntitiesInChunk(class_3218 level, Entry entry) {
        for (class_2338 entityPos : entry.entityPositions()) {
            class_2680 stateAt;
            class_2680 replacement;
            class_2586 blockEntity;
            if (!BlockEntityTicker.checkStructureValidity(level, entry.chunkPos(), entityPos) || !((blockEntity = level.method_8321(entityPos)) instanceof class_2621)) continue;
            class_2621 be = (class_2621)blockEntity;
            if (LootrAPI.resolveBlockEntity(blockEntity) instanceof ILootrBlockEntity) continue;
            class_5321 table = be.method_54869();
            if (table == null) {
                LootrAPI.LOG.warn("randomizable container \"{}\" has no loot table in {} ({})", (Object)be.method_5477(), (Object)level.method_27983(), (Object)entityPos);
                continue;
            }
            if (LootrAPI.isLootTableBlacklisted((class_5321<class_52>)table) || (replacement = LootrAPI.replacementBlockState(stateAt = level.method_8320(entityPos))) == null) continue;
            BlockEntityTicker.replaceEntity((class_1937)level, entityPos, be, replacement, (class_5321<class_52>)table);
        }
    }

    private static void replaceEntity(class_1937 level, class_2338 entityPos, class_2621 be, class_2680 replacement, class_5321<class_52> table) {
        DataToCopy data = PlatformAPI.copySpecificData((class_2586)be);
        long seed = be.method_54870();
        be.method_11285(null);
        level.method_8652(entityPos, replacement, 2);
        class_2586 newBlockEntity = level.method_8321(entityPos);
        PlatformAPI.restoreSpecificData(data, newBlockEntity);
        if (LootrAPI.resolveBlockEntity(newBlockEntity) instanceof ILootrBlockEntity && newBlockEntity instanceof class_2621) {
            class_2621 rbe = (class_2621)newBlockEntity;
            rbe.method_54867(table, seed);
        } else {
            LootrAPI.LOG.error("replacement {} is not an ILootrBlockEntity {} at {}", (Object)replacement, (Object)level.method_27983(), (Object)entityPos);
        }
    }

    @Nullable
    private static class_5321<class_1937> getServerDimensionIfValid(class_1937 level) {
        if (LootrAPI.getServer() == null || level.method_8608()) {
            return null;
        }
        class_5321 dimension = level.method_27983();
        if (LootrAPI.isDimensionBlocked((class_5321<class_1937>)dimension)) {
            return null;
        }
        return dimension;
    }

    public record Entry(class_1923 chunkPos, Set<class_2338> entityPositions) {
        public ChunkLoadStatus getChunkLoadStatus(class_3218 level, Set<class_1923> loadedChunks) {
            class_3215 chunkSource = level.method_14178();
            if (!LootrAPI.isWorldBorderSafe((class_1937)level, this.chunkPos) || !chunkSource.method_12123(this.chunkPos.field_9181, this.chunkPos.field_9180)) {
                return ChunkLoadStatus.UNLOADED;
            }
            if (!loadedChunks.contains(this.chunkPos)) {
                return ChunkLoadStatus.NOT_FULLY_LOADED;
            }
            for (int x = this.chunkPos.field_9181 - 2; x <= this.chunkPos.field_9181 + 2; ++x) {
                for (int z = this.chunkPos.field_9180 - 2; z <= this.chunkPos.field_9180 + 2; ++z) {
                    class_1923 pos;
                    if (x == this.chunkPos.field_9181 && z == this.chunkPos.field_9180 || !LootrAPI.isWorldBorderSafe((class_1937)level, pos = new class_1923(x, z)) || loadedChunks.contains(pos)) continue;
                    return ChunkLoadStatus.SURROUNDING_CHUNKS_NOT_LOADED;
                }
            }
            return ChunkLoadStatus.COMPLETE;
        }
    }

    public static enum ChunkLoadStatus {
        UNLOADED,
        SURROUNDING_CHUNKS_NOT_LOADED,
        NOT_FULLY_LOADED,
        COMPLETE;

    }
}

