/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.PlatformAPI;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;

public interface ILootrBlockEntity
extends ILootrInfoProvider {
    public static <T extends BlockEntity> void ticker(Level level, BlockPos pos, BlockState state, T blockEntity) {
        ILootrBlockEntity t;
        ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(blockEntity);
        if (iLootrBlockEntity instanceof ILootrBlockEntity && (t = iLootrBlockEntity).hasLootTable()) {
            t.defaultTick(level, pos, state);
        }
    }

    default public boolean hasLootTable() {
        return this.getInfoLootTable() != null;
    }

    default public void defaultTick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            LootrAPI.handleProviderTick(this);
        }
    }

    default public BlockEntity asBlockEntity() {
        return (BlockEntity)this;
    }

    @Override
    default public ILootrInfo.LootrInfoType getInfoType() {
        return ILootrInfo.LootrInfoType.CONTAINER_BLOCK_ENTITY;
    }

    default public void updatePacketViaForce() {
        this.updatePacketViaForce(this.asBlockEntity());
    }

    default public void updatePacketViaForce(BlockEntity entity) {
        Level level = entity.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            Packet packet = entity.getUpdatePacket();
            if (packet != null) {
                level2.getChunkSource().chunkMap.getPlayers(new ChunkPos(entity.getBlockPos()), false).forEach(player -> player.connection.send(packet));
            }
        }
    }

    @Override
    default public void performOpen(ServerPlayer player) {
        PlatformAPI.performBlockOpen(this, player);
    }

    @Override
    default public void performOpen() {
        PlatformAPI.performBlockOpen(this);
    }

    @Override
    default public void performClose(ServerPlayer player) {
        PlatformAPI.performBlockClose(this, player);
    }

    @Override
    default public void performClose() {
        PlatformAPI.performBlockClose(this);
    }

    @Override
    default public void performDecay() {
        Level level = this.getInfoLevel();
        if (level == null || level.isClientSide()) {
            return;
        }
        boolean replaceWhenDecayed = LootrAPI.shouldReplaceWhenDecayed();
        level.destroyBlock(this.getInfoPos(), !replaceWhenDecayed);
        if (replaceWhenDecayed) {
            level.setBlock(this.getInfoPos(), this.getInfoBlockType().getBlock().defaultBlockState(), 2);
        }
    }

    @Override
    default public void performUpdate(ServerPlayer player) {
        this.performUpdate();
    }

    @Override
    default public void performUpdate() {
        this.markChanged();
        this.updatePacketViaForce();
    }
}

