/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.time.Duration;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import xaeroplus.Globals;
import xaeroplus.event.ChunkBlockUpdateEvent;
import xaeroplus.event.ChunkBlocksUpdateEvent;
import xaeroplus.event.ChunkDataEvent;
import xaeroplus.event.Phase;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.highlights.SavableHighlightCacheInstance;
import xaeroplus.feature.render.DrawFeatureFactory;
import xaeroplus.module.Module;
import xaeroplus.settings.Settings;
import xaeroplus.shadow.caffeine.cache.Cache;
import xaeroplus.shadow.caffeine.cache.Caffeine;
import xaeroplus.shadow.lambdaevents.EventHandler;
import xaeroplus.util.ChunkScanner;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class LiquidNewChunks
extends Module {
    public final SavableHighlightCacheInstance newChunksCache = new SavableHighlightCacheInstance("XaeroPlusNewChunks");
    public final SavableHighlightCacheInstance inverseNewChunksCache = new SavableHighlightCacheInstance("XaeroPlusNewChunksLiquidInverse");
    private final Cache<Long, Byte> seenChunksCache = Caffeine.newBuilder().maximumSize(1000L).executor(Globals.cacheRefreshExecutorService.get()).expireAfterAccess(Duration.ofMinutes(5L)).build();
    private boolean renderInverse = false;
    private int newChunksColor = ColorHelper.getColor(255, 0, 0, 100);
    private int inverseColor = ColorHelper.getColor(0, 255, 0, 100);
    private static final Direction[] searchDirs = new Direction[]{Direction.EAST, Direction.NORTH, Direction.WEST, Direction.SOUTH, Direction.UP};
    private static final ReferenceSet<Block> liquidBlockTypeFilter = ReferenceOpenHashSet.of((Object)Blocks.f_49990_, (Object)Blocks.f_49991_);
    private static final String inverseDrawFeatureId = "LiquidNewChunksInverse";

    public void setDiskCache(boolean disk) {
        this.newChunksCache.setDiskCache(disk, this.isEnabled());
        this.inverseNewChunksCache.setDiskCache(disk, this.isEnabled());
    }

    @EventHandler
    public void onMultiBlockUpdate(ChunkBlocksUpdateEvent event) {
        if (event.phase() != Phase.PRE) {
            return;
        }
        ClientLevel level = this.mc.f_91073_;
        if (level == null || this.mc.f_91060_.f_109469_ == null) {
            return;
        }
        event.packet().m_132992_((pos, state) -> this.handleBlockUpdate((Level)level, (BlockPos)pos, (BlockState)state));
    }

    @EventHandler
    public void onBlockUpdate(ChunkBlockUpdateEvent event) {
        if (event.phase() != Phase.PRE) {
            return;
        }
        ClientLevel level = this.mc.f_91073_;
        if (level == null || this.mc.f_91060_.f_109469_ == null) {
            return;
        }
        this.handleBlockUpdate((Level)level, event.packet().m_131749_(), event.packet().m_131746_());
    }

    private void handleBlockUpdate(Level level, BlockPos pos, BlockState state) {
        if (!state.m_60819_().m_76178_() && !state.m_60819_().m_76170_()) {
            int chunkX = ChunkUtils.posToChunkPos(pos.m_123341_());
            int chunkZ = ChunkUtils.posToChunkPos(pos.m_123343_());
            if (this.inverseNewChunksCache.get().isHighlighted(chunkX, chunkZ, ChunkUtils.getActualDimension())) {
                return;
            }
            if (this.newChunksCache.get().isHighlighted(chunkX, chunkZ, ChunkUtils.getActualDimension())) {
                return;
            }
            int srcX = pos.m_123341_();
            int srcY = pos.m_123342_();
            if (Settings.REGISTRY.liquidNewChunksOnlyAboveY0Setting.get() && srcY <= 0) {
                return;
            }
            int srcZ = pos.m_123343_();
            BlockPos.MutableBlockPos bp = new BlockPos.MutableBlockPos(srcX, srcY, srcZ);
            for (int i = 0; i < searchDirs.length; ++i) {
                Direction dir = searchDirs[i];
                bp.m_122178_(srcX + dir.m_122429_(), srcY + dir.m_122430_(), srcZ + dir.m_122431_());
                if (!level.m_8055_((BlockPos)bp).m_60819_().m_76170_()) continue;
                this.newChunksCache.get().addHighlight(chunkX, chunkZ);
                return;
            }
        }
    }

    @EventHandler
    public void onChunkData(ChunkDataEvent event) {
        ClientLevel level = this.mc.f_91073_;
        if (level == null || this.mc.f_91060_.f_109469_ == null) {
            return;
        }
        LevelChunk chunk = event.chunk();
        ChunkPos chunkPos = chunk.m_7697_();
        long chunkLong = ChunkUtils.chunkPosToLong(chunkPos);
        if (this.seenChunksCache.getIfPresent(chunkLong) != null) {
            return;
        }
        this.seenChunksCache.put(chunkLong, (byte)127);
        if (this.newChunksCache.get().isHighlighted(chunkPos.f_45578_, chunkPos.f_45579_, ChunkUtils.getActualDimension())) {
            return;
        }
        if (this.inverseNewChunksCache.get().isHighlighted(chunkPos.f_45578_, chunkPos.f_45579_, ChunkUtils.getActualDimension())) {
            return;
        }
        ChunkScanner.chunkScanBlockstatePredicate((ChunkAccess)chunk, liquidBlockTypeFilter, (c, state, relX, y, relZ) -> {
            int x = ChunkUtils.chunkCoordToCoord(c.m_7697_().f_45578_) + relX;
            int z = ChunkUtils.chunkCoordToCoord(c.m_7697_().f_45579_) + relZ;
            FluidState fluid = state.m_60819_();
            if (!fluid.m_76178_() && !fluid.m_76170_()) {
                if (fluid.m_76186_() < 2) {
                    this.inverseNewChunksCache.get().addHighlight(c.m_7697_().f_45578_, chunk.m_7697_().f_45579_);
                    return true;
                }
                boolean foundColumn = true;
                for (int i = 1; i <= 5; ++i) {
                    FluidState aboveState = chunk.m_62814_(x, y + i, z);
                    if (!aboveState.m_76178_() && !aboveState.m_76170_()) continue;
                    foundColumn = false;
                    break;
                }
                if (foundColumn) {
                    this.inverseNewChunksCache.get().addHighlight(c.m_7697_().f_45578_, c.m_7697_().f_45579_);
                    return true;
                }
            }
            return false;
        }, Settings.REGISTRY.liquidNewChunksOnlyAboveY0Setting.get() ? Math.max(1, level.m_141937_()) : level.m_141937_());
    }

    @EventHandler
    public void onXaeroWorldChangeEvent(XaeroWorldChangeEvent event) {
        this.seenChunksCache.invalidateAll();
    }

    public synchronized void setInverseRenderEnabled(boolean b) {
        this.renderInverse = b;
        if (this.renderInverse && this.isEnabled()) {
            this.registerInverseChunkHighlightProvider();
        } else {
            Globals.drawManager.registry().unregister(inverseDrawFeatureId);
        }
    }

    @Override
    public void onEnable() {
        Globals.drawManager.registry().register(DrawFeatureFactory.chunkHighlights("LiquidNewChunks", this::getNewChunkHighlightsState, this::getNewChunksColor, 250));
        if (this.renderInverse) {
            this.registerInverseChunkHighlightProvider();
        }
        this.newChunksCache.onEnable();
        this.inverseNewChunksCache.onEnable();
    }

    private void registerInverseChunkHighlightProvider() {
        Globals.drawManager.registry().register(DrawFeatureFactory.chunkHighlights(inverseDrawFeatureId, this::getInverseNewChunkHighlightsState, this::getInverseColor, 250));
    }

    @Override
    public void onDisable() {
        this.newChunksCache.onDisable();
        this.inverseNewChunksCache.onDisable();
        Globals.drawManager.registry().unregister("LiquidNewChunks");
        Globals.drawManager.registry().unregister(inverseDrawFeatureId);
    }

    public int getNewChunksColor() {
        return this.newChunksColor;
    }

    private int getInverseColor() {
        return this.inverseColor;
    }

    public void setRgbColor(int color) {
        this.newChunksColor = ColorHelper.getColorWithAlpha(color, Settings.REGISTRY.liquidNewChunksAlphaSetting.getAsInt());
    }

    public void setInverseRgbColor(int color) {
        this.inverseColor = ColorHelper.getColorWithAlpha(color, Settings.REGISTRY.liquidNewChunksAlphaSetting.getAsInt());
    }

    public void setAlpha(double a) {
        this.newChunksColor = ColorHelper.getColorWithAlpha(this.newChunksColor, (int)a);
        this.inverseColor = ColorHelper.getColorWithAlpha(this.inverseColor, (int)a);
    }

    public Long2LongMap getNewChunkHighlightsState(ResourceKey<Level> dimension) {
        return this.newChunksCache.get().getCacheMap(dimension);
    }

    public Long2LongMap getInverseNewChunkHighlightsState(ResourceKey<Level> dimension) {
        return this.inverseNewChunksCache.get().getCacheMap(dimension);
    }

    public boolean isNewChunk(int chunkPosX, int chunkPosZ, ResourceKey<Level> dimensionId) {
        return this.newChunksCache.get().isHighlighted(chunkPosX, chunkPosZ, dimensionId);
    }

    public boolean isInverseNewChunk(int chunkPosX, int chunkPosZ, ResourceKey<Level> dimensionId) {
        return this.inverseNewChunksCache.get().isHighlighted(chunkPosX, chunkPosZ, dimensionId);
    }
}

