/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.buffered;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.IntSupplier;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_6367;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import xaeroplus.feature.render.buffered.Model;
import xaeroplus.module.impl.FpsLimiter;
import xaeroplus.settings.Settings;

public class BufferedComponent {
    private static final class_310 mc = class_310.method_1551();
    private Model model = null;
    private final class_276 renderTarget = new class_6367(100, 100, true);
    private long nextRenderCapture = System.currentTimeMillis();
    private final IntSupplier fpsLimitSupplier;
    private final Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());

    public BufferedComponent(IntSupplier fpsLimitSupplier) {
        this.fpsLimitSupplier = fpsLimitSupplier;
    }

    private void refreshModel(int screenWidth, int screenHeight) {
        if (this.model != null) {
            this.model.close();
        }
        Vector3f[] posMatrix = new Vector3f[]{new Vector3f(0.0f, (float)screenHeight, 1.0f), new Vector3f((float)screenWidth, (float)screenHeight, 1.0f), new Vector3f((float)screenWidth, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f)};
        Vector2f[] texUvMatrix = new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f), new Vector2f(1.0f, 1.0f), new Vector2f(0.0f, 1.0f)};
        this.model = new Model(posMatrix, texUvMatrix);
    }

    public boolean render() {
        int windowWidth = mc.method_22683().method_4489();
        int windowHeight = mc.method_22683().method_4506();
        boolean forceRender = false;
        if (this.renderTarget.field_1482 != windowWidth || this.renderTarget.field_1481 != windowHeight) {
            this.renderTarget.method_1234(windowWidth, windowHeight);
            this.refreshModel(windowWidth, windowHeight);
            forceRender = true;
        }
        if (this.model == null) {
            this.refreshModel(windowWidth, windowHeight);
            forceRender = true;
        }
        if (forceRender || System.currentTimeMillis() > this.nextRenderCapture) {
            this.renderTarget.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
            this.renderTarget.method_1230();
            this.renderTarget.method_1235(false);
            FpsLimiter.renderTargetOverwrite = this.renderTarget;
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            this.renderTarget.method_1235(false);
            return false;
        }
        this.renderBufferedTexture(this.renderTarget.method_30277());
        return true;
    }

    public void postRender() {
        FpsLimiter.renderTargetOverwrite = null;
        this.renderTarget.method_1240();
        mc.method_1522().method_1235(true);
        this.nextRenderCapture = System.currentTimeMillis() + (long)(1000 / this.fpsLimitSupplier.getAsInt());
        this.renderBufferedTexture(this.renderTarget.method_30277());
    }

    private void renderBufferedTexture(int textureId) {
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader((class_10156)class_10142.field_53879);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (int)textureId);
        this.modelViewMatrix.set((Matrix4fc)RenderSystem.getModelViewMatrix());
        this.modelViewMatrix.translate(0.0f, 0.0f, 399.0f + (float)Settings.REGISTRY.minimapRenderZOffsetSetting.get());
        float guiScale = (float)Math.max(1.0, mc.method_22683().method_4495());
        this.modelViewMatrix.scale(1.0f / guiScale);
        this.model.draw(this.modelViewMatrix);
    }
}

