/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlight;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_5944;
import net.minecraft.class_8555;
import net.minecraft.class_9801;
import xaeroplus.feature.render.DrawContext;
import xaeroplus.feature.render.highlight.AbstractHighlightVertexBuffer;
import xaeroplus.feature.render.shaders.XaeroPlusShaders;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class HighlightVertexBuffer
extends AbstractHighlightVertexBuffer {
    @Override
    public void preRender(DrawContext ctx, Long2LongMap highlights, int color) {
        super.preRender(ctx, highlights, color);
        XaeroPlusShaders.setMapViewMatrix(ctx.matrixStack().method_23760().method_23761());
        float a = ColorHelper.getA(color);
        float r = ColorHelper.getR(color);
        float g = ColorHelper.getG(color);
        float b = ColorHelper.getB(color);
        XaeroPlusShaders.setHighlightColor(r, g, b, a);
    }

    @Override
    public void refresh(DrawContext ctx, Long2LongMap highlights, int color) {
        this.stale = false;
        this.lastRefreshed = System.currentTimeMillis();
        this.flipped = ctx.worldmap();
        if (highlights.isEmpty() || ColorHelper.getA(color) == 0.0f) {
            this.close();
            return;
        }
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        for (Long highlight : highlights.keySet()) {
            int chunkPosX = ChunkUtils.longToChunkX(highlight);
            int chunkPosZ = ChunkUtils.longToChunkZ(highlight);
            float x1 = chunkPosX;
            float x2 = chunkPosX + 1;
            float y1 = this.flipped ? (float)(chunkPosZ + 1) : (float)chunkPosZ;
            float y2 = this.flipped ? (float)chunkPosZ : (float)(chunkPosZ + 1);
            bufferBuilder.method_22912(x1, y2, 0.0f);
            bufferBuilder.method_22912(x2, y2, 0.0f);
            bufferBuilder.method_22912(x2, y1, 0.0f);
            bufferBuilder.method_22912(x1, y1, 0.0f);
        }
        if (this.vertexBuffer == null || this.vertexBuffer.method_43444()) {
            this.close();
            this.vertexBuffer = new class_291(class_8555.field_54340);
        }
        class_9801 meshData = bufferBuilder.method_60800();
        this.vertexBuffer.method_1353();
        this.vertexBuffer.method_1352(meshData);
    }

    @Override
    public class_5944 shaderInstance() {
        return class_310.method_1551().method_62887().method_62947(XaeroPlusShaders.HIGHLIGHT_SHADER_PROGRAM);
    }
}

