/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import xaeroplus.Globals;
import xaeroplus.feature.render.DrawFeatureFactory;
import xaeroplus.feature.render.line.Line;
import xaeroplus.module.Module;
import xaeroplus.util.ColorHelper;

public class WorldBorder
extends Module {
    private final int color = ColorHelper.getColor(0, 255, 255, 204);

    @Override
    public void onEnable() {
        Globals.drawManager.registry().register(DrawFeatureFactory.lines("WorldBorder", this::getLines, this::getColor, this::getLineWidth, 1000));
    }

    @Override
    public void onDisable() {
        Globals.drawManager.registry().unregister("WorldBorder");
    }

    List<Line> getLines(int windowRegionX, int windowRegionZ, int windowRegionSize, ResourceKey<Level> dimension) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return Collections.emptyList();
        }
        if (level.m_46472_() != dimension) {
            return Collections.emptyList();
        }
        net.minecraft.world.level.border.WorldBorder worldBorder = level.m_6857_();
        int minX = Mth.m_14107_((double)worldBorder.m_61955_());
        int minZ = Mth.m_14107_((double)worldBorder.m_61956_());
        int maxX = Mth.m_14107_((double)worldBorder.m_61957_());
        int maxZ = Mth.m_14107_((double)worldBorder.m_61958_());
        return List.of(new Line(minX, minZ, maxX, minZ), new Line(maxX, minZ, maxX, maxZ), new Line(maxX, maxZ, minX, maxZ), new Line(minX, minZ, minX, maxZ));
    }

    int getColor() {
        return this.color;
    }

    float getLineWidth() {
        return 0.1f;
    }
}

