/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.event.WaystoneRemoveReceivedEvent;
import net.blay09.mods.waystones.api.event.WaystoneUpdateReceivedEvent;
import net.blay09.mods.waystones.api.event.WaystonesListReceivedEvent;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import xaero.hud.minimap.waypoint.WaypointColor;
import xaeroplus.module.impl.WaystoneSync;

public class BlayWaystonesHelper {
    public Map<class_2960, ArrayList<Waystone>> currentWaystoneTypeMap = new ConcurrentHashMap<class_2960, ArrayList<Waystone>>();
    public boolean shouldSync = false;
    private boolean subscribed = false;
    public final Object lock = new Object();

    public void subscribeWaystonesEvent() {
        if (this.subscribed) {
            return;
        }
        Balm.getEvents().onEvent(WaystonesListReceivedEvent.class, this::onWaystonesListReceivedEvent);
        Balm.getEvents().onEvent(WaystoneUpdateReceivedEvent.class, this::onWaystoneUpdateReceived);
        Balm.getEvents().onEvent(WaystoneRemoveReceivedEvent.class, this::onWaystoneRemoveReceived);
        this.subscribed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onWaystoneRemoveReceived(WaystoneRemoveReceivedEvent event) {
        if (this.isCompatibleWaystoneType(event.getWaystoneType())) {
            Object object = this.lock;
            synchronized (object) {
                ArrayList<Waystone> waystones = this.currentWaystoneTypeMap.get(event.getWaystoneType());
                if (waystones == null) {
                    return;
                }
                waystones.removeIf(waystone -> waystone.getWaystoneUid().equals(event.getWaystoneId()));
                if (waystones.isEmpty()) {
                    this.currentWaystoneTypeMap.remove(event.getWaystoneType());
                }
                this.shouldSync = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onWaystoneUpdateReceived(WaystoneUpdateReceivedEvent event) {
        if (this.isCompatibleWaystoneType(event.getWaystone().getWaystoneType())) {
            Object object = this.lock;
            synchronized (object) {
                ArrayList<Waystone> waystones = this.currentWaystoneTypeMap.get(event.getWaystone().getWaystoneType());
                if (waystones == null) {
                    return;
                }
                waystones.removeIf(waystone -> waystone.getWaystoneUid().equals(event.getWaystone().getWaystoneUid()));
                waystones.add(event.getWaystone());
                this.shouldSync = true;
            }
        }
    }

    private boolean isCompatibleWaystoneType(class_2960 waystoneType) {
        return waystoneType.equals((Object)WaystoneTypes.WAYSTONE) || WaystoneTypes.isSharestone((class_2960)waystoneType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWaystonesListReceivedEvent(WaystonesListReceivedEvent event) {
        if (this.isCompatibleWaystoneType(event.getWaystoneType())) {
            Object object = this.lock;
            synchronized (object) {
                this.currentWaystoneTypeMap.put(event.getWaystoneType(), new ArrayList(event.getWaystones()));
                this.shouldSync = true;
            }
        }
    }

    public List<WaystoneSync.Waystone> getCurrentWaystones() {
        return this.currentWaystoneTypeMap.values().stream().flatMap(Collection::stream).map(waystone -> {
            String colorName;
            class_1767 dyeColor;
            String keyPath;
            int suffixIndex;
            WaypointColor color = null;
            if (WaystoneTypes.isSharestone((class_2960)waystone.getWaystoneType()) && (suffixIndex = (keyPath = waystone.getWaystoneType().method_12832()).lastIndexOf("_sharestone")) != -1 && (dyeColor = class_1767.method_7793((String)(colorName = keyPath.substring(0, suffixIndex)), null)) != null) {
                color = switch (dyeColor) {
                    default -> throw new IncompatibleClassChangeError();
                    case class_1767.field_7952 -> WaypointColor.WHITE;
                    case class_1767.field_7946 -> WaypointColor.GOLD;
                    case class_1767.field_7958 -> WaypointColor.DARK_PURPLE;
                    case class_1767.field_7951 -> WaypointColor.AQUA;
                    case class_1767.field_7947 -> WaypointColor.YELLOW;
                    case class_1767.field_7961 -> WaypointColor.GREEN;
                    case class_1767.field_7942 -> WaypointColor.DARK_GREEN;
                    case class_1767.field_7954 -> WaypointColor.PURPLE;
                    case class_1767.field_7945 -> WaypointColor.BLUE;
                    case class_1767.field_7944 -> WaypointColor.DARK_GRAY;
                    case class_1767.field_7967 -> WaypointColor.GRAY;
                    case class_1767.field_7955 -> WaypointColor.DARK_AQUA;
                    case class_1767.field_7966 -> WaypointColor.DARK_BLUE;
                    case class_1767.field_7957 -> WaypointColor.DARK_RED;
                    case class_1767.field_7964 -> WaypointColor.RED;
                    case class_1767.field_7963 -> WaypointColor.BLACK;
                };
            }
            return new WaystoneSync.Waystone(waystone.getName().getString(), (class_5321<class_1937>)waystone.getDimension(), waystone.getPos().method_10263(), waystone.getPos().method_10264() + 1, waystone.getPos().method_10260(), color);
        }).toList();
    }
}

