/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.beacon;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_822;
import net.minecraft.class_898;
import xaero.common.HudMod;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointVisibilityType;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.Minimap;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointPurpose;
import xaero.hud.minimap.waypoint.render.world.WaypointWorldRenderer;
import xaero.hud.minimap.world.MinimapWorld;
import xaeroplus.XaeroPlus;
import xaeroplus.settings.Settings;

public class WaypointBeaconRenderer {
    public static final WaypointBeaconRenderer INSTANCE = new WaypointBeaconRenderer();
    private final List<Waypoint> waypointList = new ArrayList<Waypoint>();
    private long lastWaypointRenderListUpdate = -1L;
    private int errorCount = 0;

    public void renderHook(class_4587 matrix, float tickDelta) {
        block7: {
            if (!Settings.REGISTRY.waypointBeacons.get()) {
                return;
            }
            HudMod hudMod = HudMod.INSTANCE;
            if (hudMod == null) {
                return;
            }
            Minimap minimap = hudMod.getMinimap();
            if (minimap == null) {
                return;
            }
            WaypointWorldRenderer waypointsIngameRenderer = minimap.getWaypointWorldRenderer();
            if (waypointsIngameRenderer == null) {
                return;
            }
            MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
            if (minimapSession == null) {
                return;
            }
            try {
                INSTANCE.renderWaypointBeacons(tickDelta, matrix);
            }
            catch (Exception e) {
                if (this.errorCount++ >= 2) break block7;
                XaeroPlus.LOGGER.error("Error rendering waypoints", (Throwable)e);
            }
        }
    }

    public void updateWaypointRenderList(MinimapSession session, ModSettings settings) {
        this.waypointList.clear();
        session.getWaypointSession().getCollector().collect(this.waypointList);
        this.waypointList.removeIf(w -> {
            if (w.isDisabled() || w.getVisibility() == WaypointVisibilityType.WORLD_MAP_LOCAL || w.getVisibility() == WaypointVisibilityType.WORLD_MAP_GLOBAL) {
                return true;
            }
            return !settings.getDeathpoints() && w.getPurpose().isDeath();
        });
        this.waypointList.sort(Waypoint::compareTo);
    }

    public void renderWaypointBeacons(float tickDelta, class_4587 matrixStack) {
        MinimapSession session = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        if (session == null) {
            return;
        }
        ModSettings settings = HudMod.INSTANCE.getSettings();
        if (settings == null) {
            return;
        }
        if (!settings.getShowIngameWaypoints()) {
            return;
        }
        MinimapWorld currentWorld = session.getWorldManager().getCurrentWorld();
        if (currentWorld == null) {
            return;
        }
        if (System.currentTimeMillis() - this.lastWaypointRenderListUpdate > 50L) {
            this.updateWaypointRenderList(session, settings);
            this.lastWaypointRenderListUpdate = System.currentTimeMillis();
        }
        double dimDiv = session.getDimensionHelper().getDimensionDivision(currentWorld);
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1719 == null) {
            return;
        }
        class_243 cameraPos = mc.field_1719.method_19538();
        double distanceScale = settings.dimensionScaledMaxWaypointDistance ? mc.field_1687.method_8597().comp_646() : 1.0;
        double waypointsDistance = settings.getMaxWaypointsDistance();
        double waypointsDistanceMin = settings.waypointsDistanceMin;
        for (int i = 0; i < this.waypointList.size(); ++i) {
            boolean shouldRender;
            WaypointPurpose purpose;
            Waypoint w = this.waypointList.get(i);
            double offX = (double)w.getX(dimDiv) - cameraPos.field_1352 + 0.5;
            double offZ = (double)w.getZ(dimDiv) - cameraPos.field_1350 + 0.5;
            double unscaledDistance2D = Math.sqrt(offX * offX + offZ * offZ);
            double distance2D = unscaledDistance2D * distanceScale;
            if (Settings.REGISTRY.limitDeathpointsRenderDistance.get() && (purpose = w.getPurpose()) == WaypointPurpose.DEATH && Settings.REGISTRY.limitDeathpointsRenderDistance.get() && waypointsDistance != 0.0 && distance2D > waypointsDistance) continue;
            boolean bl = shouldRender = w.isDestination() || (w.getPurpose().isDeath() || w.isGlobal() || w.isTemporary() && settings.temporaryWaypointsGlobal || waypointsDistance == 0.0 || !(distance2D > waypointsDistance)) && (waypointsDistanceMin == 0.0 || !(unscaledDistance2D < waypointsDistanceMin));
            if (!shouldRender) continue;
            this.renderWaypointBeacon(w, dimDiv, tickDelta, matrixStack);
        }
    }

    public void renderWaypointBeacon(Waypoint waypoint, double dimDiv, float tickDelta, class_4587 matrixStack) {
        class_243 waypointVec;
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1719 == null) {
            return;
        }
        class_243 playerVec = mc.field_1719.method_19538();
        double xzDistance = playerVec.method_1022(waypointVec = new class_243((double)waypoint.getX(dimDiv), playerVec.field_1351, (double)waypoint.getZ(dimDiv)));
        if (xzDistance < (double)Settings.REGISTRY.waypointBeaconDistanceMin.getAsInt()) {
            return;
        }
        int farScale = Settings.REGISTRY.waypointBeaconScaleMin.getAsInt();
        double maxRenderDistance = Math.min((Integer)mc.field_1690.method_42503().method_41753() << 4, farScale == 0 ? Integer.MAX_VALUE : farScale << 4);
        if (xzDistance > maxRenderDistance) {
            class_243 delta = waypointVec.method_1020(playerVec).method_1029();
            waypointVec = playerVec.method_1019(new class_243(delta.field_1352 * maxRenderDistance, delta.field_1351 * maxRenderDistance, delta.field_1350 * maxRenderDistance));
        }
        class_898 entityRenderDispatcher = mc.method_1561();
        class_4184 camera = entityRenderDispatcher.field_4686;
        class_4604 frustum = mc.field_1769.field_27740;
        if (camera == null || frustum == null) {
            return;
        }
        double viewX = camera.method_19326().method_10216();
        double viewZ = camera.method_19326().method_10215();
        double x = waypointVec.field_1352 - viewX;
        double z = waypointVec.field_1350 - viewZ;
        double y = -100.0;
        if (!frustum.method_23093(new class_238(waypointVec.field_1352 - 1.0, -100.0, waypointVec.field_1350 - 1.0, waypointVec.field_1352 + 1.0, 500.0, waypointVec.field_1350 + 1.0))) {
            return;
        }
        int color = waypoint.getWaypointColor().getHex();
        class_4597.class_4598 entityVertexConsumers = mc.method_22940().method_23000();
        long time = mc.field_1687.method_8510();
        matrixStack.method_22903();
        matrixStack.method_22904(x, -100.0, z);
        class_822.method_3545((class_4587)matrixStack, (class_4597)entityVertexConsumers, (class_2960)class_822.field_4338, (float)tickDelta, (float)1.0f, (long)time, (int)0, (int)355, (int)color, (float)0.2f, (float)0.25f);
        matrixStack.method_22909();
    }
}

