/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.llamalad7.mixinextras.sugar.ref.LocalLongRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xaero.map.MapProcessor;
import xaero.map.MapWriter;
import xaero.map.biome.BlockTintProvider;
import xaero.map.region.MapRegion;
import xaero.map.region.OverlayBuilder;
import xaero.map.region.OverlayManager;
import xaero.map.world.MapWorld;
import xaeroplus.feature.extensions.CustomMapProcessor;
import xaeroplus.settings.Settings;
import xaeroplus.util.ChunkUtils;

@Mixin(value={MapWriter.class}, remap=false)
public abstract class MixinMapWriter {
    @Unique
    private final Cache<Long, Long> xaeroPlus$tileUpdateCache = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(5L, TimeUnit.SECONDS).build();
    @Shadow
    private MapProcessor mapProcessor;
    @Shadow
    @Final
    private class_2338.class_2339 mutableLocalPos;
    @Shadow
    public long writeFreeSinceLastWrite;

    @Inject(method={"loadPixel"}, at={@At(value="HEAD")}, remap=false)
    public void setObsidianColumnLocalVar(CallbackInfo ci, @Share(value="columnRoofObsidian") LocalBooleanRef columnRoofObsidianRef) {
        if (!Settings.REGISTRY.transparentObsidianRoofSetting.get()) {
            return;
        }
        columnRoofObsidianRef.set(false);
    }

    @Inject(method={"loadPixel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getFluidState()Lnet/minecraft/world/level/material/FluidState;", ordinal=0)}, remap=true)
    public void obsidianRoofHeadInject(CallbackInfo ci, @Local(argsOnly=true) class_2818 bchunk, @Local(name={"state"}) LocalRef<class_2680> stateRef, @Local(name={"h"}) LocalIntRef hRef, @Local(name={"transparentSkipY"}) LocalIntRef transparentSkipYRef, @Share(value="columnRoofObsidian") LocalBooleanRef columnRoofObsidianRef) {
        boolean blockHeightAboveYLimit;
        if (!Settings.REGISTRY.transparentObsidianRoofSetting.get()) {
            return;
        }
        class_2248 b = ((class_2680)stateRef.get()).method_26204();
        boolean bl = blockHeightAboveYLimit = (double)hRef.get() >= Settings.REGISTRY.transparentObsidianRoofYSetting.get();
        if (blockHeightAboveYLimit) {
            boolean shouldMakeTransparent;
            boolean bl2 = shouldMakeTransparent = b == class_2246.field_10540 || b == class_2246.field_22423;
            if (b == class_2246.field_10477) {
                this.mutableLocalPos.method_33098(hRef.get() - 1);
                class_2680 belowState = bchunk.method_8320((class_2338)this.mutableLocalPos);
                this.mutableLocalPos.method_33098(hRef.get());
                boolean bl3 = shouldMakeTransparent = belowState.method_26204() == class_2246.field_10540 || belowState.method_26204() == class_2246.field_22423;
            }
            if (shouldMakeTransparent) {
                if (Settings.REGISTRY.transparentObsidianRoofDarkeningSetting.get() == 0.0) {
                    stateRef.set((Object)class_2246.field_10124.method_9564());
                    transparentSkipYRef.set(transparentSkipYRef.get() - 1);
                }
                if (!columnRoofObsidianRef.get()) {
                    columnRoofObsidianRef.set(true);
                }
            }
        }
    }

    @WrapOperation(method={"loadPixel"}, at={@At(value="INVOKE", target="Lxaero/map/region/OverlayBuilder;isEmpty()Z")}, remap=false)
    public boolean checkObsidianRoofColumn(OverlayBuilder instance, Operation<Boolean> original, @Share(value="columnRoofObsidian") LocalBooleanRef columnRoofObsidianRef) {
        if (!Settings.REGISTRY.transparentObsidianRoofSetting.get()) {
            return (Boolean)original.call(new Object[]{instance});
        }
        return (Boolean)original.call(new Object[]{instance}) != false || columnRoofObsidianRef.get();
    }

    @ModifyExpressionValue(method={"loadPixelHelp"}, at={@At(value="INVOKE", target="Lxaero/map/MapWriter;shouldOverlayCached(Lnet/minecraft/world/level/block/state/StateHolder;)Z", ordinal=0)}, remap=true)
    public boolean obsidianRoofOverlayMod(boolean original, @Local(argsOnly=true) class_2818 bChunk, @Local(name={"b"}) class_2248 b, @Local(name={"h"}) int h) {
        if (Settings.REGISTRY.transparentObsidianRoofSetting.get() && (double)h > Settings.REGISTRY.transparentObsidianRoofYSetting.get()) {
            if (b == class_2246.field_10540 || b == class_2246.field_22423) {
                return true;
            }
            if (b == class_2246.field_10477) {
                this.mutableLocalPos.method_33098(h - 1);
                class_2680 belowState = bChunk.method_8320((class_2338)this.mutableLocalPos);
                this.mutableLocalPos.method_33098(h);
                return belowState.method_26204() == class_2246.field_10540 || belowState.method_26204() == class_2246.field_22423;
            }
        }
        return original;
    }

    @WrapOperation(method={"loadPixelHelp"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getLightBlock()I", ordinal=1)}, remap=true)
    public int getOpacityForObsidianRoof(class_2680 instance, Operation<Integer> original, @Local(argsOnly=true) class_1937 world, @Local(name={"h"}) int h) {
        if (Settings.REGISTRY.transparentObsidianRoofSetting.get() && (double)h > Settings.REGISTRY.transparentObsidianRoofYSetting.get()) {
            boolean shouldMakeTransparent;
            boolean bl = shouldMakeTransparent = instance.method_26204() == class_2246.field_10540 || instance.method_26204() == class_2246.field_22423;
            if (instance.method_26204() == class_2246.field_10477) {
                this.mutableLocalPos.method_33098(h - 1);
                class_2680 belowState = world.method_8320((class_2338)this.mutableLocalPos);
                this.mutableLocalPos.method_33098(h);
                if (belowState.method_26204() == class_2246.field_10540 || belowState.method_26204() == class_2246.field_22423) {
                    shouldMakeTransparent = true;
                }
            }
            if (shouldMakeTransparent) {
                return 5;
            }
        }
        return (Integer)original.call(new Object[]{instance});
    }

    @Inject(method={"onRender"}, at={@At(value="FIELD", target="Lxaero/map/MapWriter;lastWrite:J", opcode=180, ordinal=2)})
    public void fastMapMaxTilesPerCycleSetting(CallbackInfo ci, @Local(name={"tilesToUpdate"}) LocalLongRef tilesToUpdateRef, @Local(name={"sizeTiles"}) int sizeTiles) {
        if (Settings.REGISTRY.fastMapSetting.get()) {
            this.writeFreeSinceLastWrite = Math.max(1L, this.writeFreeSinceLastWrite);
            if (this.mapProcessor.getCurrentCaveLayer() == Integer.MAX_VALUE) {
                tilesToUpdateRef.set((long)Math.min((double)sizeTiles, Settings.REGISTRY.fastMapMaxTilesPerCycle.get()));
            }
        }
    }

    @ModifyExpressionValue(method={"onRender"}, at={@At(value="INVOKE", target="Ljava/lang/System;nanoTime()J", ordinal=2)})
    public long removeWriteTimeLimiterPerFrame(long original) {
        if (Settings.REGISTRY.fastMapSetting.get() && this.mapProcessor.getCurrentCaveLayer() == Integer.MAX_VALUE) {
            return 0L;
        }
        return original;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @WrapOperation(method={"writeMap"}, at={@At(value="INVOKE", target="Lxaero/map/MapWriter;writeChunk(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/Registry;IZLnet/minecraft/core/Registry;Lxaero/map/region/OverlayManager;ZZZZZLnet/minecraft/core/BlockPos$MutableBlockPos;Lxaero/map/biome/BlockTintProvider;IIIIIIIII)Z")}, remap=true)
    public boolean fastMap(MapWriter instance, class_1937 world, class_2378<class_2248> blockRegistry, int distance, boolean onlyLoad, class_2378<class_1959> biomeRegistry, OverlayManager overlayManager, boolean loadChunks, boolean updateChunks, boolean ignoreHeightmaps, boolean flowers, boolean detailedDebug, class_2338.class_2339 mutableBlockPos3, BlockTintProvider blockTintProvider, int caveDepth, int caveStart, int layerToWrite, int tileChunkX, int tileChunkZ, int tileChunkLocalX, int tileChunkLocalZ, int chunkX, int chunkZ, Operation<Boolean> original) {
        if (!Settings.REGISTRY.fastMapSetting.get() || this.mapProcessor.getCurrentCaveLayer() != Integer.MAX_VALUE) return (Boolean)original.call(new Object[]{instance, world, blockRegistry, distance, onlyLoad, biomeRegistry, overlayManager, loadChunks, updateChunks, ignoreHeightmaps, flowers, detailedDebug, mutableBlockPos3, blockTintProvider, caveDepth, caveStart, layerToWrite, tileChunkX, tileChunkZ, tileChunkLocalX, tileChunkLocalZ, chunkX, chunkZ});
        Long cacheable = ChunkUtils.chunkPosToLong(chunkX, chunkZ);
        Long cacheValue = this.xaeroPlus$tileUpdateCache.getIfPresent(cacheable);
        if (Objects.nonNull(cacheValue)) {
            if (cacheValue >= System.currentTimeMillis() - (long)Settings.REGISTRY.fastMapWriterDelaySetting.get()) return false;
            this.xaeroPlus$tileUpdateCache.put(cacheable, System.currentTimeMillis());
            return (Boolean)original.call(new Object[]{instance, world, blockRegistry, distance, onlyLoad, biomeRegistry, overlayManager, loadChunks, updateChunks, ignoreHeightmaps, flowers, detailedDebug, mutableBlockPos3, blockTintProvider, caveDepth, caveStart, layerToWrite, tileChunkX, tileChunkZ, tileChunkLocalX, tileChunkLocalZ, chunkX, chunkZ});
        } else {
            this.xaeroPlus$tileUpdateCache.put(cacheable, System.currentTimeMillis());
        }
        return (Boolean)original.call(new Object[]{instance, world, blockRegistry, distance, onlyLoad, biomeRegistry, overlayManager, loadChunks, updateChunks, ignoreHeightmaps, flowers, detailedDebug, mutableBlockPos3, blockTintProvider, caveDepth, caveStart, layerToWrite, tileChunkX, tileChunkZ, tileChunkLocalX, tileChunkLocalZ, chunkX, chunkZ});
    }

    @Inject(method={"loadPixel"}, at={@At(value="HEAD")}, remap=false)
    public void netherCaveFixInject(CallbackInfo ci, @Local(argsOnly=true) class_1937 world, @Local(index=10, argsOnly=true) LocalBooleanRef caveRef, @Local(index=11, argsOnly=true) LocalBooleanRef fullCaveRef) {
        if (Settings.REGISTRY.netherCaveFix.get()) {
            boolean nether = world.method_27983() == class_1937.field_25180;
            boolean shouldForceFullInNether = !caveRef.get() && nether;
            caveRef.set(shouldForceFullInNether || caveRef.get());
            fullCaveRef.set(shouldForceFullInNether || fullCaveRef.get());
        }
    }

    @WrapOperation(method={"onRender"}, at={@At(value="INVOKE", target="Lxaero/map/world/MapWorld;getCurrentDimensionId()Lnet/minecraft/resources/ResourceKey;")}, remap=true)
    public class_5321<class_1937> removeCustomDimSwitchWriterPrevention(MapWorld mapWorld, Operation<class_5321<class_1937>> original) {
        class_638 world = this.mapProcessor.getWorld();
        return Settings.REGISTRY.writesWhileDimSwitched.get() && world != null && mapWorld.isMultiplayer() ? world.method_27983() : (class_5321)original.call(new Object[]{mapWorld});
    }

    @Inject(method={"onRender"}, at={@At(value="HEAD")})
    public void setCrossDimWriteSignals(CallbackInfo ci) {
        boolean signal = Settings.REGISTRY.writesWhileDimSwitched.get() && this.mapProcessor.getWorld() != null && this.mapProcessor.getMapWorld().isMultiplayer();
        ((CustomMapProcessor)this.mapProcessor).xaeroPlus$getLeafRegionActualDimSignal().set(signal);
        ((CustomMapProcessor)this.mapProcessor).xaeroPlus$getCurrentDimensionActualDimSignal().set(signal);
    }

    @Inject(method={"onRender"}, at={@At(value="RETURN")})
    public void resetSignals(CallbackInfo ci) {
        ((CustomMapProcessor)this.mapProcessor).xaeroPlus$getLeafRegionActualDimSignal().set(false);
        ((CustomMapProcessor)this.mapProcessor).xaeroPlus$getCurrentDimensionActualDimSignal().set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapOperation(method={"onRender"}, at={@At(value="INVOKE", target="Lxaero/map/MapProcessor;getLeafMapRegion(IIIZ)Lxaero/map/region/MapRegion;")})
    public MapRegion getActualMapRegionInOnRender(MapProcessor mapProcessor, int caveLayer, int regX, int regZ, boolean create, Operation<MapRegion> original) {
        if (Settings.REGISTRY.writesWhileDimSwitched.get() && mapProcessor.getMapWorld().isMultiplayer()) {
            ((CustomMapProcessor)mapProcessor).xaeroPlus$getLeafRegionActualDimSignal().set(true);
        }
        try {
            MapRegion mapRegion = (MapRegion)original.call(new Object[]{mapProcessor, caveLayer, regX, regZ, create});
            return mapRegion;
        }
        finally {
            ((CustomMapProcessor)mapProcessor).xaeroPlus$getLeafRegionActualDimSignal().set(false);
        }
    }
}

