/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlight;

import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.CompiledShaderProgram;
import xaeroplus.feature.render.DrawContext;
import xaeroplus.feature.render.highlight.AbstractHighlightVertexBuffer;
import xaeroplus.feature.render.highlight.MultiColorHighlightColorFunction;
import xaeroplus.feature.render.shaders.XaeroPlusShaders;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class MultiColorHighlightVertexBuffer
extends AbstractHighlightVertexBuffer {
    private final MultiColorHighlightColorFunction colorFunction;

    public MultiColorHighlightVertexBuffer(MultiColorHighlightColorFunction colorFunction) {
        this.colorFunction = colorFunction;
    }

    @Override
    public void preRender(DrawContext ctx, Long2LongMap highlights, int color) {
        super.preRender(ctx, highlights, color);
        XaeroPlusShaders.setMultiColorMapViewMatrix(ctx.matrixStack().last().pose());
    }

    @Override
    public void refresh(DrawContext ctx, Long2LongMap highlights, int colorAlpha) {
        MeshData meshData;
        this.stale = false;
        this.lastRefreshed = System.currentTimeMillis();
        this.flipped = ctx.worldmap();
        if (highlights.isEmpty()) {
            this.close();
            return;
        }
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        ObjectIterator it = Long2LongMaps.fastIterator((Long2LongMap)highlights);
        while (it.hasNext()) {
            long foundTime;
            Long2LongMap.Entry entry = (Long2LongMap.Entry)it.next();
            long pos = entry.getLongKey();
            int color = this.colorFunction.getColor(pos, foundTime = entry.getLongValue());
            int alpha = ColorHelper.getIntA(color);
            if (alpha == 0) continue;
            int chunkPosX = ChunkUtils.longToChunkX(pos);
            int chunkPosZ = ChunkUtils.longToChunkZ(pos);
            float x1 = chunkPosX;
            float x2 = chunkPosX + 1;
            float y1 = this.flipped ? (float)(chunkPosZ + 1) : (float)chunkPosZ;
            float y2 = this.flipped ? (float)chunkPosZ : (float)(chunkPosZ + 1);
            bufferBuilder.addVertex(x1, y2, 0.0f).setColor(color);
            bufferBuilder.addVertex(x2, y2, 0.0f).setColor(color);
            bufferBuilder.addVertex(x2, y1, 0.0f).setColor(color);
            bufferBuilder.addVertex(x1, y1, 0.0f).setColor(color);
        }
        if (this.vertexBuffer == null || this.vertexBuffer.isInvalid()) {
            this.close();
            this.vertexBuffer = new VertexBuffer(BufferUsage.STATIC_WRITE);
        }
        if ((meshData = bufferBuilder.build()) == null) {
            this.close();
            return;
        }
        this.vertexBuffer.bind();
        this.vertexBuffer.upload(meshData);
    }

    @Override
    public CompiledShaderProgram shaderInstance() {
        return Minecraft.getInstance().getShaderManager().getProgram(XaeroPlusShaders.MULTI_COLOR_HIGHLIGHT_SHADER_PROGRAM);
    }
}

