/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client.mc;

import com.mojang.blaze3d.pipeline.RenderTarget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ClientTickEvent;
import xaeroplus.module.impl.FpsLimiter;
import xaeroplus.settings.Settings;

@Mixin(value={Minecraft.class}, priority=999)
public class MixinMinecraftClient {
    @Shadow
    public ClientLevel level;

    @Inject(method={"runTick(Z)V"}, at={@At(value="HEAD")})
    public void renderTickHead(CallbackInfo ci) {
        XaeroPlus.EVENT_BUS.call(ClientTickEvent.RenderPre.INSTANCE);
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    public void tickHead(CallbackInfo ci) {
        XaeroPlus.EVENT_BUS.call(ClientTickEvent.Pre.INSTANCE);
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    public void tickReturn(CallbackInfo ci) {
        XaeroPlus.EVENT_BUS.call(ClientTickEvent.Post.INSTANCE);
    }

    @Inject(method={"getMainRenderTarget()Lcom/mojang/blaze3d/pipeline/RenderTarget;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getMainRenderTarget(CallbackInfoReturnable<RenderTarget> ci) {
        if (!Settings.REGISTRY.minimapFpsLimiter.get()) {
            return;
        }
        RenderTarget renderTargetOverwrite = FpsLimiter.renderTargetOverwrite;
        if (renderTargetOverwrite != null) {
            ci.setReturnValue((Object)renderTargetOverwrite);
        }
    }

    @Inject(method={"setLevel(Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/client/gui/screens/ReceivingLevelScreen$Reason;)V"}, at={@At(value="HEAD")})
    public void onLevelChangePre(ClientLevel newWorld, ReceivingLevelScreen.Reason reason, CallbackInfo ci) {
        ClientLevel prev = this.level;
        if (prev != null && newWorld != null) {
            Globals.switchingDimension = true;
        }
    }

    @Inject(method={"setLevel(Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/client/gui/screens/ReceivingLevelScreen$Reason;)V"}, at={@At(value="RETURN")})
    public void onLevelChangePost(CallbackInfo info) {
        Globals.switchingDimension = false;
    }
}

