/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.settings;

import java.util.Objects;
import java.util.function.Consumer;
import xaero.common.settings.ModOptions;
import xaeroplus.XaeroPlus;
import xaeroplus.settings.XaeroPlusSetting;

public class StringSetting
extends XaeroPlusSetting {
    private String value;
    private Consumer<String> settingChangeConsumer;

    public StringSetting(String settingName, String settingNameTranslationKey, String tooltipTranslationKey, String defaultValue, Consumer<String> settingChangeConsumer) {
        super(settingName, settingNameTranslationKey, tooltipTranslationKey, null, () -> true);
        this.value = defaultValue;
        this.settingChangeConsumer = settingChangeConsumer;
    }

    public static StringSetting create(String settingName, String settingNameTranslationKey, String defaultValue, Consumer<String> settingChangeConsumer) {
        return new StringSetting("[XP] " + settingName, settingNameTranslationKey, StringSetting.buildTooltipTranslationKey(settingNameTranslationKey), defaultValue, settingChangeConsumer);
    }

    public static StringSetting create(String settingName, String settingNameTranslationKey, String defaultValue) {
        return StringSetting.create(settingName, settingNameTranslationKey, defaultValue, null);
    }

    @Override
    public void init() {
        if (Objects.nonNull(this.settingChangeConsumer)) {
            this.settingChangeConsumer.accept(this.value);
        }
    }

    @Override
    public String getSerializedValue() {
        return this.value;
    }

    @Override
    public void deserializeValue(String value) {
        if (!value.equals(this.value)) {
            this.setValue(value);
        }
    }

    public void setValue(String value) {
        this.value = value;
        if (Objects.nonNull(this.getSettingChangeConsumer())) {
            try {
                this.getSettingChangeConsumer().accept(value);
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.warn("Error applying setting change consumer for {}", (Object)this.getSettingName(), (Object)e);
            }
        }
    }

    public Consumer<String> getSettingChangeConsumer() {
        return this.settingChangeConsumer;
    }

    public void setSettingChangeConsumer(Consumer<String> settingChangeConsumer) {
        this.settingChangeConsumer = settingChangeConsumer;
    }

    @Override
    public ModOptions toMinimapModOptions() {
        return null;
    }

    @Override
    public xaero.map.settings.ModOptions toWorldMapModOptions() {
        return null;
    }
}

