/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.event.WaystoneRemoveReceivedEvent;
import net.blay09.mods.waystones.api.event.WaystoneUpdateReceivedEvent;
import net.blay09.mods.waystones.api.event.WaystonesListReceivedEvent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import xaero.hud.minimap.waypoint.WaypointColor;
import xaeroplus.module.impl.WaystoneSync;

public class BlayWaystonesHelper {
    public Map<ResourceLocation, ArrayList<Waystone>> currentWaystoneTypeMap = new ConcurrentHashMap<ResourceLocation, ArrayList<Waystone>>();
    public boolean shouldSync = false;
    private boolean subscribed = false;
    public final Object lock = new Object();

    public void subscribeWaystonesEvent() {
        if (this.subscribed) {
            return;
        }
        Balm.getEvents().onEvent(WaystonesListReceivedEvent.class, this::onWaystonesListReceivedEvent);
        Balm.getEvents().onEvent(WaystoneUpdateReceivedEvent.class, this::onWaystoneUpdateReceived);
        Balm.getEvents().onEvent(WaystoneRemoveReceivedEvent.class, this::onWaystoneRemoveReceived);
        this.subscribed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onWaystoneRemoveReceived(WaystoneRemoveReceivedEvent event) {
        if (this.isCompatibleWaystoneType(event.getWaystoneType())) {
            Object object = this.lock;
            synchronized (object) {
                ArrayList<Waystone> waystones = this.currentWaystoneTypeMap.get(event.getWaystoneType());
                if (waystones == null) {
                    return;
                }
                waystones.removeIf(waystone -> waystone.getWaystoneUid().equals(event.getWaystoneId()));
                if (waystones.isEmpty()) {
                    this.currentWaystoneTypeMap.remove(event.getWaystoneType());
                }
                this.shouldSync = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onWaystoneUpdateReceived(WaystoneUpdateReceivedEvent event) {
        if (this.isCompatibleWaystoneType(event.getWaystone().getWaystoneType())) {
            Object object = this.lock;
            synchronized (object) {
                ArrayList<Waystone> waystones = this.currentWaystoneTypeMap.get(event.getWaystone().getWaystoneType());
                if (waystones == null) {
                    return;
                }
                waystones.removeIf(waystone -> waystone.getWaystoneUid().equals(event.getWaystone().getWaystoneUid()));
                waystones.add(event.getWaystone());
                this.shouldSync = true;
            }
        }
    }

    private boolean isCompatibleWaystoneType(ResourceLocation waystoneType) {
        return waystoneType.equals((Object)WaystoneTypes.WAYSTONE) || WaystoneTypes.isSharestone((ResourceLocation)waystoneType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWaystonesListReceivedEvent(WaystonesListReceivedEvent event) {
        if (this.isCompatibleWaystoneType(event.getWaystoneType())) {
            Object object = this.lock;
            synchronized (object) {
                this.currentWaystoneTypeMap.put(event.getWaystoneType(), new ArrayList(event.getWaystones()));
                this.shouldSync = true;
            }
        }
    }

    public List<WaystoneSync.Waystone> getCurrentWaystones() {
        return this.currentWaystoneTypeMap.values().stream().flatMap(Collection::stream).map(waystone -> {
            String colorName;
            DyeColor dyeColor;
            String keyPath;
            int suffixIndex;
            WaypointColor color = null;
            if (WaystoneTypes.isSharestone((ResourceLocation)waystone.getWaystoneType()) && (suffixIndex = (keyPath = waystone.getWaystoneType().getPath()).lastIndexOf("_sharestone")) != -1 && (dyeColor = DyeColor.byName((String)(colorName = keyPath.substring(0, suffixIndex)), null)) != null) {
                color = switch (dyeColor) {
                    default -> throw new MatchException(null, null);
                    case DyeColor.WHITE -> WaypointColor.WHITE;
                    case DyeColor.ORANGE -> WaypointColor.GOLD;
                    case DyeColor.MAGENTA -> WaypointColor.DARK_PURPLE;
                    case DyeColor.LIGHT_BLUE -> WaypointColor.AQUA;
                    case DyeColor.YELLOW -> WaypointColor.YELLOW;
                    case DyeColor.LIME -> WaypointColor.GREEN;
                    case DyeColor.GREEN -> WaypointColor.DARK_GREEN;
                    case DyeColor.PINK -> WaypointColor.PURPLE;
                    case DyeColor.PURPLE -> WaypointColor.BLUE;
                    case DyeColor.GRAY -> WaypointColor.DARK_GRAY;
                    case DyeColor.LIGHT_GRAY -> WaypointColor.GRAY;
                    case DyeColor.CYAN -> WaypointColor.DARK_AQUA;
                    case DyeColor.BLUE -> WaypointColor.DARK_BLUE;
                    case DyeColor.BROWN -> WaypointColor.DARK_RED;
                    case DyeColor.RED -> WaypointColor.RED;
                    case DyeColor.BLACK -> WaypointColor.BLACK;
                };
            }
            return new WaystoneSync.Waystone(waystone.getName().getString(), (ResourceKey<Level>)waystone.getDimension(), waystone.getPos().getX(), waystone.getPos().getY() + 1, waystone.getPos().getZ(), color);
        }).toList();
    }
}

