/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.extensions;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import xaero.map.gui.ScreenSwitchSettingEntry;
import xaeroplus.module.impl.TickTaskExecutor;
import xaeroplus.settings.Settings;
import xaeroplus.util.ColorHelper;
import xaeroplus.util.DrawOrderHelper;

public class DrawOrderScreen
extends Screen {
    static Minecraft mc = Minecraft.m_91087_();
    Screen parent;
    DrawFeatureList drawFeatureList;
    List<String> drawFeatureIdOrder;
    int selected;

    public DrawOrderScreen(Screen parent, Screen escapeScreen) {
        super((Component)Component.m_237115_((String)"xaeroplus.gui.draw_order.title"));
        this.parent = parent;
        this.drawFeatureIdOrder = new ArrayList<String>();
        this.selected = -1;
    }

    public void m_7856_() {
        this.drawFeatureIdOrder = this.loadEntries();
        this.drawFeatureList = new DrawFeatureList(this);
        this.m_7787_((GuiEventListener)this.drawFeatureList);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), b -> mc.m_91152_(this.parent)).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 34, 200, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"xaeroplus.gui.draw_order.reset"), b -> TickTaskExecutor.INSTANCE.execute(() -> {
            Settings.REGISTRY.drawOrderSetting.setValue("");
            this.m_6575_(mc, this.f_96543_, this.f_96544_);
        })).m_252987_(this.f_96543_ - 82, 2, 80, 20).m_253136_());
        if (!this.drawFeatureIdOrder.isEmpty()) {
            this.selected = 0;
            this.drawFeatureList.m_7522_((GuiEventListener)this.drawFeatureList.m_264567_());
        }
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.drawFeatureList != null) {
            this.drawFeatureList.releaseDrag();
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.drawFeatureList.m_86412_(poseStack, mouseX, mouseY, partialTick);
        DrawOrderScreen.m_93215_((PoseStack)poseStack, (Font)DrawOrderScreen.mc.f_91062_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)5, (int)-1);
        DrawOrderScreen.m_93215_((PoseStack)poseStack, (Font)DrawOrderScreen.mc.f_91062_, (Component)Component.m_237115_((String)"xaeroplus.gui.draw_order.subtitle"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ - 52), (int)-1);
        super.m_86412_(poseStack, mouseX, mouseY, partialTick);
    }

    public List<String> loadEntries() {
        return DrawOrderHelper.load();
    }

    public void saveEntries(List<String> entries) {
        Settings.REGISTRY.drawOrderSetting.setValue(DrawOrderHelper.serialize(entries));
    }

    public static ScreenSwitchSettingEntry getScreenSwitchSettingEntry() {
        return new ScreenSwitchSettingEntry("Draw Order", DrawOrderScreen::new, null, true);
    }

    public static class DrawFeatureList
    extends ObjectSelectionList<DrawFeatureEntry> {
        boolean dragging;
        int dragStartX;
        int dragStartY;
        int dragged;
        int draggedOffsetX;
        int draggedOffsetY;
        DrawOrderScreen drawOrderScreen;

        public DrawFeatureList(DrawOrderScreen drawOrderScreen) {
            super(mc, drawOrderScreen.f_96543_, drawOrderScreen.f_96544_, 30, drawOrderScreen.f_96544_ - 61, 24);
            this.drawOrderScreen = drawOrderScreen;
            this.dragged = -1;
            this.createEntries().forEach(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0));
            if (drawOrderScreen.selected != -1) {
                this.m_7522_((GuiEventListener)this.m_93500_(drawOrderScreen.selected));
            }
        }

        public boolean m_93696_() {
            return this.drawOrderScreen.m_7222_() == this;
        }

        public void m_7522_(GuiEventListener guiEventListener) {
            if (guiEventListener instanceof DrawFeatureEntry) {
                DrawFeatureEntry entry = (DrawFeatureEntry)guiEventListener;
                this.drawOrderScreen.selected = entry.index;
            }
            if (guiEventListener == null) {
                this.drawOrderScreen.selected = -1;
            }
            super.m_7522_(guiEventListener);
            if (this.m_7222_() == null) {
                this.m_6987_(null);
            }
        }

        List<DrawFeatureEntry> createEntries() {
            ArrayList<DrawFeatureEntry> entries = new ArrayList<DrawFeatureEntry>();
            for (int i = 0; i < this.drawOrderScreen.drawFeatureIdOrder.size(); ++i) {
                DrawFeatureEntry entry = new DrawFeatureEntry(this.drawOrderScreen, this, i);
                entries.add(entry);
            }
            return entries;
        }

        void releaseDrag() {
            this.dragging = false;
            this.dragged = -1;
            this.drawOrderScreen.saveEntries(this.drawOrderScreen.drawFeatureIdOrder);
        }

        public int m_5756_() {
            return this.f_93388_ / 2 + 164;
        }

        public int m_5759_() {
            return 300;
        }

        public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            this.m_93488_(false);
            this.m_93496_(false);
            this.renderBackdrop(poseStack);
            super.m_86412_(poseStack, mouseX, mouseY, partialTicks);
            if (this.dragging) {
                int hoveredIndex;
                DrawFeatureEntry draggedEntry = (DrawFeatureEntry)this.m_93500_(this.dragged);
                draggedEntry.renderEntryText(poseStack, mouseX + this.draggedOffsetX, mouseY + this.draggedOffsetY);
                DrawFeatureEntry hoveredEntry = (DrawFeatureEntry)this.m_93412_(mouseX, mouseY);
                int n = hoveredIndex = hoveredEntry == null ? -1 : hoveredEntry.index;
                if (hoveredIndex != -1 && hoveredIndex != this.dragged) {
                    String draggedId = this.drawOrderScreen.drawFeatureIdOrder.get(this.dragged);
                    int slideDirection = hoveredIndex < this.dragged ? 1 : -1;
                    for (int i = this.dragged; i != hoveredIndex; i -= slideDirection) {
                        this.drawOrderScreen.drawFeatureIdOrder.set(i, this.drawOrderScreen.drawFeatureIdOrder.get(i - slideDirection));
                    }
                    this.drawOrderScreen.drawFeatureIdOrder.set(hoveredIndex, draggedId);
                    this.dragged = hoveredIndex;
                }
            } else if (this.dragged != -1 && (Math.abs(mouseX - this.dragStartX) > 5 || Math.abs(mouseY - this.dragStartY) > 5)) {
                this.dragging = true;
                this.m_7522_(null);
            }
        }

        public void renderBackdrop(PoseStack poseStack) {
            DrawFeatureList.m_93172_((PoseStack)poseStack, (int)0, (int)0, (int)this.f_93388_, (int)this.f_93389_, (int)ColorHelper.getColor(0, 0, 0, 100));
        }
    }

    public static class DrawFeatureEntry
    extends ObjectSelectionList.Entry<DrawFeatureEntry> {
        DrawOrderScreen drawOrderScreen;
        DrawFeatureList drawFeatureList;
        int index;
        int lastRenderX;
        int lastRenderY;
        int lastMouseX;
        int lastMouseY;

        public DrawFeatureEntry(DrawOrderScreen drawOrderScreen, DrawFeatureList drawFeatureList, int index) {
            this.drawOrderScreen = drawOrderScreen;
            this.drawFeatureList = drawFeatureList;
            this.index = index;
        }

        public void renderEntryText(PoseStack poseStack, int x, int y) {
            String id = this.drawOrderScreen.drawFeatureIdOrder.get(this.index);
            GuiComponent.m_93236_((PoseStack)poseStack, (Font)DrawOrderScreen.mc.f_91062_, (String)id, (int)(x + 6), (int)(y + 6), (int)-1);
        }

        public Component m_142172_() {
            return Component.m_237119_();
        }

        public void m_6311_(PoseStack poseStack, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.lastRenderX = x;
            this.lastRenderY = y;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            if (!this.drawFeatureList.dragging || this.drawFeatureList.dragged != index) {
                this.renderEntryText(poseStack, x, y);
            }
        }

        public void m_274437_(PoseStack poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            if (this.drawFeatureList.m_93511_() != this) {
                GuiComponent.m_93172_((PoseStack)poseStack, (int)(left - 2), (int)top, (int)(left - 2 + width), (int)(top + height), (int)ColorHelper.getColor(0, 0, 0, 150));
                GuiComponent.m_274388_((PoseStack)poseStack, (int)(left - 2), (int)top, (int)width, (int)height, (int)ColorHelper.getColor(68, 68, 68, 255));
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.drawFeatureList.dragging = false;
                this.drawFeatureList.dragged = this.index;
                this.drawFeatureList.draggedOffsetX = (int)((double)this.lastRenderX - mouseX);
                this.drawFeatureList.draggedOffsetY = (int)((double)this.lastRenderY - mouseY);
                this.drawFeatureList.dragStartX = (int)mouseX;
                this.drawFeatureList.dragStartY = (int)mouseY;
                if (this.drawFeatureList.m_93511_() != this) {
                    return true;
                }
                this.drawFeatureList.m_7522_(null);
            } else {
                this.drawFeatureList.m_7522_(null);
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        public void m_94757_(double mouseX, double mouseY) {
            this.lastMouseX = (int)mouseX;
            this.lastMouseY = (int)mouseY;
            super.m_94757_(mouseX, mouseY);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            this.lastMouseX = (int)mouseX;
            this.lastMouseY = (int)mouseY;
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
    }
}

