/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import com.llamalad7.mixinextras.injector.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.mods.SupportXaeroWorldmap;
import xaero.map.WorldMapSession;
import xaero.map.region.MapTileChunk;
import xaeroplus.Globals;
import xaeroplus.feature.render.DrawHelper;
import xaeroplus.settings.Settings;

@Mixin(value={SupportXaeroWorldmap.class}, remap=false)
public abstract class MixinSupportXaeroWorldmap {
    @Inject(method={"drawMinimap"}, at={@At(value="INVOKE", target="Lxaero/map/settings/ModSettings;getRegionCacheHashCode()I")}, remap=false)
    public void overrideRegionRange(CallbackInfo ci, @Local(name={"mapX"}) int mapX, @Local(name={"mapZ"}) int mapZ, @Local(name={"minX"}) LocalIntRef minXRef, @Local(name={"maxX"}) LocalIntRef maxXRef, @Local(name={"minZ"}) LocalIntRef minZRef, @Local(name={"maxZ"}) LocalIntRef maxZRef) {
        int scaledSize = Globals.minimapScaleMultiplier * 4;
        minXRef.set((mapX >> 2) - scaledSize);
        maxXRef.set((mapX >> 2) + scaledSize);
        minZRef.set((mapZ >> 2) - scaledSize);
        maxZRef.set((mapZ >> 2) + scaledSize);
    }

    @Inject(method={"renderChunks"}, at={@At(value="HEAD")}, remap=false)
    public void setupTransparentMMBgBuffer(CallbackInfo ci, @Share(value="bgTesselator") LocalRef<Tesselator> bgTesselatorRef, @Share(value="bgBufferBuilder") LocalRef<BufferBuilder> bgBufferBuilderRef) {
        if (Settings.REGISTRY.transparentMinimapBackground.get()) {
            Tesselator bgTesselator = Tesselator.m_85913_();
            bgTesselatorRef.set((Object)bgTesselator);
            BufferBuilder bgBufferBuilder = bgTesselator.m_85915_();
            bgBufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            bgBufferBuilderRef.set((Object)bgBufferBuilder);
        }
    }

    @Inject(method={"renderChunks"}, at={@At(value="INVOKE", target="Lxaero/common/mods/SupportXaeroWorldmap;prepareMapTexturedRect(Lorg/joml/Matrix4f;FFIIFFLxaero/map/region/MapTileChunk;Lxaero/common/graphics/renderer/multitexture/MultiTextureRenderTypeRenderer;Lxaero/common/graphics/renderer/multitexture/MultiTextureRenderTypeRenderer;Lxaero/common/minimap/render/MinimapRendererHelper;)V")}, remap=false)
    public void buildTransparentMMBg(CallbackInfo ci, @Share(value="bgBufferBuilder") LocalRef<BufferBuilder> bgBufferBuilderRef, @Local(argsOnly=true) PoseStack matrixStack, @Local(name={"drawX"}) int drawX, @Local(name={"drawZ"}) int drawZ, @Local(name={"chunk"}) MapTileChunk chunk) {
        if (Settings.REGISTRY.transparentMinimapBackground.get()) {
            DrawHelper.addMMBackgroundToBuffer(matrixStack.m_85850_().m_252922_(), (VertexConsumer)bgBufferBuilderRef.get(), drawX, drawZ, chunk);
        }
    }

    @WrapWithCondition(method={"renderChunks"}, at={@At(value="INVOKE", target="Lxaero/common/mods/SupportXaeroWorldmap;renderSlimeChunks(Lxaero/map/region/MapTileChunk;Ljava/lang/Long;IILcom/mojang/blaze3d/vertex/PoseStack;Lxaero/common/minimap/render/MinimapRendererHelper;Lcom/mojang/blaze3d/vertex/VertexConsumer;)V")}, remap=false)
    public boolean hideSlimeChunksWhileDimSwitched(SupportXaeroWorldmap instance, MapTileChunk chunk, Long seed, int drawX, int drawZ, PoseStack matrixStack, MinimapRendererHelper helper, VertexConsumer overlayBufferBuilder) {
        return Globals.getCurrentDimensionId() != Minecraft.m_91087_().f_91073_.m_46472_();
    }

    @Inject(method={"renderChunks"}, at={@At(value="RETURN")}, remap=false)
    public void drawTransparentMMBackground(CallbackInfo ci, @Share(value="bgTesselator") LocalRef<Tesselator> bgTesselatorRef) {
        if (Settings.REGISTRY.transparentMinimapBackground.get()) {
            ((Tesselator)bgTesselatorRef.get()).m_85914_();
        }
    }

    @Inject(method={"tryToGetMultiworldId"}, at={@At(value="INVOKE", target="Lxaero/map/WorldMapSession;getMapProcessor()Lxaero/map/MapProcessor;")}, cancellable=true, remap=false)
    public void preventPossibleNPE(CallbackInfoReturnable<String> cir, @Local WorldMapSession session) {
        if (session == null) {
            cir.setReturnValue(null);
        }
    }
}

