/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.util;

import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.KnownWaystonesEvent;
import net.blay09.mods.waystones.core.WaystoneTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import xaero.hud.minimap.waypoint.WaypointColor;
import xaeroplus.module.impl.WaystoneSync;

public class BlayWaystonesHelper {
    public List<IWaystone> toSyncWaystones = new ArrayList<IWaystone>();
    public List<IWaystone> currentWaystones = new ArrayList<IWaystone>();
    public boolean shouldSync = false;
    private boolean subscribed = false;

    public void subscribeWaystonesEvent() {
        if (this.subscribed) {
            return;
        }
        Balm.getEvents().onEvent(KnownWaystonesEvent.class, this::onKnownWaystonesEvent);
        this.subscribed = true;
    }

    public void onKnownWaystonesEvent(KnownWaystonesEvent event) {
        this.toSyncWaystones = event.getWaystones();
        this.currentWaystones = event.getWaystones();
        this.shouldSync = true;
    }

    public List<WaystoneSync.Waystone> getToSyncWaystones() {
        return this.toSyncWaystones.stream().map(waystone -> {
            String colorName;
            DyeColor dyeColor;
            String keyPath;
            int suffixIndex;
            WaypointColor color = null;
            if (WaystoneTypes.isSharestone((ResourceLocation)waystone.getWaystoneType()) && (suffixIndex = (keyPath = waystone.getWaystoneType().m_135815_()).lastIndexOf("_sharestone")) != -1 && (dyeColor = DyeColor.m_41057_((String)(colorName = keyPath.substring(0, suffixIndex)), null)) != null) {
                color = switch (dyeColor) {
                    default -> throw new IncompatibleClassChangeError();
                    case DyeColor.WHITE -> WaypointColor.WHITE;
                    case DyeColor.ORANGE -> WaypointColor.GOLD;
                    case DyeColor.MAGENTA -> WaypointColor.DARK_PURPLE;
                    case DyeColor.LIGHT_BLUE -> WaypointColor.AQUA;
                    case DyeColor.YELLOW -> WaypointColor.YELLOW;
                    case DyeColor.LIME -> WaypointColor.GREEN;
                    case DyeColor.GREEN -> WaypointColor.DARK_GREEN;
                    case DyeColor.PINK -> WaypointColor.PURPLE;
                    case DyeColor.PURPLE -> WaypointColor.BLUE;
                    case DyeColor.GRAY -> WaypointColor.DARK_GRAY;
                    case DyeColor.LIGHT_GRAY -> WaypointColor.GRAY;
                    case DyeColor.CYAN -> WaypointColor.DARK_AQUA;
                    case DyeColor.BLUE -> WaypointColor.DARK_BLUE;
                    case DyeColor.BROWN -> WaypointColor.DARK_RED;
                    case DyeColor.RED -> WaypointColor.RED;
                    case DyeColor.BLACK -> WaypointColor.BLACK;
                };
            }
            return new WaystoneSync.Waystone(waystone.getName(), (ResourceKey<Level>)waystone.getDimension(), waystone.getPos().m_123341_(), waystone.getPos().m_123342_() + 1, waystone.getPos().m_123343_(), color);
        }).toList();
    }
}

