/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlight;

import com.mojang.blaze3d.buffers.GpuBuffer;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import org.jetbrains.annotations.Nullable;
import xaeroplus.feature.render.DrawContext;

public abstract class AbstractHighlightVertexBuffer {
    protected boolean stale = true;
    @Nullable
    protected GpuBuffer vertexBuffer = null;
    protected boolean flipped = false;
    public long lastRefreshed = 0L;
    public int indexCount = 0;

    public boolean needsRefresh(DrawContext ctx) {
        return this.vertexBuffer == null || this.vertexBuffer.isClosed() || this.stale || this.flipped != ctx.worldmap();
    }

    public void preRender(DrawContext ctx, Long2LongMap highlights, int color) {
        if (this.needsRefresh(ctx)) {
            this.refresh(ctx, highlights, color);
        }
    }

    public abstract void refresh(DrawContext var1, Long2LongMap var2, int var3);

    public abstract void render(DrawContext var1, Long2LongMap var2, int var3);

    public void markStale() {
        this.stale = true;
    }

    public void close() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
    }
}

