/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.buffered;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class Model {
    private final VertexBuffer vertexBuffer;

    public Model(Vector3f[] posMatrix, Vector2f[] texUvMatrix) {
        BufferBuilder bufferbuilder = Tesselator.getInstance().getBuilder();
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        for (int i = 0; i < posMatrix.length; ++i) {
            Vector3f pos = posMatrix[i];
            Vector2f uv = texUvMatrix[i];
            bufferbuilder.vertex((double)pos.x(), (double)pos.y(), (double)pos.z()).uv(uv.x(), uv.y()).endVertex();
        }
        this.vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        RenderSystem.assertOnRenderThread();
        BufferBuilder.RenderedBuffer renderedBuffer = bufferbuilder.end();
        if (renderedBuffer.isEmpty()) {
            renderedBuffer.release();
        } else {
            this.vertexBuffer.bind();
            this.vertexBuffer.upload(renderedBuffer);
        }
    }

    public void draw(Matrix4f modelViewMatrix) {
        this.vertexBuffer.bind();
        this.vertexBuffer.drawWithShader(modelViewMatrix, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
    }

    public void close() {
        this.vertexBuffer.close();
    }
}

