/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlight;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import net.minecraft.client.renderer.ShaderInstance;
import xaeroplus.feature.render.DrawContext;
import xaeroplus.feature.render.highlight.AbstractHighlightVertexBuffer;
import xaeroplus.feature.render.highlight.MultiColorHighlightColorFunction;
import xaeroplus.feature.render.shaders.MultiColorHighlightShader;
import xaeroplus.feature.render.shaders.XaeroPlusShaders;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class MultiColorHighlightVertexBuffer
extends AbstractHighlightVertexBuffer {
    private final MultiColorHighlightColorFunction colorFunction;

    public MultiColorHighlightVertexBuffer(MultiColorHighlightColorFunction colorFunction) {
        this.colorFunction = colorFunction;
    }

    @Override
    public void preRender(DrawContext ctx, Long2LongMap highlights, int color) {
        super.preRender(ctx, highlights, color);
        MultiColorHighlightShader shader = XaeroPlusShaders.MULTI_COLOR_HIGHLIGHT_SHADER;
        shader.setMapViewMatrix(ctx.matrixStack().last().pose());
    }

    @Override
    public void refresh(DrawContext ctx, Long2LongMap highlights, int colorAlpha) {
        this.stale = false;
        this.lastRefreshed = System.currentTimeMillis();
        this.flipped = ctx.worldmap();
        if (highlights.isEmpty()) {
            this.close();
            return;
        }
        BufferBuilder bufferBuilder = Tesselator.getInstance().getBuilder();
        bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        ObjectIterator it = Long2LongMaps.fastIterator((Long2LongMap)highlights);
        while (it.hasNext()) {
            long foundTime;
            Long2LongMap.Entry entry = (Long2LongMap.Entry)it.next();
            long pos = entry.getLongKey();
            int color = this.colorFunction.getColor(pos, foundTime = entry.getLongValue());
            int alpha = ColorHelper.getIntA(color);
            if (alpha == 0) continue;
            int chunkPosX = ChunkUtils.longToChunkX(pos);
            int chunkPosZ = ChunkUtils.longToChunkZ(pos);
            float x1 = chunkPosX;
            float x2 = chunkPosX + 1;
            float y1 = this.flipped ? (float)(chunkPosZ + 1) : (float)chunkPosZ;
            float y2 = this.flipped ? (float)chunkPosZ : (float)(chunkPosZ + 1);
            bufferBuilder.vertex((double)x1, (double)y2, 0.0).color(color).endVertex();
            bufferBuilder.vertex((double)x2, (double)y2, 0.0).color(color).endVertex();
            bufferBuilder.vertex((double)x2, (double)y1, 0.0).color(color).endVertex();
            bufferBuilder.vertex((double)x1, (double)y1, 0.0).color(color).endVertex();
        }
        if (this.vertexBuffer == null || this.vertexBuffer.isInvalid()) {
            this.close();
            this.vertexBuffer = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
        }
        BufferBuilder.RenderedBuffer meshData = bufferBuilder.end();
        this.vertexBuffer.bind();
        this.vertexBuffer.upload(meshData);
    }

    @Override
    public ShaderInstance shaderInstance() {
        return XaeroPlusShaders.MULTI_COLOR_HIGHLIGHT_SHADER;
    }
}

