/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.line;

import net.minecraft.util.Mth;

public record Line(int x1, int z1, int x2, int z2) {
    public double length() {
        return Math.sqrt(Math.pow(this.x2 - this.x1, 2.0) + Math.pow(this.z2 - this.z1, 2.0));
    }

    public Line extrapolateToWorldBorder() {
        return this.extrapolateToMaxCoord(30000000);
    }

    public Line extrapolateToMaxCoord(int coord) {
        int dx = this.x2() - this.x1();
        if (dx == 0) {
            return new Line(this.x1(), -coord, this.x2(), coord);
        }
        int dz = this.z2() - this.z1();
        if (dz == 0) {
            return new Line(-coord, this.z1(), coord, this.z2());
        }
        double slope = (double)dz / (double)dx;
        double x1 = -coord;
        double intercept = (double)this.z1() - slope * (double)this.x1();
        double z1 = slope * x1 + intercept;
        if (z1 < (double)(-coord)) {
            z1 = -coord;
            x1 = (z1 - intercept) / slope;
        } else if (z1 > (double)coord) {
            z1 = coord;
            x1 = (z1 - intercept) / slope;
        }
        double x2 = coord;
        double z2 = slope * x2 + intercept;
        if (z2 < (double)(-coord)) {
            z2 = -coord;
            x2 = (z2 - intercept) / slope;
        } else if (z2 > (double)coord) {
            z2 = coord;
            x2 = (z2 - intercept) / slope;
        }
        return new Line((int)Math.round(x1), (int)Math.round(z1), (int)Math.round(x2), (int)Math.round(z2));
    }

    public boolean lineClip(int rxMin, int rxMax, int rzMin, int rzMax) {
        if (!(this.x1() < rxMin && this.x2() < rxMin || this.x1() > rxMax && this.x2() > rxMax || this.z1() < rzMin && this.z2() < rzMin || this.z1() > rzMax && this.z2() > rzMax)) {
            double xx1 = this.x1();
            double xx2 = this.x2();
            double zz1 = this.z1();
            double zz2 = this.z2();
            double m = (zz2 - zz1) / (xx2 - xx1);
            double n = 1.0 / m;
            if (xx1 < (double)rxMin) {
                xx1 = rxMin;
                zz1 = m * (double)(rxMin - this.x1()) + (double)this.z1();
            } else if (xx1 > (double)rxMax) {
                xx1 = rxMax;
                zz1 = m * (double)(rxMax - this.x1()) + (double)this.z1();
            }
            if (zz1 < (double)rzMin) {
                zz1 = rzMin;
                xx1 = n * (double)(rzMin - this.z1()) + (double)this.x1();
            } else if (zz1 > (double)rzMax) {
                zz1 = rzMax;
                xx1 = n * (double)(rzMax - this.z1()) + (double)this.x1();
            }
            if (xx2 < (double)rxMin) {
                xx2 = rxMin;
                zz2 = m * (double)(rxMin - this.x1()) + (double)this.z1();
            } else if (xx2 > (double)rxMax) {
                xx2 = rxMax;
                zz2 = m * (double)(rxMax - this.x1()) + (double)this.z1();
            }
            if (zz2 < (double)rzMin) {
                zz2 = rzMin;
                xx2 = n * (double)(rzMin - this.z1()) + (double)this.x1();
            } else if (zz2 > (double)rzMax) {
                zz2 = rzMax;
                xx2 = n * (double)(rzMax - this.z1()) + (double)this.x1();
            }
            if (!(xx1 < (double)rxMin && xx2 < (double)rxMin || xx1 > (double)rxMax && xx2 > (double)rxMax)) {
                return true;
            }
        }
        return false;
    }

    public double angle() {
        int dx = this.x2() - this.x1();
        int dz = this.z2() - this.z1();
        double angleRadians = Math.atan2(dz, dx);
        double degrees = Math.toDegrees(angleRadians) - 90.0;
        return Mth.wrapDegrees((double)degrees);
    }
}

