/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import xaero.map.gui.GuiMap;
import xaeroplus.Globals;
import xaeroplus.feature.render.AsyncChunkHighlightProvider;
import xaeroplus.feature.render.ChunkHighlightDrawFeature;
import xaeroplus.feature.render.HighlightDrawBuffer;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.GuiMapHelper;

public class AsyncChunkHighlightDrawFeature
implements ChunkHighlightDrawFeature {
    private final AsyncLoadingCache<Long, Long2LongMap> chunkRenderCache;
    private final AsyncChunkHighlightProvider chunkHighlightProvider;
    private final HighlightDrawBuffer drawBuffer = new HighlightDrawBuffer();

    public AsyncChunkHighlightDrawFeature(AsyncChunkHighlightProvider chunkHighlightProvider) {
        this.chunkHighlightProvider = chunkHighlightProvider;
        this.chunkRenderCache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).refreshAfterWrite(500L, TimeUnit.MILLISECONDS).executor((Executor)Globals.cacheRefreshExecutorService.get()).removalListener((k, v, cause) -> this.markDrawBuffersStale()).buildAsync(k -> this.loadFeatureHighlightsInWindow());
    }

    private Long2LongMap loadFeatureHighlightsInWindow() {
        int windowSize;
        int windowZ;
        int windowX;
        Optional<GuiMap> guiMapOptional = GuiMapHelper.getGuiMap();
        if (guiMapOptional.isPresent()) {
            GuiMap guiMap = guiMapOptional.get();
            windowX = GuiMapHelper.getGuiMapCenterRegionX(guiMap);
            windowZ = GuiMapHelper.getGuiMapCenterRegionZ(guiMap);
            windowSize = GuiMapHelper.getGuiMapRegionSize(guiMap);
        } else {
            windowX = ChunkUtils.getPlayerRegionX();
            windowZ = ChunkUtils.getPlayerRegionZ();
            windowSize = Math.max(3, Globals.minimapScaleMultiplier);
        }
        return this.chunkHighlightProvider.chunkHighlightSupplier().getHighlights(windowX, windowZ, windowSize, Globals.getCurrentDimensionId());
    }

    @Override
    public int colorInt() {
        return this.chunkHighlightProvider.colorSupplier().getAsInt();
    }

    @Override
    public void invalidateCache() {
        this.chunkRenderCache.synchronous().invalidateAll();
    }

    @Override
    public Long2LongMap getChunkHighlights() {
        return (Long2LongMap)this.chunkRenderCache.get((Object)0L).getNow(Long2LongMaps.EMPTY_MAP);
    }

    @Override
    public void refreshIfNeeded(boolean worldmap) {
        Long2LongMap highlights = this.getChunkHighlights();
        if (this.drawBuffer.needsRefresh(worldmap)) {
            this.drawBuffer.refresh(highlights, worldmap);
        }
    }

    @Override
    public void render(boolean worldmap, RenderPass pass, GpuBuffer indexBuffer, VertexFormat.IndexType indexType) {
        this.drawBuffer.render(pass, indexBuffer, indexType);
    }

    @Override
    public int indexCount() {
        return this.drawBuffer.indexCount();
    }

    public void markDrawBuffersStale() {
        this.drawBuffer.markStale();
    }

    @Override
    public void close() {
        this.drawBuffer.close();
    }
}

