/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import xaero.common.HudMod;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.shader.FramebufferLinesShaderHelper;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.render.DrawFeatureRegistry;
import xaeroplus.feature.render.DrawHelper;
import xaeroplus.feature.render.Line;
import xaeroplus.feature.render.XaeroPlusShaders;
import xaeroplus.lambdaevents.EventHandler;
import xaeroplus.util.ColorHelper;

public class DrawManager {
    private final DrawFeatureRegistry registry = new DrawFeatureRegistry();

    public final DrawFeatureRegistry registry() {
        return this.registry;
    }

    public DrawManager() {
        XaeroPlus.EVENT_BUS.register(this);
    }

    @EventHandler
    public void onXaeroWorldChange(XaeroWorldChangeEvent event) {
        this.registry.invalidateCaches();
    }

    public void drawMinimapFeatures(int chunkX, int chunkZ, int tileX, int tileZ, int insideX, int insideZ, PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffers) {
        if (HudMod.INSTANCE.isFairPlay()) {
            return;
        }
        matrixStack.pushPose();
        matrixStack.translate((float)(-(chunkX * 64) - tileX * 16 - insideX), (float)(-(chunkZ * 64) - tileZ * 16 - insideZ), 0.0f);
        matrixStack.pushPose();
        matrixStack.scale(16.0f, 16.0f, 1.0f);
        this.drawChunkHighlights(matrixStack, false);
        matrixStack.popPose();
        this.drawMinimapLines(matrixStack, renderTypeBuffers);
        matrixStack.popPose();
    }

    public void drawMinimapLines(PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffers) {
        this.registry.forEachLineDrawFeature(feature -> {
            int color = feature.colorInt();
            float a = ColorHelper.getA(color);
            if (a == 0.0f) {
                return;
            }
            VertexConsumer lineBuffer = renderTypeBuffers.getBuffer(CustomRenderTypes.MAP_LINES);
            float lineWidthScale = 16.0f * Mth.clamp((float)feature.lineWidth(), (float)(0.1f * (float)Globals.minimapScaleMultiplier), (float)1000.0f);
            RenderSystem.lineWidth((float)lineWidthScale);
            float r = ColorHelper.getR(color);
            float g = ColorHelper.getG(color);
            float b = ColorHelper.getB(color);
            List<Line> lines = feature.getLines();
            for (int j = 0; j < lines.size(); ++j) {
                Line line = lines.get(j);
                int x1 = line.x1();
                int z1 = line.z1();
                int x2 = line.x2();
                int z2 = line.z2();
                if (z2 < z1) {
                    int tz1 = z1;
                    z1 = z2;
                    z2 = tz1;
                    int tx1 = x1;
                    x1 = x2;
                    x2 = tx1;
                }
                DrawHelper.addColoredLineToExistingBuffer(matrixStack.last(), lineBuffer, x1, z1, x2, z2, r, g, b, a);
            }
            renderTypeBuffers.endBatch(CustomRenderTypes.MAP_LINES);
        });
    }

    public void drawWorldMapFeatures(int flooredCameraX, int flooredCameraZ, PoseStack matrixStack, double fboScale, MultiBufferSource.BufferSource renderTypeBuffers) {
        if (HudMod.INSTANCE.isFairPlay()) {
            return;
        }
        matrixStack.pushPose();
        matrixStack.translate((float)(-flooredCameraX), (float)(-flooredCameraZ), 1.0f);
        matrixStack.pushPose();
        matrixStack.scale(16.0f, 16.0f, 1.0f);
        this.drawChunkHighlights(matrixStack, true);
        matrixStack.popPose();
        this.drawWorldMapLines(matrixStack, fboScale, renderTypeBuffers);
        matrixStack.popPose();
    }

    public void drawWorldMapLines(PoseStack matrixStack, double fboScale, MultiBufferSource.BufferSource renderTypeBuffers) {
        Minecraft mc = Minecraft.getInstance();
        FramebufferLinesShaderHelper.setFrameSize((float)mc.getWindow().getWidth(), (float)mc.getWindow().getHeight());
        this.registry.forEachLineDrawFeature(feature -> {
            int color = feature.colorInt();
            float a = ColorHelper.getA(color);
            if (a == 0.0f) {
                return;
            }
            VertexConsumer lineBuffer = renderTypeBuffers.getBuffer(CustomRenderTypes.MAP_LINES);
            float lineWidthScale = 16.0f * (float)Mth.clamp((double)((double)feature.lineWidth() * fboScale), (double)0.1f, (double)1000.0);
            RenderSystem.lineWidth((float)lineWidthScale);
            float r = ColorHelper.getR(color);
            float g = ColorHelper.getG(color);
            float b = ColorHelper.getB(color);
            List<Line> lines = feature.getLines();
            for (int j = 0; j < lines.size(); ++j) {
                Line line = lines.get(j);
                int x1 = line.x1();
                int z1 = line.z1();
                int x2 = line.x2();
                int z2 = line.z2();
                if (z2 < z1) {
                    int tz1 = z1;
                    z1 = z2;
                    z2 = tz1;
                    int tx1 = x1;
                    x1 = x2;
                    x2 = tx1;
                }
                DrawHelper.addColoredLineToExistingBuffer(matrixStack.last(), lineBuffer, x2, z2, x1, z1, r, g, b, a);
            }
            renderTypeBuffers.endBatch(CustomRenderTypes.MAP_LINES);
        });
    }

    public void drawChunkHighlights(PoseStack matrixStack, boolean worldmap) {
        this.registry.forEachChunkHighlightDrawFeature(feature -> feature.refreshIfNeeded(worldmap));
        this.registry.forEachChunkHighlightDrawFeature(feature -> {
            int color = feature.colorInt();
            float a = ColorHelper.getA(color);
            if (a == 0.0f) {
                return;
            }
            float r = ColorHelper.getR(color);
            float g = ColorHelper.getG(color);
            float b = ColorHelper.getB(color);
            RenderSystem.AutoStorageIndexBuffer autoIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.QUADS);
            VertexFormat.IndexType indexType = autoIndexBuffer.type();
            GpuBuffer indexBuffer = autoIndexBuffer.getBuffer(feature.indexCount());
            try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(Minecraft.getInstance().getMainRenderTarget().getColorTexture(), OptionalInt.empty());){
                pass.setPipeline(XaeroPlusShaders.HIGHLIGHT_PIPELINE);
                pass.setUniform("MapViewMatrix", matrixStack.last().pose());
                pass.setUniform("ModelViewMat", RenderSystem.getModelViewMatrix());
                pass.setUniform("ProjMat", RenderSystem.getProjectionMatrix());
                pass.setUniform("HighlightColor", new float[]{r, g, b, a});
                feature.render(worldmap, pass, indexBuffer, indexType);
            }
        });
    }
}

