/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import org.jetbrains.annotations.Nullable;
import xaeroplus.util.ChunkUtils;

public class HighlightDrawBuffer {
    private boolean stale = true;
    @Nullable
    private GpuBuffer vertexBuffer = null;
    private boolean flipped = false;
    long lastRefreshed = 0L;
    int indexCount = 0;

    public boolean needsRefresh(boolean needsFlip) {
        return this.vertexBuffer == null || this.vertexBuffer.isClosed() || this.stale || this.flipped != needsFlip;
    }

    public void refresh(Long2LongMap highlights, boolean needsFlip) {
        this.stale = false;
        this.lastRefreshed = System.currentTimeMillis();
        this.flipped = needsFlip;
        if (highlights.isEmpty()) {
            this.close();
            return;
        }
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        for (Long highlight : highlights.keySet()) {
            int chunkPosX = ChunkUtils.longToChunkX(highlight);
            int chunkPosZ = ChunkUtils.longToChunkZ(highlight);
            float x1 = chunkPosX;
            float x2 = chunkPosX + 1;
            float y1 = needsFlip ? (float)(chunkPosZ + 1) : (float)chunkPosZ;
            float y2 = needsFlip ? (float)chunkPosZ : (float)(chunkPosZ + 1);
            bufferBuilder.addVertex(x1, y2, 0.0f);
            bufferBuilder.addVertex(x2, y2, 0.0f);
            bufferBuilder.addVertex(x2, y1, 0.0f);
            bufferBuilder.addVertex(x1, y1, 0.0f);
        }
        try (MeshData meshData = bufferBuilder.buildOrThrow();){
            this.close();
            this.vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "Chunk Highlight Buffer", BufferType.VERTICES, BufferUsage.STATIC_WRITE, meshData.vertexBuffer());
            this.indexCount = meshData.drawState().indexCount();
        }
    }

    public int indexCount() {
        return this.indexCount;
    }

    public void render(RenderPass pass, GpuBuffer indexBuffer, VertexFormat.IndexType indexType) {
        if (this.vertexBuffer == null || this.vertexBuffer.isClosed()) {
            return;
        }
        pass.setIndexBuffer(indexBuffer, indexType);
        pass.setVertexBuffer(0, this.vertexBuffer);
        pass.drawIndexed(0, this.indexCount);
    }

    public void markStale() {
        this.stale = true;
    }

    public void close() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
    }
}

