/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.buffered;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.shaders.UniformType;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalInt;
import java.util.function.IntSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import xaeroplus.feature.render.buffered.Model;
import xaeroplus.settings.Settings;

public class BufferedComponent {
    private static final Minecraft mc = Minecraft.getInstance();
    private Model model = null;
    private final RenderTarget renderTarget = new TextureTarget("XaeroPlus Minimap Buffered", 100, 100, true);
    private RenderTarget mainRenderTargetBackup = null;
    private long nextRenderCapture = System.currentTimeMillis();
    private final IntSupplier fpsLimitSupplier;
    private final Matrix4f modelViewMatrixBackup = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
    private final RenderPipeline bufferedPipeline = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[0]).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaeroplus", (String)"buffered")).withVertexShader("core/position_tex").withFragmentShader("core/position_tex").withBlend(new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA)).withUniform("ModelViewMat", UniformType.MATRIX4X4).withUniform("ProjMat", UniformType.MATRIX4X4).withUniform("ColorModulator", UniformType.VEC4).withSampler("Sampler0").withVertexFormat(DefaultVertexFormat.POSITION_TEX, VertexFormat.Mode.QUADS).build();

    public BufferedComponent(IntSupplier fpsLimitSupplier) {
        this.fpsLimitSupplier = fpsLimitSupplier;
    }

    private void refreshModel(int screenWidth, int screenHeight) {
        if (this.model != null) {
            this.model.close();
        }
        Vector3f[] posMatrix = new Vector3f[]{new Vector3f(0.0f, (float)screenHeight, 1.0f), new Vector3f((float)screenWidth, (float)screenHeight, 1.0f), new Vector3f((float)screenWidth, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f)};
        Vector2f[] texUvMatrix = new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f), new Vector2f(1.0f, 1.0f), new Vector2f(0.0f, 1.0f)};
        this.model = new Model(posMatrix, texUvMatrix);
    }

    public boolean render() {
        int windowWidth = mc.getWindow().getWidth();
        int windowHeight = mc.getWindow().getHeight();
        boolean forceRender = false;
        if (this.renderTarget.width != BufferedComponent.mc.mainRenderTarget.width || this.renderTarget.height != BufferedComponent.mc.mainRenderTarget.height) {
            this.renderTarget.resize(BufferedComponent.mc.mainRenderTarget.width, BufferedComponent.mc.mainRenderTarget.height);
            this.refreshModel(windowWidth, windowHeight);
            forceRender = true;
        }
        if (this.model == null) {
            this.refreshModel(windowWidth, windowHeight);
            forceRender = true;
        }
        if (forceRender || System.currentTimeMillis() > this.nextRenderCapture) {
            this.mainRenderTargetBackup = BufferedComponent.mc.mainRenderTarget;
            BufferedComponent.mc.mainRenderTarget = this.renderTarget;
            BufferedComponent.clearRenderTarget(this.renderTarget, 0, 1.0f);
            return false;
        }
        this.renderBufferedTexture();
        return true;
    }

    public static void clearRenderTarget(RenderTarget renderTarget, int color, float depth) {
        RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(renderTarget.getColorTexture(), color, renderTarget.getDepthTexture(), (double)depth);
    }

    public void postRender() {
        if (this.mainRenderTargetBackup != null) {
            BufferedComponent.mc.mainRenderTarget = this.mainRenderTargetBackup;
            this.mainRenderTargetBackup = null;
        }
        this.nextRenderCapture = System.currentTimeMillis() + (long)(1000 / this.fpsLimitSupplier.getAsInt());
        this.renderBufferedTexture();
    }

    private void renderBufferedTexture() {
        this.modelViewMatrixBackup.set((Matrix4fc)RenderSystem.getModelViewMatrix());
        RenderSystem.AutoStorageIndexBuffer autoIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.QUADS);
        GpuBuffer indexBuffer = autoIndexBuffer.getBuffer(this.model.getIndexCount());
        try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(mc.getMainRenderTarget().getColorTexture(), OptionalInt.empty());){
            pass.setPipeline(this.bufferedPipeline);
            pass.bindSampler("Sampler0", this.renderTarget.getColorTexture());
            RenderSystem.setShaderTexture((int)0, (GpuTexture)this.renderTarget.getColorTexture());
            Matrix4f modelViewMatrix = RenderSystem.getModelViewMatrix();
            modelViewMatrix.translate(0.0f, 0.0f, 399.0f + (float)Settings.REGISTRY.minimapRenderZOffsetSetting.get());
            float guiScale = (float)Math.max(1.0, mc.getWindow().getGuiScale());
            modelViewMatrix.scale(1.0f / guiScale);
            this.model.draw(pass, indexBuffer, autoIndexBuffer.type());
        }
        RenderSystem.getModelViewMatrix().set((Matrix4fc)this.modelViewMatrixBackup);
    }
}

