/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlights.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaeroplus.XaeroPlus;
import xaeroplus.feature.render.highlights.db.DatabaseMigration;

public class V0ToV1Migration
implements DatabaseMigration {
    @Override
    public boolean shouldMigrate(String databaseName, Connection connection) {
        try {
            return this.tableExists("0", connection) || this.tableExists("-1", connection) || this.tableExists("1", connection);
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed checking if {} database should migrate", (Object)databaseName, (Object)e);
            return false;
        }
    }

    @Override
    public void doMigration(String databaseName, Connection connection) {
        try {
            this.mergeTables("0", this.getTableName((ResourceKey<Level>)Level.OVERWORLD), connection);
            this.mergeTables("-1", this.getTableName((ResourceKey<Level>)Level.NETHER), connection);
            this.mergeTables("1", this.getTableName((ResourceKey<Level>)Level.END), connection);
            try (Statement statement = connection.createStatement();){
                statement.executeUpdate("CREATE UNIQUE INDEX IF NOT EXISTS \"unique_xz_" + this.getTableName((ResourceKey<Level>)Level.OVERWORLD) + "\" ON \"" + this.getTableName((ResourceKey<Level>)Level.OVERWORLD) + "\" (x, z)");
                statement.executeUpdate("CREATE UNIQUE INDEX IF NOT EXISTS \"unique_xz_" + this.getTableName((ResourceKey<Level>)Level.NETHER) + "\" ON \"" + this.getTableName((ResourceKey<Level>)Level.NETHER) + "\" (x, z)");
                statement.executeUpdate("CREATE UNIQUE INDEX IF NOT EXISTS \"unique_xz_" + this.getTableName((ResourceKey<Level>)Level.END) + "\" ON \"" + this.getTableName((ResourceKey<Level>)Level.END) + "\" (x, z)");
                statement.executeUpdate("DROP INDEX IF EXISTS unique_xzO");
                statement.executeUpdate("DROP INDEX IF EXISTS unique_xzN");
                statement.executeUpdate("DROP INDEX IF EXISTS unique_xzE");
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed creating new tables for {} database", (Object)databaseName, (Object)e);
        }
    }

    private String getTableName(ResourceKey<Level> dimension) {
        return dimension.location().toString();
    }

    private boolean tableExists(String tableName, Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery("SELECT name FROM sqlite_master WHERE type='table' and name='" + tableName + "'");
            boolean bl = resultSet.next();
            return bl;
        }
    }

    private void mergeTables(String src, String dest, Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            if (this.tableExists(dest, connection)) {
                if (this.tableExists(src, connection)) {
                    statement.executeUpdate("INSERT OR IGNORE INTO \"" + dest + "\" SELECT * FROM \"" + src + "\"");
                    statement.executeUpdate("DROP TABLE IF EXISTS \"" + src + "\"");
                }
            } else {
                statement.executeUpdate("ALTER TABLE \"" + src + "\" RENAME TO \"" + dest + "\"");
            }
        }
    }
}

