/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.lambdaevents.generator;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.lenni0451.reflect.stream.RStream;
import net.lenni0451.reflect.wrapper.ASMWrapper;
import xaeroplus.lambdaevents.AHandler;
import xaeroplus.lambdaevents.EventHandler;
import xaeroplus.lambdaevents.IGenerator;

public class ASMGenerator
implements IGenerator {
    @Override
    @Nonnull
    public AHandler generate(Class<?> owner, @Nullable Object instance, EventHandler annotation, Method method, Class<?> arg) {
        return this.define(owner, instance, annotation, method, arg);
    }

    @Override
    @Nonnull
    public AHandler generateVirtual(Class<?> owner, @Nullable Object instance, EventHandler annotation, Method method) {
        return this.define(owner, instance, annotation, method, null);
    }

    private AHandler define(Class<?> owner, @Nullable Object instance, EventHandler annotation, Method method, @Nullable Class<?> arg) {
        String handlerName = ASMWrapper.slash((String)owner.getPackage().getName()) + "/LambdaEvents$ASMHandler";
        ASMWrapper w = ASMWrapper.create((int)ASMWrapper.opcode((String)"ACC_PUBLIC"), (String)handlerName, null, (String)ASMWrapper.slash(AHandler.class), null);
        this.makeConstructor(handlerName, w, instance);
        this.makeCaller(handlerName, w, owner, instance, method, arg);
        Class handlerClazz = w.defineMetafactory(owner);
        return (AHandler)RStream.of((Class)handlerClazz).constructors().by(0).newInstance(new Object[]{owner, instance, annotation});
    }

    private void makeConstructor(String handlerName, ASMWrapper w, @Nullable Object instance) {
        boolean isStatic;
        String desc = ASMWrapper.desc((Class[])new Class[]{Class.class, Object.class, EventHandler.class}, Void.TYPE);
        boolean bl = isStatic = instance == null;
        if (!isStatic) {
            w.visitField(ASMWrapper.opcode((String)"ACC_PRIVATE"), "instance", ASMWrapper.desc(instance.getClass()), null, null);
        }
        ASMWrapper.MethodVisitorAccess mv = w.visitMethod(ASMWrapper.opcode((String)"ACC_PUBLIC"), "<init>", desc, null, null);
        mv.visitVarInsn(ASMWrapper.opcode((String)"ALOAD"), 0);
        mv.visitVarInsn(ASMWrapper.opcode((String)"ALOAD"), 1);
        mv.visitVarInsn(ASMWrapper.opcode((String)"ALOAD"), 2);
        mv.visitVarInsn(ASMWrapper.opcode((String)"ALOAD"), 3);
        mv.visitMethodInsn(ASMWrapper.opcode((String)"INVOKESPECIAL"), ASMWrapper.slash(AHandler.class), "<init>", desc, false);
        if (!isStatic) {
            mv.visitVarInsn(ASMWrapper.opcode((String)"ALOAD"), 0);
            mv.visitVarInsn(ASMWrapper.opcode((String)"ALOAD"), 2);
            mv.visitTypeInsn(ASMWrapper.opcode((String)"CHECKCAST"), ASMWrapper.slash(instance.getClass()));
            mv.visitFieldInsn(ASMWrapper.opcode((String)"PUTFIELD"), handlerName, "instance", ASMWrapper.desc(instance.getClass()));
        }
        mv.visitInsn(ASMWrapper.opcode((String)"RETURN"));
        if (isStatic) {
            mv.visitMaxs(4, 4);
        } else {
            mv.visitMaxs(5, 5);
        }
        mv.visitEnd();
    }

    private void makeCaller(String handlerName, ASMWrapper w, Class<?> owner, @Nullable Object instance, Method method, @Nullable Class<?> arg) {
        boolean isStatic = instance == null;
        boolean isInterface = Modifier.isInterface(owner.getModifiers());
        ASMWrapper.MethodVisitorAccess mv = w.visitMethod(ASMWrapper.opcode((String)"ACC_PUBLIC"), "call", ASMWrapper.desc((Class[])new Class[]{Object.class}, Void.TYPE), null, null);
        if (!isStatic) {
            mv.visitVarInsn(ASMWrapper.opcode((String)"ALOAD"), 0);
            mv.visitFieldInsn(ASMWrapper.opcode((String)"GETFIELD"), handlerName, "instance", ASMWrapper.desc(instance.getClass()));
        }
        if (arg != null) {
            mv.visitVarInsn(ASMWrapper.opcode((String)"ALOAD"), 1);
            mv.visitTypeInsn(ASMWrapper.opcode((String)"CHECKCAST"), ASMWrapper.slash(arg));
        }
        if (isStatic) {
            mv.visitMethodInsn(ASMWrapper.opcode((String)"INVOKESTATIC"), ASMWrapper.slash(owner), method.getName(), ASMWrapper.desc((Method)method), isInterface);
        } else {
            mv.visitMethodInsn(ASMWrapper.opcode((String)(isInterface ? "INVOKEINTERFACE" : "INVOKEVIRTUAL")), ASMWrapper.slash(owner), method.getName(), ASMWrapper.desc((Method)method), isInterface);
        }
        mv.visitInsn(ASMWrapper.opcode((String)"RETURN"));
        mv.visitMaxs(3, 3);
        mv.visitEnd();
    }
}

