/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.lambdaevents.utils;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import xaeroplus.lambdaevents.utils.LookupGetter;

public class LookupUtils {
    private static final Map<ClassLoader, LookupGetterLoader> loaders = Collections.synchronizedMap(new WeakHashMap());

    @Nonnull
    public static MethodHandles.Lookup getIn(ClassLoader classLoader) {
        Class<?> lookupGetter;
        LookupGetterLoader loader = loaders.computeIfAbsent(classLoader, LookupGetterLoader::new);
        if (!loader.isDefined(LookupGetter.class.getName())) {
            try (InputStream is = LookupGetter.class.getClassLoader().getResourceAsStream(LookupGetter.class.getName().replace('.', '/') + ".class");){
                int len;
                if (is == null) {
                    throw new ClassNotFoundException(LookupGetter.class.getName());
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                while ((len = is.read(buf)) != -1) {
                    baos.write(buf, 0, len);
                }
                lookupGetter = loader.define(LookupGetter.class.getName(), baos.toByteArray());
            }
        } else {
            lookupGetter = loader.loadClass(LookupGetter.class.getName());
        }
        return (MethodHandles.Lookup)lookupGetter.getDeclaredMethod("get", new Class[0]).invoke(null, new Object[0]);
    }

    @Nonnull
    public static MethodHandles.Lookup resolveLookup(MethodHandles.Lookup lookup, Class<?> accessed) {
        if (LookupUtils.canAccess(lookup, accessed)) {
            return lookup;
        }
        if (LookupUtils.canAccess(lookup = lookup.in(accessed), accessed)) {
            return lookup;
        }
        lookup = LookupUtils.getIn(accessed.getClassLoader());
        if (LookupUtils.canAccess(lookup, accessed)) {
            return lookup;
        }
        if (LookupUtils.canAccess(lookup = lookup.in(accessed), accessed)) {
            return lookup;
        }
        throw new IllegalStateException("Could not resolve lookup for " + accessed.getName());
    }

    public static boolean canAccess(MethodHandles.Lookup lookup, Class<?> clazz) {
        return LookupUtils.canAccess(clazz, lookup.lookupClass()) && (lookup.lookupModes() & 2) != 0;
    }

    public static boolean canAccess(Class<?> wanted, Class<?> clazz) {
        ClassLoader clazzLoader;
        if (wanted == clazz) {
            return true;
        }
        while (wanted.isArray()) {
            wanted = wanted.getComponentType();
        }
        if (wanted.isPrimitive()) {
            return true;
        }
        if (wanted == Object.class) {
            return true;
        }
        ClassLoader wantedLoader = wanted.getClassLoader();
        if (wantedLoader == (clazzLoader = clazz.getClassLoader())) {
            return true;
        }
        if (wantedLoader != null && clazzLoader == null) {
            return false;
        }
        if (wantedLoader == null && wanted.getName().startsWith("java.")) {
            return true;
        }
        try {
            return Class.forName(wanted.getName(), false, clazzLoader) == wanted;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static class LookupGetterLoader
    extends ClassLoader {
        protected LookupGetterLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        protected Object getClassLoadingLock(String name) {
            return super.getClassLoadingLock(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Class<?> define(String name, byte[] bytes) {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
                this.resolveClass(clazz);
                return clazz;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isDefined(String name) {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                return this.findLoadedClass(name) != null;
            }
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }
}

