/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.animation.SlowingAnimation;
import xaero.map.element.HoveredMapElementHolder;
import xaero.map.element.MapElementRenderHandler;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.gui.IRightClickableElement;
import xaero.map.gui.MapTileSelection;
import xaero.map.gui.ScreenBase;
import xaero.map.gui.dropdown.rightclick.RightClickOption;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.world.MapDimension;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.mixin.client.AccessorRightClickOption;
import xaeroplus.settings.Settings;
import xaeroplus.util.BaritoneExecutor;
import xaeroplus.util.BaritoneHelper;
import xaeroplus.util.ChunkUtils;

@Mixin(value={GuiMap.class}, remap=false)
public abstract class MixinGuiMap
extends ScreenBase
implements IRightClickableElement {
    @Unique
    private static boolean follow = false;
    @Unique
    boolean pan;
    @Unique
    double panMouseStartX;
    @Unique
    double panMouseStartY;
    @Unique
    Button coordinateGotoButton;
    @Unique
    EditBox xTextEntryField;
    @Unique
    EditBox zTextEntryField;
    @Unique
    Button followButton;
    @Unique
    Button switchToNetherButton;
    @Unique
    Button switchToOverworldButton;
    @Unique
    Button switchToEndButton;
    @Unique
    List<Button> guiMapButtonTempList = new ArrayList<Button>();
    @Unique
    ResourceLocation xpGuiTextures = ResourceLocation.fromNamespaceAndPath((String)"xaeroplus", (String)"gui/xpgui.png");
    @Shadow
    private double cameraX = 0.0;
    @Shadow
    private double cameraZ = 0.0;
    @Shadow
    private int[] cameraDestination = null;
    @Shadow
    private SlowingAnimation cameraDestinationAnimX = null;
    @Shadow
    private SlowingAnimation cameraDestinationAnimZ = null;
    @Shadow
    private double prevPlayerDimDiv;
    @Shadow
    private MapProcessor mapProcessor;
    @Shadow
    private Button exportButton;
    @Shadow
    private Button claimsButton;
    @Shadow
    private Button zoomInButton;
    @Shadow
    private Button zoomOutButton;
    @Shadow
    private Button keybindingsButton;
    @Shadow
    private Button dimensionToggleButton;
    @Shadow
    private int rightClickX;
    @Shadow
    private int rightClickY;
    @Shadow
    private int rightClickZ;
    @Shadow
    private int mouseBlockPosX;
    @Shadow
    private int mouseBlockPosZ;
    @Shadow
    private static double destScale;
    @Shadow
    private MapTileSelection mapTileSelection;

    protected MixinGuiMap(Screen parent, Screen escape, Component titleIn) {
        super(parent, escape, titleIn);
    }

    @Shadow
    public abstract <T extends GuiEventListener & Renderable> T addButton(T var1);

    @Shadow
    public abstract <T extends GuiEventListener & NarratableEntry> T addWidget(T var1);

    @ModifyExpressionValue(method={"changeZoom(DI)V"}, at={@At(value="CONSTANT", args={"doubleValue=0.0625"})})
    public double customMinZoom(double original) {
        return Settings.REGISTRY.worldMapMinZoomSetting.get() / 10.0;
    }

    @Inject(method={"init()V"}, at={@At(value="RETURN")}, remap=true)
    public void customInitGui(CallbackInfo ci) {
        this.followButton = new GuiTexturedButton(0, this.dimensionToggleButton.getY() - 20, 20, 20, follow ? 133 : 149, 16, 16, 16, WorldMap.guiTextures, this::onFollowButton, () -> new CursorBox((Component)Component.translatable((String)"xaeroplus.gui.world_map.toggle_follow_mode").append(" " + I18n.get((String)(follow ? "xaeroplus.gui.off" : "xaeroplus.gui.on"), (Object[])new Object[0]))), 256, 256);
        this.addButton(this.followButton);
        this.coordinateGotoButton = new GuiTexturedButton(0, this.followButton.getY() - 20, 20, 20, 229, 16, 16, 16, WorldMap.guiTextures, this::onGotoCoordinatesButton, () -> new CursorBox((Component)Component.translatable((String)"xaeroplus.gui.world_map.go_to_coordinates")), 256, 256);
        this.addButton(this.coordinateGotoButton);
        this.xTextEntryField = new EditBox(Minecraft.getInstance().font, 20, this.coordinateGotoButton.getY() - 10, 50, 20, Component.nullToEmpty((String)"X:"));
        this.xTextEntryField.setVisible(false);
        this.xTextEntryField.setCursorPosition(0);
        this.xTextEntryField.setHint((Component)Component.literal((String)"X:").withStyle(ChatFormatting.DARK_GRAY));
        this.zTextEntryField = new EditBox(Minecraft.getInstance().font, 20, this.xTextEntryField.getY() + 20, 50, 20, Component.nullToEmpty((String)"Z:"));
        this.zTextEntryField.setVisible(false);
        this.zTextEntryField.setCursorPosition(0);
        this.zTextEntryField.setHint((Component)Component.literal((String)"Z:").withStyle(ChatFormatting.DARK_GRAY));
        this.addWidget(this.xTextEntryField);
        this.addWidget(this.zTextEntryField);
        if (!SupportMods.pac()) {
            this.removeWidget((GuiEventListener)this.claimsButton);
            this.exportButton.setY(this.claimsButton.getY());
            this.keybindingsButton.setY(this.claimsButton.getY() - 20);
            this.zoomOutButton.setY(this.keybindingsButton.getY() - 20);
            this.zoomInButton.setY(this.zoomOutButton.getY() - 20);
        }
        this.switchToEndButton = new GuiTexturedButton(this.width - 20, this.zoomInButton.getY() - 20, 20, 20, 31, 0, 16, 16, this.xpGuiTextures, button -> this.onSwitchDimensionButton((ResourceKey<Level>)Level.END), () -> new CursorBox((Component)Component.translatable((String)"xaeroplus.keybind.switch_to_end")), 256, 256);
        this.switchToOverworldButton = new GuiTexturedButton(this.width - 20, this.switchToEndButton.getY() - 20, 20, 20, 16, 0, 16, 16, this.xpGuiTextures, button -> this.onSwitchDimensionButton((ResourceKey<Level>)Level.OVERWORLD), () -> new CursorBox((Component)Component.translatable((String)"xaeroplus.keybind.switch_to_overworld")), 256, 256);
        this.switchToNetherButton = new GuiTexturedButton(this.width - 20, this.switchToOverworldButton.getY() - 20, 20, 20, 0, 0, 16, 16, this.xpGuiTextures, button -> this.onSwitchDimensionButton((ResourceKey<Level>)Level.NETHER), () -> new CursorBox((Component)Component.translatable((String)"xaeroplus.keybind.switch_to_nether")), 256, 256);
        this.addButton(this.switchToEndButton);
        this.addButton(this.switchToOverworldButton);
        this.addButton(this.switchToNetherButton);
        this.pan = false;
    }

    protected void onExit(Screen screen) {
        if (!Settings.REGISTRY.persistMapDimensionSwitchSetting.get()) {
            try {
                ResourceKey<Level> actualDimension = ChunkUtils.getActualDimension();
                if (Globals.getCurrentDimensionId() != actualDimension) {
                    Globals.switchToDimension(actualDimension);
                    if (!Settings.REGISTRY.radarWhileDimensionSwitchedSetting.get()) {
                        WorldMap.settings.minimapRadar = true;
                    }
                }
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.error("Failed to switch back to original dimension", (Throwable)e);
            }
        }
        super.onExit(screen);
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lxaero/map/gui/GuiMap;init(Lnet/minecraft/client/Minecraft;II)V", ordinal=0, shift=At.Shift.AFTER)}, remap=true)
    public void toggleRadarWhileDimensionSwitched(GuiGraphics guiGraphics, int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci, @Local(name={"currentFutureDim"}) MapDimension currentFutureDim) {
        if (!Settings.REGISTRY.radarWhileDimensionSwitchedSetting.get()) {
            WorldMap.settings.minimapRadar = currentFutureDim.getDimId() == ChunkUtils.getActualDimension();
        }
    }

    @Redirect(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="FIELD", target="Lxaero/map/gui/GuiMap;cameraX:D", opcode=181, ordinal=1), remap=true)
    public void fixDimensionSwitchCameraCoordsX(GuiMap owner, double value, @Local(name={"playerDimDiv"}) double playerDimDiv) {
        this.cameraX *= this.prevPlayerDimDiv / playerDimDiv;
    }

    @Redirect(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="FIELD", target="Lxaero/map/gui/GuiMap;cameraZ:D", opcode=181, ordinal=1), remap=true)
    public void fixDimensionSwitchCameraCoordsZ(GuiMap owner, double value, @Local(name={"playerDimDiv"}) double playerDimDiv) {
        this.cameraZ *= this.prevPlayerDimDiv / playerDimDiv;
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="FIELD", target="Lxaero/map/gui/GuiMap;lastStartTime:J", opcode=181, ordinal=0, shift=At.Shift.AFTER)}, remap=true)
    public void injectFollowMode(GuiGraphics guiGraphics, int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci) {
        if (follow && Objects.isNull(this.cameraDestination) && Objects.isNull(this.cameraDestinationAnimX) && Objects.isNull(this.cameraDestinationAnimZ)) {
            this.cameraDestination = new int[]{(int)ChunkUtils.getPlayerX(), (int)ChunkUtils.getPlayerZ()};
        }
    }

    @ModifyExpressionValue(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="FIELD", target="Lxaero/map/settings/ModSettings;debug:Z", opcode=180)}, remap=true)
    public boolean hideDebugRenderingOnF1(boolean original) {
        return original && !Minecraft.getInstance().options.hideGui;
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, slice={@Slice(from=@At(value="FIELD", target="Lxaero/map/gui/GuiMap;prevLoadingLeaves:Z", opcode=181))}, at={@At(value="INVOKE", target="Lxaero/map/graphics/MapRenderHelper;renderDynamicHighlight(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;IIIIIIFFFFFFFF)V", ordinal=0)}, remap=true)
    public void drawWorldMapFeatures(GuiGraphics guiGraphics, int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci, @Local(name={"flooredCameraX"}) int flooredCameraX, @Local(name={"flooredCameraZ"}) int flooredCameraZ, @Local(name={"matrixStack"}) PoseStack matrixStack, @Local(name={"renderTypeBuffers"}) MultiBufferSource.BufferSource renderTypeBuffers, @Local(name={"fboScale"}) double fboScale) {
        if (Minecraft.getInstance().options.hideGui) {
            return;
        }
        Globals.drawManager.drawWorldMapFeatures(flooredCameraX, flooredCameraZ, matrixStack, fboScale, renderTypeBuffers);
    }

    @WrapWithCondition(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lxaero/map/graphics/MapRenderHelper;renderDynamicHighlight(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;IIIIIIFFFFFFFF)V")}, remap=true)
    public boolean hideHighlightsOnF1(PoseStack matrixStack, VertexConsumer overlayBuffer, int flooredCameraX, int flooredCameraZ, int leftX, int rightX, int topZ, int bottomZ, float sideR, float sideG, float sideB, float sideA, float centerR, float centerG, float centerB, float centerA) {
        return !Minecraft.getInstance().options.hideGui;
    }

    @WrapOperation(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lxaero/map/element/MapElementRenderHandler;render(Lxaero/map/gui/GuiMap;Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;Lxaero/map/graphics/renderer/multitexture/MultiTextureRenderTypeRendererProvider;DDIIDDDDDFZLxaero/map/element/HoveredMapElementHolder;Lnet/minecraft/client/Minecraft;F)Lxaero/map/element/HoveredMapElementHolder;")}, remap=true)
    public HoveredMapElementHolder<?, ?> hideMapElementsOnF1(MapElementRenderHandler handler, GuiMap mapScreen, GuiGraphics guiGraphics, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, double cameraX, double cameraZ, int width, int height, double screenSizeBasedScale, double scale, double playerDimDiv, double mouseX, double mouseZ, float brightness, boolean cave, HoveredMapElementHolder<?, ?> oldHovered, Minecraft mc, float partialTicks, Operation<HoveredMapElementHolder<?, ?>> original) {
        if (!Minecraft.getInstance().options.hideGui) {
            return (HoveredMapElementHolder)original.call(new Object[]{handler, mapScreen, guiGraphics, renderTypeBuffers, rendererProvider, cameraX, cameraZ, width, height, screenSizeBasedScale, scale, playerDimDiv, mouseX, mouseZ, Float.valueOf(brightness), cave, oldHovered, mc, Float.valueOf(partialTicks)});
        }
        return null;
    }

    @ModifyExpressionValue(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="FIELD", target="Lxaero/map/settings/ModSettings;footsteps:Z", opcode=180)}, remap=true)
    public boolean hideFootstepsOnF1(boolean original) {
        return original && !Minecraft.getInstance().options.hideGui;
    }

    @ModifyExpressionValue(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="FIELD", target="Lxaero/map/settings/ModSettings;renderArrow:Z", opcode=180)}, remap=true)
    public boolean hideArrowOnF1(boolean original) {
        return original && !Minecraft.getInstance().options.hideGui;
    }

    @ModifyArg(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, slice=@Slice(from=@At(value="FIELD", opcode=180, target="Lxaero/map/settings/ModSettings;coordinates:Z")), at=@At(value="INVOKE", target="Lxaero/map/graphics/MapRenderHelper;drawCenteredStringWithBackground(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIFFFFLcom/mojang/blaze3d/vertex/VertexConsumer;)V", ordinal=0), index=2)
    public String renderCrossDimensionCursorCoordinates(String original) {
        if (!Settings.REGISTRY.crossDimensionCursorCoordinates.get()) {
            return original;
        }
        ResourceKey<Level> dim = Globals.getCurrentDimensionId();
        if (dim != Level.OVERWORLD && dim != Level.NETHER) {
            return original;
        }
        double dimDiv = dim == Level.NETHER ? 0.125 : 8.0;
        int x = (int)((double)this.mouseBlockPosX / dimDiv);
        int z = (int)((double)this.mouseBlockPosZ / dimDiv);
        return original + " [" + x + ", " + z + "]";
    }

    @WrapWithCondition(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lxaero/map/graphics/MapRenderHelper;drawCenteredStringWithBackground(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIFFFFLcom/mojang/blaze3d/vertex/VertexConsumer;)V")}, remap=true)
    public boolean hideRenderedStringsOnF1(GuiGraphics guiGraphics, Font font, String string, int x, int y, int color, float bgRed, float bgGreen, float bgBlue, float bgAlpha, VertexConsumer backgroundVertexBuffer) {
        return !Minecraft.getInstance().options.hideGui;
    }

    @WrapWithCondition(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Ljava/util/function/Function;Lnet/minecraft/resources/ResourceLocation;IIFFIIII)V")}, remap=true)
    public boolean hideCompassOnF1(GuiGraphics instance, Function<ResourceLocation, RenderType> function, ResourceLocation resourceLocation, int i, int j, float f, float g, int k, int l, int m, int n) {
        return !Minecraft.getInstance().options.hideGui;
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lxaero/map/gui/ScreenBase;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V")}, remap=true)
    public void hideButtonsOnF1(GuiGraphics guiGraphics, int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci) {
        if (Minecraft.getInstance().options.hideGui) {
            List<Button> buttonList = this.getButtonList();
            if (!buttonList.isEmpty()) {
                this.guiMapButtonTempList.clear();
                this.guiMapButtonTempList.addAll(buttonList);
                this.xTextEntryField.setVisible(false);
                this.zTextEntryField.setVisible(false);
                this.clearButtons();
            }
        } else if (!this.guiMapButtonTempList.isEmpty()) {
            this.clearButtons();
            this.guiMapButtonTempList.forEach(this::addButton);
            this.guiMapButtonTempList.clear();
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lxaero/map/graphics/MapRenderHelper;restoreDefaultShaderBlendState()V")}, remap=true)
    public void renderCoordinatesGotoTextEntryFields(GuiGraphics guiGraphics, int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen != null && mc.screen.getClass().equals(GuiMap.class) && this.xTextEntryField.isVisible() && this.zTextEntryField.isVisible()) {
            this.xTextEntryField.render(guiGraphics, scaledMouseX, scaledMouseY, partialTicks);
            this.zTextEntryField.render(guiGraphics, scaledMouseX, scaledMouseY, partialTicks);
        }
    }

    @WrapWithCondition(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lxaero/map/graphics/MapRenderHelper;drawCenteredStringWithBackground(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;IIIFFFFLcom/mojang/blaze3d/vertex/VertexConsumer;)V")}, remap=true)
    public boolean hideMoreRenderedStringsOnF1(GuiGraphics guiGraphics, Font font, Component text, int x, int y, int color, float bgRed, float bgGreen, float bgBlue, float bgAlpha, VertexConsumer backgroundVertexBuffer) {
        return !Minecraft.getInstance().options.hideGui;
    }

    @Inject(method={"onDimensionToggleButton(Lnet/minecraft/client/gui/components/Button;)V"}, at={@At(value="RETURN")})
    public void onDimensionToggleAfter(Button b, CallbackInfo ci) {
        if (!Settings.REGISTRY.radarWhileDimensionSwitchedSetting.get()) {
            WorldMap.settings.minimapRadar = this.mapProcessor.getMapWorld().getFutureDimensionId() == ChunkUtils.getActualDimension();
        }
    }

    @Inject(method={"onInputPress(Lcom/mojang/blaze3d/platform/InputConstants$Type;I)Z"}, at={@At(value="HEAD")})
    public void panMouseButtonClick(InputConstants.Type type, int code, CallbackInfoReturnable<Boolean> cir) {
        if (type != InputConstants.Type.MOUSE) {
            return;
        }
        if (code != 2) {
            return;
        }
        this.pan = true;
        Minecraft mc = Minecraft.getInstance();
        this.panMouseStartX = Misc.getMouseX((Minecraft)mc, (boolean)true);
        this.panMouseStartY = Misc.getMouseY((Minecraft)mc, (boolean)true);
    }

    @Inject(method={"onInputRelease(Lcom/mojang/blaze3d/platform/InputConstants$Type;I)Z"}, at={@At(value="HEAD")})
    public void panMouseButtonRelease(InputConstants.Type type, int code, CallbackInfoReturnable<Boolean> cir) {
        if (type != InputConstants.Type.MOUSE) {
            return;
        }
        if (code != 2) {
            return;
        }
        this.pan = false;
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="HEAD")})
    public void panMapOnRender(GuiGraphics guiGraphics, int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci) {
        if (!this.pan) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        double mouseX = Misc.getMouseX((Minecraft)mc, (boolean)true);
        double mouseY = Misc.getMouseY((Minecraft)mc, (boolean)true);
        double mouseDeltaX = mouseX - this.panMouseStartX;
        double mouseDeltaY = mouseY - this.panMouseStartY;
        double panDeltaX = (double)partialTicks * mouseDeltaX / destScale;
        double panDeltaZ = (double)partialTicks * mouseDeltaY / destScale;
        this.cameraX += panDeltaX;
        this.cameraZ += panDeltaZ;
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="FIELD", target="Lxaero/map/settings/ModSettings;coordinates:Z", opcode=180, ordinal=0)}, remap=true)
    public void renderTileSelectionSize(GuiGraphics guiGraphics, int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci, @Local(name={"backgroundVertexBuffer"}) VertexConsumer backgroundVertexBuffer) {
        MapTileSelection selection = this.mapTileSelection;
        if (selection == null) {
            return;
        }
        int sideLen = Math.abs(selection.getRight() - selection.getLeft()) + 1;
        int heightLen = Math.abs(selection.getBottom() - selection.getTop()) + 1;
        if (sideLen <= 1 && heightLen <= 1) {
            return;
        }
        String string = sideLen + " x " + heightLen;
        Objects.requireNonNull(this.font);
        MapRenderHelper.drawCenteredStringWithBackground((GuiGraphics)guiGraphics, (Font)this.font, (String)string, (int)scaledMouseX, (int)(scaledMouseY - 9), (int)-1, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f, (VertexConsumer)backgroundVertexBuffer);
    }

    @Inject(method={"keyPressed(III)Z"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    public void onInputPress(int code, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (code == 290) {
            Minecraft.getInstance().options.hideGui = !Minecraft.getInstance().options.hideGui;
            cir.setReturnValue((Object)true);
            return;
        }
        if (this.xTextEntryField.isVisible() && this.zTextEntryField.isVisible() && (this.xTextEntryField.isFocused() || this.zTextEntryField.isFocused()) && code == 257) {
            this.onGotoCoordinatesButton(null);
            cir.setReturnValue((Object)true);
            return;
        }
        if (BaritoneHelper.isBaritonePresent()) {
            if (Settings.REGISTRY.worldMapBaritoneGoalHereKeybindSetting.getKeyBinding().matches(code, scanCode)) {
                BaritoneExecutor.goal(this.mouseBlockPosX, this.mouseBlockPosZ);
                cir.setReturnValue((Object)true);
            } else if (Settings.REGISTRY.worldMapBaritonePathHereKeybindSetting.getKeyBinding().matches(code, scanCode)) {
                BaritoneExecutor.path(this.mouseBlockPosX, this.mouseBlockPosZ);
                cir.setReturnValue((Object)true);
            } else if (BaritoneHelper.isBaritoneElytraPresent() && Settings.REGISTRY.worldMapBaritoneElytraHereKeybindSetting.getKeyBinding().matches(code, scanCode)) {
                BaritoneExecutor.elytra(this.mouseBlockPosX, this.mouseBlockPosZ);
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"getRightClickOptions()Ljava/util/ArrayList;"}, at={@At(value="RETURN")}, remap=false)
    public void getRightClickOptionsInject(CallbackInfoReturnable<ArrayList<RightClickOption>> cir) {
        ArrayList options = (ArrayList)cir.getReturnValue();
        int index = 3;
        options.add(index++, new RightClickOption("xaeroplus.gui.world_map.copy_coordinates", options.size(), this){

            public void onAction(Screen screen) {
                Minecraft.getInstance().keyboardHandler.setClipboard(MixinGuiMap.this.rightClickX + " " + MixinGuiMap.this.rightClickY + " " + MixinGuiMap.this.rightClickZ);
            }
        });
        if (BaritoneHelper.isBaritonePresent()) {
            final int goalX = this.rightClickX;
            final int goalZ = this.rightClickZ;
            options.add(index++, new RightClickOption(this, "xaeroplus.gui.world_map.baritone_goal_here", options.size(), this){

                public void onAction(Screen screen) {
                    BaritoneExecutor.goal(goalX, goalZ);
                }
            }.setNameFormatArgs(new Object[]{Misc.getKeyName((KeyMapping)Settings.REGISTRY.worldMapBaritoneGoalHereKeybindSetting.getKeyBinding())}));
            options.add(index++, new RightClickOption(this, "xaeroplus.gui.world_map.baritone_path_here", options.size(), this){

                public void onAction(Screen screen) {
                    BaritoneExecutor.path(goalX, goalZ);
                }
            }.setNameFormatArgs(new Object[]{Misc.getKeyName((KeyMapping)Settings.REGISTRY.worldMapBaritonePathHereKeybindSetting.getKeyBinding())}));
            if (BaritoneHelper.isBaritoneElytraPresent()) {
                options.add(index++, new RightClickOption(this, "xaeroplus.gui.world_map.baritone_elytra_here", options.size(), this){

                    public void onAction(Screen screen) {
                        BaritoneExecutor.elytra(goalX, goalZ);
                    }
                }.setNameFormatArgs(new Object[]{Misc.getKeyName((KeyMapping)Settings.REGISTRY.worldMapBaritoneElytraHereKeybindSetting.getKeyBinding())}));
            }
        }
        if (Settings.REGISTRY.disableWaypointSharing.get()) {
            options.removeIf(option -> ((AccessorRightClickOption)option).getName().equals("gui.xaero_right_click_map_share_location"));
        }
    }

    @Unique
    public void onFollowButton(Button b) {
        follow = !follow;
        this.init(Minecraft.getInstance(), this.width, this.height);
    }

    public void onGotoCoordinatesButton(Button b) {
        if (this.xTextEntryField.isVisible() && this.zTextEntryField.isVisible()) {
            try {
                int x = Integer.parseInt(this.xTextEntryField.getValue());
                int z = Integer.parseInt(this.zTextEntryField.getValue());
                this.cameraX = x;
                this.cameraZ = z;
                follow = false;
                this.init(Minecraft.getInstance(), this.width, this.height);
            }
            catch (NumberFormatException e) {
                this.xTextEntryField.setValue("");
                this.zTextEntryField.setValue("");
                WorldMap.LOGGER.warn("Go to coordinates failed", (Throwable)e);
            }
        } else {
            this.xTextEntryField.setVisible(true);
            this.zTextEntryField.setVisible(true);
            this.setFocused((GuiEventListener)this.xTextEntryField);
            this.xTextEntryField.setEditable(true);
            this.xTextEntryField.setFocused(true);
        }
    }

    @Unique
    private void onSwitchDimensionButton(ResourceKey<Level> newDimId) {
        Globals.switchToDimension(newDimId);
    }

    @Unique
    public List<Button> getButtonList() {
        return this.children().stream().filter(child -> child instanceof Button).map(child -> (Button)child).collect(Collectors.toList());
    }

    @Unique
    public void clearButtons() {
        this.getButtonList().forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
    }
}

