/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.world.state.MinimapWorldState;
import xaero.hud.minimap.world.state.MinimapWorldStateUpdater;
import xaero.hud.path.XaeroPath;
import xaeroplus.settings.Settings;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.DataFolderResolveUtil;

@Mixin(value={MinimapWorldStateUpdater.class}, remap=false)
public abstract class MixinMinimapWorldStateUpdater {
    @Final
    @Shadow
    private MinimapSession session;
    @Final
    @Shadow
    private ClientPacketListener connection;
    @Unique
    private ResourceKey<Level> currentDim = Level.OVERWORLD;

    @WrapOperation(method={"update()V"}, at={@At(value="INVOKE", target="Lxaero/hud/minimap/world/state/MinimapWorldState;setAutoWorldPath(Lxaero/hud/path/XaeroPath;)V")})
    public void preferOverworldWpSetCustomPathOnDimUpdate(MinimapWorldState instance, XaeroPath autoWorldPath, Operation<Void> original, @Local(name={"oldAutoWorldPath"}) XaeroPath oldAutoWorldPath, @Local(name={"potentialAutoWorldNode"}) String potentialAutoWorldNode) {
        ResourceKey<Level> actualDimension;
        original.call(new Object[]{instance, autoWorldPath});
        if (Settings.REGISTRY.owAutoWaypointDimension.get() && (actualDimension = ChunkUtils.getActualDimension()) == Level.NETHER && this.currentDim != actualDimension) {
            XaeroPath overworldWpXaeroPath = this.session.getWorldState().getAutoRootContainerPath().resolve(this.session.getDimensionHelper().getDimensionDirectoryName(Level.OVERWORLD)).resolve(potentialAutoWorldNode);
            this.session.getWorldState().setCustomWorldPath(overworldWpXaeroPath);
        }
        this.currentDim = ChunkUtils.getActualDimension();
    }

    @Inject(method={"getAutoRootContainerPath(I)Lxaero/hud/path/XaeroPath;"}, at={@At(value="HEAD")}, cancellable=true)
    public void customDataFolderResolve(int version, CallbackInfoReturnable<XaeroPath> cir) {
        CallbackInfoReturnable customCir = new CallbackInfoReturnable("a", true);
        DataFolderResolveUtil.resolveDataFolder(this.connection, (CallbackInfoReturnable<String>)customCir);
        if (customCir.isCancelled()) {
            cir.setReturnValue((Object)XaeroPath.root((String)((String)customCir.getReturnValue())));
        }
    }
}

