/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import it.unimi.dsi.fastutil.doubles.DoubleArrayFIFOQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.render.world.WaypointWorldRenderer;
import xaeroplus.settings.Settings;
import xaeroplus.util.ChunkUtils;

@Mixin(value={WaypointWorldRenderer.class}, remap=false)
public class MixinWaypointWorldRenderer {
    @Shadow
    private String subWorldName;
    @Unique
    long xaeroPlus$lastSpeedUpdate = 0L;
    @Unique
    public final DoubleArrayFIFOQueue xaeroPlus$speedQueue = new DoubleArrayFIFOQueue(15);

    @ModifyArg(method={"renderElement(Lxaero/common/minimap/waypoints/Waypoint;ZZDFDDLxaero/hud/minimap/element/render/MinimapElementRenderInfo;Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;)Z"}, at=@At(value="INVOKE", target="Lxaero/hud/minimap/waypoint/render/world/WaypointWorldRenderer;renderIconWithLabels(Lxaero/common/minimap/waypoints/Waypoint;ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;FIILnet/minecraft/client/gui/Font;ILcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;)V"), index=4, remap=false)
    public String preferOwWaypointsRemoveSubworldText(String name) {
        if (!Settings.REGISTRY.owAutoWaypointDimension.get()) {
            return name;
        }
        if (this.subWorldName == null) {
            return name;
        }
        ResourceKey<Level> actualDimension = ChunkUtils.getActualDimension();
        ResourceKey currentWpWorldDim = ((MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession()).getWorldManager().getCurrentWorld().getDimId();
        if (actualDimension == Level.NETHER && currentWpWorldDim == Level.OVERWORLD) {
            return null;
        }
        return name;
    }

    @ModifyArg(method={"renderElement(Lxaero/common/minimap/waypoints/Waypoint;ZZDFDDLxaero/hud/minimap/element/render/MinimapElementRenderInfo;Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;)Z"}, at=@At(value="INVOKE", target="Lxaero/hud/minimap/waypoint/render/world/WaypointWorldRenderer;renderIconWithLabels(Lxaero/common/minimap/waypoints/Waypoint;ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;FIILnet/minecraft/client/gui/Font;ILcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;)V"), index=3, remap=false)
    public String modifyDistanceText(String text, @Local(argsOnly=true) Waypoint waypoint) {
        if (!Settings.REGISTRY.waypointEta.get()) {
            return text;
        }
        if (text == null || text.isBlank()) {
            return text;
        }
        long eta = this.getEtaSecondsToReachWaypoint(waypoint);
        if (eta <= 0L) {
            return text;
        }
        Object etaText = " - ";
        if (eta > 86400L) {
            int days = (int)(eta / 86400L);
            int hours = (int)(eta % 86400L / 3600L);
            etaText = (String)etaText + days + "d";
            if (hours > 0) {
                etaText = (String)etaText + " " + hours + "h";
            }
        } else if (eta > 3600L) {
            int hours = (int)(eta / 3600L);
            int minutes = (int)(eta % 3600L / 60L);
            etaText = (String)etaText + hours + "h";
            if (minutes > 0) {
                etaText = (String)etaText + " " + minutes + "m";
            }
        } else if (eta > 60L) {
            int minutes = (int)(eta / 60L);
            int seconds = (int)(eta % 60L);
            etaText = (String)etaText + minutes + "m";
            if (seconds > 0) {
                etaText = (String)etaText + " " + seconds + "s";
            }
        } else {
            etaText = (String)etaText + eta + "s";
        }
        return text + (String)etaText;
    }

    @Unique
    public long getEtaSecondsToReachWaypoint(Waypoint waypoint) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return 0L;
        }
        try {
            Vec3 playerVec = mc.player.position();
            MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
            if (minimapSession == null) {
                return 0L;
            }
            double dimDiv = minimapSession.getDimensionHelper().getDimensionDivision(minimapSession.getWorldManager().getCurrentWorld());
            int wpX = waypoint.getX(dimDiv);
            int wpZ = waypoint.getZ(dimDiv);
            double directionX = (double)wpX - playerVec.x;
            double directionZ = (double)wpZ - playerVec.z;
            double movementX = playerVec.x - mc.player.xOld;
            double movementZ = playerVec.z - mc.player.zOld;
            double dot = directionX * movementX + directionZ * movementZ;
            double distance = Math.sqrt(directionX * directionX + directionZ * directionZ);
            double speed = this.xaeroPlus$speedQueue.isEmpty() ? 0.0 : this.xaeroPlus$avgSpeed(this.xaeroPlus$speedQueue);
            double cos = dot / (distance * speed);
            double time = distance / speed;
            double etaTicks = time / cos;
            double etaSeconds = etaTicks / 20.0;
            long updateDeltaMs = System.currentTimeMillis() - this.xaeroPlus$lastSpeedUpdate;
            if (updateDeltaMs > 50L) {
                this.xaeroPlus$lastSpeedUpdate = System.currentTimeMillis();
                double s = Math.sqrt(movementX * movementX + movementZ * movementZ);
                if (s > 0.0 || mc.player.tickCount % 4 == 0) {
                    this.xaeroPlus$speedQueue.enqueue(s);
                } else if (!this.xaeroPlus$speedQueue.isEmpty()) {
                    this.xaeroPlus$speedQueue.dequeueDouble();
                }
                while (this.xaeroPlus$speedQueue.size() > 10) {
                    this.xaeroPlus$speedQueue.dequeueDouble();
                }
            }
            if (etaSeconds == Double.POSITIVE_INFINITY || etaSeconds == Double.NEGATIVE_INFINITY || Double.isNaN(etaSeconds)) {
                return 0L;
            }
            return (long)etaSeconds;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    @Unique
    private double xaeroPlus$avgSpeed(DoubleArrayFIFOQueue speedQueue) {
        double sum = 0.0;
        for (int i = 0; i < speedQueue.size(); ++i) {
            double v = speedQueue.dequeueDouble();
            speedQueue.enqueue(v);
            sum += v;
        }
        double s = sum / (double)speedQueue.size();
        if (s < 0.05) {
            return 0.0;
        }
        return s;
    }
}

