/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.List;
import kaptainwutax.mathutils.util.Mth;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaeroplus.Globals;
import xaeroplus.feature.render.Line;
import xaeroplus.module.Module;
import xaeroplus.settings.Settings;
import xaeroplus.util.ColorHelper;

public class Highways
extends Module {
    private int highwaysColor = ColorHelper.getColor(0, 0, 255, 100);
    private int width = 2;
    private final List<Line> OVERWORLD_END_LINES = this.generateHighwayLines((ResourceKey<Level>)Level.OVERWORLD);
    private final List<Line> NETHER_LINES = this.generateHighwayLines((ResourceKey<Level>)Level.NETHER);
    private static final IntList ringRoads = IntList.of((int[])new int[]{200, 500, 1000, 1500, 2000, 2500, 5000, 7500, 10000, 15000, 20000, 25000, 50000, 55000, 62500, 75000, 100000, 125000, 250000, 500000, 750000, 1000000, 1250000, 1568852, 1875000, 2500000, 3750000});
    private static final IntList diamonds = IntList.of((int[])new int[]{2500, 5000, 25000, 50000, 125000, 250000, 500000, 3750000});

    @Override
    public void onEnable() {
        Globals.drawManager.registry().registerLineProvider(this.getClass().getName(), this::getHighwayLines, this::getHighwayColor, this::getLineWidth, 5000);
    }

    private List<Line> getHighwayLines(int windowRegionX, int windowRegionZ, int windowSize, ResourceKey<Level> dimension) {
        if (dimension == Level.OVERWORLD || dimension == Level.END) {
            return this.OVERWORLD_END_LINES;
        }
        if (dimension == Level.NETHER) {
            return this.NETHER_LINES;
        }
        return new ArrayList<Line>();
    }

    private List<Line> generateHighwayLines(ResourceKey<Level> dimension) {
        int i;
        ArrayList<Line> lines = new ArrayList<Line>(500);
        int stride = 500000;
        for (i = -30000000; i < 30000000; i += stride) {
            lines.add(new Line(i, 0, i + stride, 0));
            lines.add(new Line(0, i, 0, i + stride));
        }
        for (i = -30000000; i < 30000000; i += stride) {
            lines.add(new Line(i, i, i + stride, i + stride));
            lines.add(new Line(-i, i, -i - stride, i + stride));
        }
        if (dimension == Level.NETHER) {
            IntListIterator i2 = ringRoads.iterator();
            while (i2.hasNext()) {
                int ringRoad = (Integer)i2.next();
                for (int i3 = -ringRoad; i3 < ringRoad; i3 += stride) {
                    lines.add(new Line(i3, -ringRoad, Mth.min((int[])new int[]{i3 + stride, ringRoad}), -ringRoad));
                    lines.add(new Line(i3, ringRoad, Mth.min((int[])new int[]{i3 + stride, ringRoad}), ringRoad));
                    lines.add(new Line(-ringRoad, i3, -ringRoad, Mth.min((int[])new int[]{i3 + stride, ringRoad})));
                    lines.add(new Line(ringRoad, i3, ringRoad, Mth.min((int[])new int[]{i3 + stride, ringRoad})));
                }
            }
            i2 = diamonds.iterator();
            while (i2.hasNext()) {
                int diamond = (Integer)i2.next();
                lines.add(new Line(diamond, 0, 0, diamond));
                lines.add(new Line(0, -diamond, diamond, 0));
                lines.add(new Line(0, -diamond, -diamond, 0));
                lines.add(new Line(-diamond, 0, 0, diamond));
            }
            for (int i4 = -50000; i4 < 50000; i4 += 5000) {
                if (i4 == 0) continue;
                lines.add(new Line(i4, -50000, i4, 50000));
                lines.add(new Line(-50000, i4, 50000, i4));
            }
            lines.add(new Line(-125000, -50000, -50000, -50000));
            lines.add(new Line(-125000, 50000, -50000, 50000));
            lines.add(new Line(125000, -50000, 50000, -50000));
            lines.add(new Line(125000, 50000, 50000, 50000));
            lines.add(new Line(-50000, -125000, -50000, -50000));
            lines.add(new Line(-50000, 125000, -50000, 50000));
            lines.add(new Line(50000, -125000, 50000, -50000));
            lines.add(new Line(50000, 125000, 50000, 50000));
        }
        return lines;
    }

    @Override
    public void onDisable() {
        Globals.drawManager.registry().unregisterLineProvider(this.getClass().getName());
    }

    public int getHighwayColor() {
        return this.highwaysColor;
    }

    public void setRgbColor(int color) {
        this.highwaysColor = ColorHelper.getColorWithAlpha(color, Settings.REGISTRY.highwaysColorAlphaSetting.getAsInt());
    }

    public void setAlpha(double a) {
        this.highwaysColor = ColorHelper.getColorWithAlpha(this.highwaysColor, (int)a);
    }

    public void setWidth(Settings.HighwayWidth w) {
        this.width = w.getWidth();
    }

    private float getLineWidth() {
        return this.width;
    }
}

