/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalBlock;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import xaeroplus.Globals;
import xaeroplus.event.ChunkBlockUpdateEvent;
import xaeroplus.event.ChunkBlocksUpdateEvent;
import xaeroplus.event.ChunkDataEvent;
import xaeroplus.feature.render.highlights.SavableHighlightCacheInstance;
import xaeroplus.lambdaevents.EventHandler;
import xaeroplus.module.Module;
import xaeroplus.settings.Settings;
import xaeroplus.util.ChunkScanner;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class Portals
extends Module {
    public final SavableHighlightCacheInstance portalsCache = new SavableHighlightCacheInstance("XaeroPlusPortals");
    private int portalsColor = ColorHelper.getColor(0, 255, 0, 100);
    private static final ReferenceSet<Block> PORTAL_BLOCKS = ReferenceOpenHashSet.of((Object[])new Block[]{Blocks.END_PORTAL, Blocks.END_GATEWAY, Blocks.NETHER_PORTAL, Blocks.END_PORTAL_FRAME});

    public void setDiskCache(boolean disk) {
        this.portalsCache.setDiskCache(disk, this.isEnabled());
    }

    @Override
    public void onEnable() {
        Globals.drawManager.registry().registerDirectChunkHighlightProvider(this.getClass().getName(), this::getHighlightsState, this::getPortalsColor);
        this.portalsCache.onEnable();
        this.searchAllLoadedChunks();
    }

    @Override
    public void onDisable() {
        this.portalsCache.onDisable();
        Globals.drawManager.registry().unregisterChunkHighlightProvider(this.getClass().getName());
    }

    @EventHandler
    public void onChunkData(ChunkDataEvent event) {
        this.findPortalInChunk((ChunkAccess)event.chunk());
    }

    @EventHandler
    public void onMultiBlockUpdate(ChunkBlocksUpdateEvent event) {
        switch (event.phase()) {
            case PRE: {
                event.packet().runUpdates(this::handleBlockChange);
                break;
            }
            case POST: {
                this.handleMultiBlockChangePost(event);
            }
        }
    }

    private void handleMultiBlockChangePost(ChunkBlocksUpdateEvent event) {
        ClientLevel level = this.mc.level;
        if (level == null) {
            return;
        }
        event.packet().runUpdates((blockPos, blockState) -> {
            if (!blockState.isAir()) {
                return;
            }
            int chunkX = ChunkUtils.posToChunkPos(blockPos.getX());
            int chunkZ = ChunkUtils.posToChunkPos(blockPos.getZ());
            if (!this.portalsCache.get().isHighlighted(chunkX, chunkZ, ChunkUtils.getActualDimension())) {
                return;
            }
            LevelChunk chunk = level.getChunkSource().getChunk(chunkX, chunkZ, false);
            if (chunk instanceof EmptyLevelChunk || chunk == null) {
                return;
            }
            this.findPortalInChunk((ChunkAccess)chunk);
        });
    }

    @EventHandler
    public void onBlockUpdate(ChunkBlockUpdateEvent event) {
        switch (event.phase()) {
            case PRE: {
                this.handleBlockChange(event.packet().getPos(), event.packet().getBlockState());
                break;
            }
            case POST: {
                this.handleBlockChangePost(event);
            }
        }
    }

    private void handleBlockChangePost(ChunkBlockUpdateEvent event) {
        ClientLevel level = this.mc.level;
        if (level == null) {
            return;
        }
        BlockPos blockPos = event.packet().getPos();
        BlockState blockState = event.packet().getBlockState();
        if (!blockState.isAir()) {
            return;
        }
        int chunkX = ChunkUtils.posToChunkPos(blockPos.getX());
        int chunkZ = ChunkUtils.posToChunkPos(blockPos.getZ());
        if (!this.portalsCache.get().isHighlighted(chunkX, chunkZ, ChunkUtils.getActualDimension())) {
            return;
        }
        LevelChunk chunk = level.getChunkSource().getChunk(chunkX, chunkZ, false);
        if (chunk instanceof EmptyLevelChunk || chunk == null) {
            return;
        }
        this.findPortalInChunk((ChunkAccess)chunk);
    }

    private void findPortalInChunk(ChunkAccess chunk) {
        boolean chunkHadPortal = this.portalsCache.get().isHighlighted(chunk.getPos().x, chunk.getPos().z, ChunkUtils.getActualDimension());
        boolean hasPortal = ChunkScanner.chunkContainsBlocks(chunk, PORTAL_BLOCKS, this.mc.level.getMinY());
        if (hasPortal) {
            this.portalsCache.get().addHighlight(chunk.getPos().x, chunk.getPos().z);
        } else if (chunkHadPortal) {
            this.portalsCache.get().removeHighlight(chunk.getPos().x, chunk.getPos().z);
        }
    }

    private void searchAllLoadedChunks() {
        if (this.mc.level == null) {
            return;
        }
        int renderDist = (Integer)this.mc.options.renderDistance().get();
        int xMin = ChunkUtils.getPlayerChunkX() - renderDist;
        int xMax = ChunkUtils.getPlayerChunkX() + renderDist;
        int zMin = ChunkUtils.getPlayerChunkZ() - renderDist;
        int zMax = ChunkUtils.getPlayerChunkZ() + renderDist;
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                LevelChunk chunk = this.mc.level.getChunkSource().getChunk(x, z, false);
                if (chunk instanceof EmptyLevelChunk || chunk == null) continue;
                this.findPortalInChunk((ChunkAccess)chunk);
            }
        }
    }

    private void handleBlockChange(BlockPos pos, BlockState state) {
        int chunkX = ChunkUtils.posToChunkPos(pos.getX());
        int chunkZ = ChunkUtils.posToChunkPos(pos.getZ());
        if (!(state.getBlock() instanceof NetherPortalBlock) && !(state.getBlock() instanceof EndPortalBlock)) {
            return;
        }
        this.portalsCache.get().addHighlight(chunkX, chunkZ);
    }

    public int getPortalsColor() {
        return this.portalsColor;
    }

    public void setRgbColor(int color) {
        this.portalsColor = ColorHelper.getColorWithAlpha(color, Settings.REGISTRY.portalsAlphaSetting.getAsInt());
    }

    public void setAlpha(double a) {
        this.portalsColor = ColorHelper.getColorWithAlpha(this.portalsColor, (int)a);
    }

    public boolean isPortalChunk(int chunkPosX, int chunkPosZ, ResourceKey<Level> dimensionId) {
        return this.portalsCache.get().isHighlighted(chunkPosX, chunkPosZ, dimensionId);
    }

    public Long2LongMap getHighlightsState(ResourceKey<Level> dimension) {
        return this.portalsCache.get().getCacheMap(dimension);
    }
}

