/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.util;

import com.google.common.net.InternetDomainName;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.common.HudMod;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;
import xaero.map.MapProcessor;
import xaero.map.WorldMapSession;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.file.MapSaveLoad;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.settings.Settings;

public class DataFolderResolveUtil {
    public static void resolveDataFolder(ClientPacketListener connection, CallbackInfoReturnable<String> cir) {
        Settings.DataFolderResolutionMode dataFolderResolutionMode = Globals.dataFolderResolutionMode;
        if (dataFolderResolutionMode == Settings.DataFolderResolutionMode.SERVER_NAME) {
            String serverName;
            if (Objects.nonNull(connection.getServerData()) && !(serverName = connection.getServerData().name).isEmpty()) {
                cir.setReturnValue((Object)DataFolderResolveUtil.sanitizeDataFolderName("Multiplayer_" + serverName));
                cir.cancel();
                return;
            }
            if (!Minecraft.getInstance().hasSingleplayerServer()) {
                XaeroPlus.LOGGER.error("Unable to resolve valid MC Server Name. Falling back to default Xaero data folder resolution");
            }
        } else if (dataFolderResolutionMode == Settings.DataFolderResolutionMode.BASE_DOMAIN && Objects.nonNull(connection.getServerData())) {
            Object id;
            try {
                id = InternetDomainName.from((String)connection.getServerData().ip).topPrivateDomain().toString();
            }
            catch (IllegalArgumentException ex) {
                XaeroPlus.LOGGER.error("Error resolving BASE_DOMAIN data folder. Falling back to default Xaero resolution.", (Throwable)ex);
                return;
            }
            while (((String)id).endsWith(".")) {
                id = ((String)id).substring(0, ((String)id).length() - 1);
            }
            if (!((String)id).isEmpty()) {
                id = "Multiplayer_" + (String)id;
                cir.setReturnValue((Object)DataFolderResolveUtil.sanitizeDataFolderName((String)id));
                cir.cancel();
                return;
            }
            if (!Minecraft.getInstance().hasSingleplayerServer()) {
                XaeroPlus.LOGGER.error("Unable to resolve valid Base domain. Falling back to default Xaero data folder resolution");
            }
        }
    }

    public static Component getCurrentDataDirPath() {
        try {
            WorldMapSession currentSession = XaeroWorldMapCore.currentSession;
            MapProcessor mapProcessor = currentSession.getMapProcessor();
            String mainId = mapProcessor.getMapWorld().getMainId();
            Path rootFolder = MapSaveLoad.getRootFolder((String)mainId);
            return Component.literal((String)rootFolder.toString()).append((Component)Component.literal((String)" (").append((Component)Component.literal((String)"Click To Open").withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.OpenFile(rootFolder.toString())).withColor(ChatFormatting.GOLD))).append((Component)Component.literal((String)")")));
        }
        catch (Throwable e) {
            XaeroPlus.LOGGER.error("Failed to get data directory", e);
            return Component.literal((String)"Failed to get data directory");
        }
    }

    public static Component getCurrentWaypointDataDirPath() {
        try {
            Path minimapDataFolder = HudMod.INSTANCE.getMinimapFolder();
            MinimapSession session = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
            Path rootFolder = session.getWorldState().getCurrentRootContainerPath().applyToFilePath(minimapDataFolder);
            return Component.literal((String)rootFolder.toString()).append((Component)Component.literal((String)" (").append((Component)Component.literal((String)"Click To Open").withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.OpenFile(rootFolder.toString())).withColor(ChatFormatting.GOLD))).append((Component)Component.literal((String)")")));
        }
        catch (Throwable e) {
            XaeroPlus.LOGGER.error("Failed to get data directory", e);
            return Component.literal((String)"Failed to get data directory");
        }
    }

    public static String sanitizeDataFolderName(String in) {
        String invalidChars = "[<>:\"/\\|?*]";
        return in.replaceAll("[<>:\"/\\|?*]", "_").trim();
    }
}

