/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render;

import java.util.function.IntSupplier;
import xaeroplus.feature.render.DrawFeature;
import xaeroplus.feature.render.highlight.AsyncChunkHighlightDrawFeature;
import xaeroplus.feature.render.highlight.AsyncChunkHighlightProvider;
import xaeroplus.feature.render.highlight.AsyncChunkHighlightSupplier;
import xaeroplus.feature.render.highlight.DirectChunkHighlightDrawFeature;
import xaeroplus.feature.render.highlight.DirectChunkHighlightProvider;
import xaeroplus.feature.render.highlight.DirectChunkHighlightSupplier;
import xaeroplus.feature.render.highlight.HighlightVertexBuffer;
import xaeroplus.feature.render.highlight.MultiColorHighlightColorFunction;
import xaeroplus.feature.render.highlight.MultiColorHighlightVertexBuffer;
import xaeroplus.feature.render.line.LineDrawFeature;
import xaeroplus.feature.render.line.LineProvider;
import xaeroplus.feature.render.line.LineSupplier;
import xaeroplus.feature.render.line.MultiColorLineColorFunction;
import xaeroplus.feature.render.line.MultiColorLineDrawFeature;
import xaeroplus.feature.render.line.MultiColorLineProvider;
import xaeroplus.feature.render.line.MultiColorLineSupplier;
import xaeroplus.feature.render.text.AsyncTextDrawFeature;
import xaeroplus.feature.render.text.DirectTextDrawFeature;
import xaeroplus.feature.render.text.TextSupplier;
import xaeroplus.util.FloatSupplier;

public interface DrawFeatureFactory {
    public static DrawFeature chunkHighlights(String id, DirectChunkHighlightSupplier chunkHighlightSupplier, IntSupplier colorSupplier, int refreshIntervalMs) {
        return new DirectChunkHighlightDrawFeature(id, new HighlightVertexBuffer(), new DirectChunkHighlightProvider(chunkHighlightSupplier, colorSupplier), refreshIntervalMs);
    }

    public static DrawFeature multiColorChunkHighlights(String id, DirectChunkHighlightSupplier chunkHighlightSupplier, MultiColorHighlightColorFunction colorFunction, int refreshIntervalMs) {
        return new DirectChunkHighlightDrawFeature(id, new MultiColorHighlightVertexBuffer(colorFunction), new DirectChunkHighlightProvider(chunkHighlightSupplier, () -> 0), refreshIntervalMs);
    }

    public static DrawFeature asyncChunkHighlights(String id, AsyncChunkHighlightSupplier chunkHighlightSupplier, IntSupplier colorSupplier) {
        return new AsyncChunkHighlightDrawFeature(id, new HighlightVertexBuffer(), new AsyncChunkHighlightProvider(chunkHighlightSupplier, colorSupplier));
    }

    public static DrawFeature multiColorAsyncChunkHighlights(String id, AsyncChunkHighlightSupplier chunkHighlightSupplier, MultiColorHighlightColorFunction colorFunction) {
        return new AsyncChunkHighlightDrawFeature(id, new MultiColorHighlightVertexBuffer(colorFunction), new AsyncChunkHighlightProvider(chunkHighlightSupplier, () -> 0));
    }

    public static DrawFeature lines(String id, LineSupplier lineSupplier, IntSupplier colorSupplier, FloatSupplier lineWidthSupplier, int refreshIntervalMs) {
        return new LineDrawFeature(id, new LineProvider(lineSupplier, colorSupplier, lineWidthSupplier), refreshIntervalMs);
    }

    public static DrawFeature multiColorLines(String id, MultiColorLineSupplier lineSupplier, MultiColorLineColorFunction colorFunction, FloatSupplier lineWidthSupplier, int refreshIntervalMs) {
        return new MultiColorLineDrawFeature(id, new MultiColorLineProvider(lineSupplier, colorFunction, lineWidthSupplier), refreshIntervalMs);
    }

    public static DrawFeature text(String id, TextSupplier textSupplier) {
        return new DirectTextDrawFeature(id, textSupplier);
    }

    public static DrawFeature text(String id, TextSupplier textSupplier, int refreshIntervalMs) {
        return new AsyncTextDrawFeature(id, textSupplier, refreshIntervalMs);
    }
}

