/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.buffered;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.IntSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.CoreShaders;
import net.minecraft.client.renderer.ShaderProgram;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import xaeroplus.feature.render.buffered.Model;
import xaeroplus.module.impl.FpsLimiter;
import xaeroplus.settings.Settings;

public class BufferedComponent {
    private static final Minecraft mc = Minecraft.getInstance();
    private Model model = null;
    private final RenderTarget renderTarget = new TextureTarget(100, 100, true);
    private long nextRenderCapture = System.currentTimeMillis();
    private final IntSupplier fpsLimitSupplier;
    private final Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());

    public BufferedComponent(IntSupplier fpsLimitSupplier) {
        this.fpsLimitSupplier = fpsLimitSupplier;
    }

    private void refreshModel(int screenWidth, int screenHeight) {
        if (this.model != null) {
            this.model.close();
        }
        Vector3f[] posMatrix = new Vector3f[]{new Vector3f(0.0f, (float)screenHeight, 1.0f), new Vector3f((float)screenWidth, (float)screenHeight, 1.0f), new Vector3f((float)screenWidth, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f)};
        Vector2f[] texUvMatrix = new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f), new Vector2f(1.0f, 1.0f), new Vector2f(0.0f, 1.0f)};
        this.model = new Model(posMatrix, texUvMatrix);
    }

    public boolean render() {
        int windowWidth = mc.getWindow().getWidth();
        int windowHeight = mc.getWindow().getHeight();
        boolean forceRender = false;
        if (this.renderTarget.width != windowWidth || this.renderTarget.height != windowHeight) {
            this.renderTarget.resize(windowWidth, windowHeight);
            this.refreshModel(windowWidth, windowHeight);
            forceRender = true;
        }
        if (this.model == null) {
            this.refreshModel(windowWidth, windowHeight);
            forceRender = true;
        }
        if (forceRender || System.currentTimeMillis() > this.nextRenderCapture) {
            this.renderTarget.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.renderTarget.clear();
            this.renderTarget.bindWrite(false);
            FpsLimiter.renderTargetOverwrite = this.renderTarget;
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.renderTarget.bindWrite(false);
            return false;
        }
        this.renderBufferedTexture(this.renderTarget.getColorTextureId());
        return true;
    }

    public void postRender() {
        FpsLimiter.renderTargetOverwrite = null;
        this.renderTarget.unbindWrite();
        mc.getMainRenderTarget().bindWrite(true);
        this.nextRenderCapture = System.currentTimeMillis() + (long)(1000 / this.fpsLimitSupplier.getAsInt());
        this.renderBufferedTexture(this.renderTarget.getColorTextureId());
    }

    private void renderBufferedTexture(int textureId) {
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_TEX);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (int)textureId);
        this.modelViewMatrix.set((Matrix4fc)RenderSystem.getModelViewMatrix());
        this.modelViewMatrix.translate(0.0f, 0.0f, 399.0f + (float)Settings.REGISTRY.minimapRenderZOffsetSetting.get());
        float guiScale = (float)Math.max(1.0, mc.getWindow().getGuiScale());
        this.modelViewMatrix.scale(1.0f / guiScale);
        this.model.draw(this.modelViewMatrix);
    }
}

