/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.graphics.shader.MinimapShaders;
import xaero.common.minimap.render.MinimapFBORenderer;
import xaero.common.minimap.render.MinimapRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.mods.SupportXaeroWorldmap;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.Minimap;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.compass.render.CompassRenderer;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.render.WaypointMapRenderer;
import xaeroplus.Globals;
import xaeroplus.feature.extensions.CustomMinimapFBORenderer;
import xaeroplus.settings.Settings;
import xaeroplus.util.ColorHelper;

@Mixin(value={MinimapFBORenderer.class}, remap=false)
public abstract class MixinMinimapFBORenderer
extends MinimapRenderer
implements CustomMinimapFBORenderer {
    @Shadow
    private ImprovedFramebuffer scalingFramebuffer;
    @Shadow
    private ImprovedFramebuffer rotationFramebuffer;
    @Shadow
    private boolean loadedFBO;

    public MixinMinimapFBORenderer(IXaeroMinimap modMain, class_310 mc, WaypointsGuiRenderer waypointsGuiRenderer, Minimap minimap, CompassRenderer compassRenderer) {
        super(modMain, mc, (WaypointMapRenderer)waypointsGuiRenderer, minimap, compassRenderer);
    }

    @ModifyConstant(method={"loadFrameBuffer"}, constant={@Constant(intValue=512)})
    public int overrideFrameBufferSize(int size) {
        return Globals.minimapScaleMultiplier * 512;
    }

    @Override
    public void reloadMapFrameBuffers() {
        if (!((MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession()).getProcessor().canUseFrameBuffer()) {
            MinimapLogs.LOGGER.info("FBO mode not supported! Using minimap safe mode.");
        } else {
            if (this.scalingFramebuffer != null) {
                this.scalingFramebuffer.method_1238();
            }
            if (this.rotationFramebuffer != null) {
                this.rotationFramebuffer.method_1238();
            }
            int scaledSize = Globals.minimapScaleMultiplier * 512;
            this.scalingFramebuffer = new ImprovedFramebuffer(scaledSize, scaledSize, false);
            this.rotationFramebuffer = new ImprovedFramebuffer(scaledSize, scaledSize, true);
            this.rotationFramebuffer.method_1232(9729);
            this.loadedFBO = this.scalingFramebuffer.field_1476 != -1 && this.rotationFramebuffer.field_1476 != -1;
        }
    }

    @ModifyArg(method={"renderChunks"}, at=@At(value="INVOKE", target="Lxaero/common/minimap/render/MinimapFBORenderer;renderChunksToFBO(Lxaero/hud/minimap/module/MinimapSession;Lcom/mojang/blaze3d/vertex/PoseStack;Lxaero/common/minimap/MinimapProcessor;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/resources/ResourceKey;DIFIZZIDDZLxaero/common/graphics/CustomVertexConsumers;)V"), index=6, remap=true)
    public int modifyViewW(int viewW) {
        return viewW * Globals.minimapScaleMultiplier;
    }

    @Inject(method={"renderChunksToFBO"}, at={@At(value="HEAD")}, remap=true)
    public void modifyScaledSize(CallbackInfo ci, @Share(value="scaledSize") LocalIntRef scaledSize) {
        int s = 256 * Globals.minimapScaleMultiplier * Globals.minimapSizeMultiplier;
        if (Globals.minimapSizeMultiplier > 1) {
            int f = (Globals.minimapSizeMultiplier - 1) * Globals.minimapScaleMultiplier;
            s -= f * 6;
            int scaledMinimapSize = this.modMain.getSettings().getMinimapSize();
            int minimapNormalSize = scaledMinimapSize / Globals.minimapSizeMultiplier;
            int minimapScaledSizeDiff = 250 - minimapNormalSize;
            s -= minimapScaledSizeDiff * f;
        }
        scaledSize.set(s);
    }

    @Redirect(method={"renderChunksToFBO"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(DDD)V", ordinal=0), remap=true)
    public void modifyShaderMatrixStackTranslate(class_4587 instance, double x, double y, double z, @Share(value="scaledSize") LocalIntRef scaledSize) {
        float translate = 256.0f * (float)Globals.minimapScaleMultiplier;
        instance.method_22904((double)translate, (double)translate, -2000.0);
    }

    @Redirect(method={"renderChunksToFBO"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiComponent;fill(Lcom/mojang/blaze3d/vertex/PoseStack;IIIII)V"), remap=true)
    public void modifyMMBackgroundFill(class_4587 guiGraphics, int x1, int y1, int x2, int y2, int color, @Share(value="scaledSize") LocalIntRef scaledSize) {
        if (!Settings.REGISTRY.transparentMinimapBackground.get()) {
            class_332.method_25294((class_4587)guiGraphics, (int)(-scaledSize.get()), (int)(-scaledSize.get()), (int)scaledSize.get(), (int)scaledSize.get(), (int)ColorHelper.getColor(0, 0, 0, 255));
        } else {
            class_332.method_25294((class_4587)guiGraphics, (int)(-scaledSize.get()), (int)(-scaledSize.get()), (int)scaledSize.get(), (int)scaledSize.get(), (int)ColorHelper.getColor(0, 0, 0, 0));
        }
    }

    @Redirect(method={"renderChunksToFBO"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;lineWidth(F)V"), remap=true)
    public void modifyChunkGridLineWidth(float original) {
        RenderSystem.lineWidth((float)Math.max(1.0f, original * (float)Globals.minimapScaleMultiplier / (float)Globals.minimapSizeMultiplier));
    }

    @Redirect(method={"renderChunksToFBO"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(DDD)V", ordinal=0), slice=@Slice(from=@At(value="INVOKE", target="Lxaero/common/graphics/ImprovedFramebuffer;bindRead()V")), remap=true)
    public void correctPreRotationTranslationForSizeMult(class_4587 instance, double x, double y, double z) {
        instance.method_22904(x / (double)Globals.minimapSizeMultiplier, y / (double)Globals.minimapSizeMultiplier, z);
    }

    @Inject(method={"renderChunksToFBO"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(DDD)V", ordinal=1, shift=At.Shift.BEFORE)}, slice={@Slice(from=@At(value="INVOKE", target="Lxaero/common/graphics/ImprovedFramebuffer;bindRead()V"))}, remap=true)
    public void correctPostRotationTranslationForSizeMult(CallbackInfo ci, @Local(name={"halfWView"}) float halfWView, @Local(name={"shaderMatrixStack"}) class_4587 shaderMatrixStack) {
        float sizeMultTranslation = halfWView / (float)Globals.minimapSizeMultiplier * (float)(Globals.minimapSizeMultiplier - 1);
        shaderMatrixStack.method_22904((double)sizeMultTranslation, (double)sizeMultTranslation, 0.0);
    }

    @Redirect(method={"renderChunksToFBO"}, at=@At(value="INVOKE", target="Lxaero/common/minimap/render/MinimapRendererHelper;drawMyTexturedModalRect(Lcom/mojang/blaze3d/vertex/PoseStack;FFIIFFFF)V"), remap=true)
    public void redirectModelViewDraw(MinimapRendererHelper instance, class_4587 matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, @Share(value="scaledSize") LocalIntRef scaledSize) {
        float scaledSizeM = (float)Globals.minimapScaleMultiplier * 512.0f;
        this.helper.drawMyTexturedModalRect(matrixStack, (float)(-scaledSize.get()), (float)(-scaledSize.get()), 0, 0, scaledSizeM, scaledSizeM, scaledSizeM, scaledSizeM);
    }

    @WrapOperation(method={"renderChunksToFBO"}, at={@At(value="INVOKE", target="Lxaero/common/mods/SupportXaeroWorldmap;drawMinimap(Lxaero/hud/minimap/module/MinimapSession;Lcom/mojang/blaze3d/vertex/PoseStack;Lxaero/common/minimap/render/MinimapRendererHelper;IIIIIIZDDLcom/mojang/blaze3d/vertex/VertexConsumer;Lxaero/common/graphics/renderer/multitexture/MultiTextureRenderTypeRendererProvider;)V")}, remap=true)
    public void drawMinimapFeatures(SupportXaeroWorldmap instance, MinimapSession minimapSession, class_4587 matrixStack, MinimapRendererHelper helper, int xFloored, int zFloored, int minViewX, int minViewZ, int maxViewX, int maxViewZ, boolean zooming, double zoom, double mapDimensionScale, class_4588 overlayBufferBuilder, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers, Operation<Void> original, @Local(name={"renderTypeBuffers"}) class_4597.class_4598 renderTypeBuffers) {
        original.call(new Object[]{instance, minimapSession, matrixStack, helper, xFloored, zFloored, minViewX, minViewZ, maxViewX, maxViewZ, zooming, zoom, mapDimensionScale, overlayBufferBuilder, multiTextureRenderTypeRenderers});
        int mapX = xFloored >> 4;
        int mapZ = zFloored >> 4;
        int chunkX = mapX >> 2;
        int chunkZ = mapZ >> 2;
        int tileX = mapX & 3;
        int tileZ = mapZ & 3;
        int insideX = xFloored & 0xF;
        int insideZ = zFloored & 0xF;
        MinimapShaders.FRAMEBUFFER_LINES.setFrameSize((float)this.scalingFramebuffer.field_1480, (float)this.scalingFramebuffer.field_1477);
        Globals.drawManager.drawMinimapFeatures(chunkX, chunkZ, tileX, tileZ, insideX, insideZ, matrixStack, renderTypeBuffers);
    }

    @WrapOperation(method={"renderChunksToFBO"}, at={@At(value="INVOKE", target="Lxaero/common/graphics/renderer/multitexture/MultiTextureRenderTypeRendererProvider;draw(Lxaero/common/graphics/renderer/multitexture/MultiTextureRenderTypeRenderer;)V")})
    public void drawMinimapFeaturesCaveMode(MultiTextureRenderTypeRendererProvider instance, MultiTextureRenderTypeRenderer renderer, Operation<Void> original, @Local(name={"xFloored"}) int xFloored, @Local(name={"zFloored"}) int zFloored, @Local(name={"matrixStack"}) class_4587 matrixStack, @Local(name={"renderTypeBuffers"}) class_4597.class_4598 renderTypeBuffers) {
        original.call(new Object[]{instance, renderer});
        MinimapShaders.FRAMEBUFFER_LINES.setFrameSize((float)this.scalingFramebuffer.field_1480, (float)this.scalingFramebuffer.field_1477);
        int mapX = xFloored >> 4;
        int mapZ = zFloored >> 4;
        int chunkX = mapX >> 2;
        int chunkZ = mapZ >> 2;
        int tileX = mapX & 3;
        int tileZ = mapZ & 3;
        int insideX = xFloored & 0xF;
        int insideZ = zFloored & 0xF;
        Globals.drawManager.drawMinimapFeatures(chunkX, chunkZ, tileX, tileZ, insideX, insideZ, matrixStack, renderTypeBuffers);
    }
}

