/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.line;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import xaero.common.graphics.shader.FramebufferLinesShaderHelper;
import xaero.map.gui.GuiMap;
import xaeroplus.Globals;
import xaeroplus.feature.render.DrawContext;
import xaeroplus.feature.render.DrawFeature;
import xaeroplus.module.impl.TickTaskExecutor;
import xaeroplus.shadow.caffeine.cache.AsyncLoadingCache;
import xaeroplus.shadow.caffeine.cache.Caffeine;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.GuiMapHelper;

public abstract class AbstractLineDrawFeature<T>
implements DrawFeature {
    public final AsyncLoadingCache<Long, T> lineRenderCache;

    protected AbstractLineDrawFeature(int refreshIntervalMs) {
        this.lineRenderCache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).refreshAfterWrite(refreshIntervalMs, TimeUnit.MILLISECONDS).executor(TickTaskExecutor.INSTANCE).buildAsync(k -> this.loadLinesInWindow());
    }

    @Override
    public void invalidateCache() {
        this.lineRenderCache.synchronous().invalidateAll();
    }

    public abstract float lineWidth();

    public T loadLinesInWindow() {
        int windowSize;
        int windowZ;
        int windowX;
        Optional<GuiMap> guiMapOptional = GuiMapHelper.getGuiMap();
        if (guiMapOptional.isPresent()) {
            GuiMap guiMap = guiMapOptional.get();
            windowX = GuiMapHelper.getGuiMapCenterRegionX(guiMap);
            windowZ = GuiMapHelper.getGuiMapCenterRegionZ(guiMap);
            windowSize = GuiMapHelper.getGuiMapRegionSize(guiMap);
        } else {
            windowX = ChunkUtils.getPlayerRegionX();
            windowZ = ChunkUtils.getPlayerRegionZ();
            windowSize = Math.max(3, Globals.minimapScaleMultiplier);
        }
        return this.preProcessLines(this.provideLinesInWindow(windowX, windowZ, windowSize, Globals.getCurrentDimensionId()), windowX, windowZ, windowSize);
    }

    public abstract T provideLinesInWindow(int var1, int var2, int var3, ResourceKey<Level> var4);

    public abstract T preProcessLines(T var1, int var2, int var3, int var4);

    public abstract T emptyLines();

    public T getLines() {
        return this.lineRenderCache.get(0L).getNow(this.emptyLines());
    }

    public void preRender(DrawContext ctx) {
        Minecraft mc = Minecraft.getInstance();
        if (ctx.worldmap()) {
            FramebufferLinesShaderHelper.setFrameSize((float)mc.getWindow().getWidth(), (float)mc.getWindow().getHeight());
        }
        float lineWidthScale = 16.0f * (float)Mth.clamp((double)((double)this.lineWidth() * ctx.fboScale()), (double)(0.1f * (ctx.worldmap() ? 1.0f : (float)Globals.minimapScaleMultiplier)), (double)1000.0);
        RenderSystem.lineWidth((float)lineWidthScale);
    }

    @Override
    public void close() {
        this.lineRenderCache.synchronous().invalidateAll();
    }
}

