/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.settings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.List;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaeroplus.XaeroPlus;
import xaeroplus.settings.BooleanSetting;
import xaeroplus.settings.DoubleSetting;
import xaeroplus.settings.EnumSetting;
import xaeroplus.settings.Settings;
import xaeroplus.settings.TranslatableSettingEnum;
import xaeroplus.settings.XaeroPlusSetting;
import xaeroplus.util.FileUtil;

public class SettingHooks {
    public static void saveSettings() {
        try {
            SettingHooks.saveXPSettings();
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed saving settings", (Throwable)e);
        }
    }

    public static synchronized void saveXPSettings() throws IOException {
        FileUtil.safeSave(XaeroPlus.configFile, w -> {
            try (PrintWriter writer = new PrintWriter((Writer)w);){
                List<XaeroPlusSetting> allSettings = Settings.REGISTRY.getAllSettings().stream().sorted(Comparator.comparing(XaeroPlusSetting::getSettingName)).toList();
                for (int i = 0; i < allSettings.size(); ++i) {
                    XaeroPlusSetting setting = allSettings.get(i);
                    writer.println(setting.getSettingName() + ":" + setting.getSerializedValue());
                }
            }
        });
    }

    public static synchronized void loadXPSettings() {
        try {
            if (!XaeroPlus.configFile.exists()) {
                return;
            }
            SettingHooks.loadXPSettingsFromFile(XaeroPlus.configFile);
        }
        catch (Throwable e) {
            XaeroPlus.LOGGER.error("Error loading XaeroPlus settings", e);
        }
    }

    public static synchronized void loadXPSettingsFromFile(File file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String s;
            while ((s = reader.readLine()) != null) {
                String settingName;
                int colonIndex = s.indexOf(58);
                if (colonIndex == -1 || (settingName = s.substring(0, colonIndex)).isBlank()) continue;
                String settingValue = s.substring(colonIndex + 1);
                XaeroPlusSetting setting = Settings.REGISTRY.getSettingByName(settingName);
                if (setting == null) {
                    XaeroPlus.LOGGER.warn("Setting not found: {}", (Object)settingName);
                    continue;
                }
                setting.deserializeValue(settingValue);
            }
        }
    }

    public static void getClientBooleanValue(String enumString, CallbackInfoReturnable<Boolean> cir) {
        XaeroPlusSetting setting = Settings.REGISTRY.getSettingByName(enumString);
        if (setting instanceof BooleanSetting) {
            BooleanSetting booleanSetting = (BooleanSetting)setting;
            cir.setReturnValue((Object)booleanSetting.get());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setOptionValue(String enumString, Object value) {
        XaeroPlusSetting setting = Settings.REGISTRY.getSettingByName(enumString);
        if (setting instanceof BooleanSetting) {
            BooleanSetting booleanSetting = (BooleanSetting)setting;
            if (value instanceof Boolean) {
                booleanSetting.setValue((Boolean)value);
                return;
            }
        }
        if (!(setting instanceof EnumSetting)) return;
        EnumSetting enumSetting = (EnumSetting)setting;
        if (!(value instanceof Integer)) return;
        enumSetting.setValueIndex((Integer)value);
    }

    public static void getOptionValue(String enumString, CallbackInfoReturnable<Object> cir) {
        XaeroPlusSetting setting = Settings.REGISTRY.getSettingByName(enumString);
        if (setting instanceof BooleanSetting) {
            BooleanSetting booleanSetting = (BooleanSetting)setting;
            cir.setReturnValue((Object)booleanSetting.get());
        } else if (setting instanceof EnumSetting) {
            EnumSetting enumSetting = (EnumSetting)setting;
            cir.setReturnValue((Object)enumSetting.getValueIndex());
        }
    }

    public static void setOptionDoubleValue(String enumString, double f) {
        XaeroPlusSetting setting = Settings.REGISTRY.getSettingByName(enumString);
        if (setting instanceof DoubleSetting) {
            DoubleSetting doubleSetting = (DoubleSetting)setting;
            doubleSetting.setValue(f);
        }
    }

    public static void getOptionDoubleValue(String enumString, CallbackInfoReturnable<Double> cir) {
        XaeroPlusSetting setting = Settings.REGISTRY.getSettingByName(enumString);
        if (setting instanceof DoubleSetting) {
            DoubleSetting doubleSetting = (DoubleSetting)setting;
            cir.setReturnValue((Object)doubleSetting.get());
        }
    }

    public static void getOptionValueName(String enumString, CallbackInfoReturnable<String> cir) {
        XaeroPlusSetting setting = Settings.REGISTRY.getSettingByName(enumString);
        if (setting instanceof EnumSetting) {
            EnumSetting enumSetting = (EnumSetting)setting;
            cir.setReturnValue((Object)(enumSetting.get() instanceof TranslatableSettingEnum ? ((TranslatableSettingEnum)enumSetting.get()).getTranslatedName() : ((Enum)enumSetting.get()).toString()));
        }
    }

    public static void getSliderOptionText(String enumString, CallbackInfoReturnable<String> cir) {
        XaeroPlusSetting setting = Settings.REGISTRY.getSettingByName(enumString);
        if (setting == null) {
            return;
        }
        String prefix = setting.getTranslatedName() + ": ";
        if (setting instanceof DoubleSetting) {
            DoubleSetting doubleSetting = (DoubleSetting)setting;
            cir.setReturnValue((Object)(prefix + String.format("%.2f", doubleSetting.get())));
        } else if (setting instanceof EnumSetting) {
            EnumSetting enumSetting = (EnumSetting)setting;
            cir.setReturnValue((Object)(prefix + (enumSetting.get() instanceof TranslatableSettingEnum ? ((TranslatableSettingEnum)enumSetting.get()).getTranslatedName() : ((Enum)enumSetting.get()).toString())));
        }
    }
}

