/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.animation.SlowingAnimation;
import xaero.map.element.HoveredMapElementHolder;
import xaero.map.element.MapElementRenderHandler;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.gui.IRightClickableElement;
import xaero.map.gui.MapTileSelection;
import xaero.map.gui.ScreenBase;
import xaero.map.gui.dropdown.rightclick.RightClickOption;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.world.MapDimension;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.feature.drawing.DrawingColorCyclerButton;
import xaeroplus.feature.render.line.Line;
import xaeroplus.feature.render.text.Text;
import xaeroplus.mixin.client.AccessorRightClickOption;
import xaeroplus.module.ModuleManager;
import xaeroplus.module.impl.Breadcrumbs;
import xaeroplus.module.impl.Drawing;
import xaeroplus.module.impl.LavaColumns;
import xaeroplus.module.impl.LiquidNewChunks;
import xaeroplus.module.impl.OldBiomes;
import xaeroplus.module.impl.OldChunks;
import xaeroplus.module.impl.PaletteNewChunks;
import xaeroplus.module.impl.Portals;
import xaeroplus.settings.Settings;
import xaeroplus.util.BaritoneExecutor;
import xaeroplus.util.BaritoneHelper;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;
import xaeroplus.util.DrawingMode;

@Mixin(value={GuiMap.class}, remap=false)
public abstract class MixinGuiMap
extends ScreenBase
implements IRightClickableElement {
    @Unique
    private static boolean follow = false;
    @Unique
    boolean pan;
    @Unique
    double panMouseStartX;
    @Unique
    double panMouseStartY;
    @Unique
    Button coordinateGotoButton;
    @Unique
    EditBox xTextEntryField;
    @Unique
    EditBox zTextEntryField;
    @Unique
    Button followButton;
    @Unique
    Button switchToNetherButton;
    @Unique
    Button switchToOverworldButton;
    @Unique
    Button switchToEndButton;
    @Unique
    Button startDrawingButton;
    @Unique
    Button drawLineSegmentButton;
    @Unique
    Button drawInfiniteLineButton;
    @Unique
    Button drawHighlightsButton;
    @Unique
    Button drawTextButton;
    @Unique
    Button drawColorCyclerButton;
    @Unique
    Button drawMeasurementToolButton;
    @Unique
    Button exitButton;
    @Unique
    boolean drawing = false;
    @Unique
    BlockPos drawInProgressPos = null;
    @Unique
    boolean drawingLeftClickDown = false;
    @Unique
    boolean drawingRightClickDown = false;
    @Unique
    boolean drawTextEntryActive = false;
    @Unique
    DrawingMode drawingMode = DrawingMode.LINE_SEGMENT;
    @Unique
    EditBox drawTextEntryField;
    @Unique
    List<Button> guiMapButtonTempList = new ArrayList<Button>();
    @Shadow
    private double cameraX = 0.0;
    @Shadow
    private double cameraZ = 0.0;
    @Shadow
    private int[] cameraDestination = null;
    @Shadow
    private SlowingAnimation cameraDestinationAnimX = null;
    @Shadow
    private SlowingAnimation cameraDestinationAnimZ = null;
    @Shadow
    private double prevPlayerDimDiv;
    @Shadow
    private MapProcessor mapProcessor;
    @Shadow
    private Button exportButton;
    @Shadow
    private Button claimsButton;
    @Shadow
    private Button zoomInButton;
    @Shadow
    private Button zoomOutButton;
    @Shadow
    private Button keybindingsButton;
    @Shadow
    private Button dimensionToggleButton;
    @Shadow
    private int rightClickX;
    @Shadow
    private int rightClickY;
    @Shadow
    private int rightClickZ;
    @Shadow
    private int mouseBlockPosX;
    @Shadow
    private int mouseBlockPosZ;
    @Shadow
    private static double destScale;
    @Shadow
    private MapTileSelection mapTileSelection;
    @Shadow
    private double scale;

    protected MixinGuiMap(Screen parent, Screen escape, Component titleIn) {
        super(parent, escape, titleIn);
    }

    @Shadow
    public abstract <T extends GuiEventListener & Renderable> T addButton(T var1);

    @Shadow
    public abstract <T extends GuiEventListener & NarratableEntry> T m_7787_(T var1);

    @ModifyExpressionValue(method={"changeZoom"}, at={@At(value="CONSTANT", args={"doubleValue=0.0625"})})
    public double customMinZoom(double original) {
        return Settings.REGISTRY.worldMapMinZoomSetting.get() / 10.0;
    }

    @Unique
    private Component xaeroPlus$prefix(Component component) {
        return Component.m_237113_((String)"[XP] ").m_7220_(component);
    }

    @Unique
    private Component xaeroPlus$keybindPrefix(Component component, KeyMapping bind) {
        return Component.m_237119_().m_7220_((Component)Component.m_237113_((String)(Misc.getKeyName((KeyMapping)bind) + " ")).m_130940_(ChatFormatting.DARK_GREEN)).m_7220_(component);
    }

    @Inject(method={"init"}, at={@At(value="RETURN")}, remap=true)
    public void customInitGui(CallbackInfo ci) {
        this.followButton = new GuiTexturedButton(0, this.dimensionToggleButton.m_252907_() - 20, 20, 20, follow ? 61 : 42, 19, 16, 16, Globals.guiTextures, this::onFollowButton, () -> new CursorBox(this.xaeroPlus$prefix((Component)Component.m_237115_((String)"xaeroplus.gui.world_map.toggle_follow_mode").m_130946_(" " + I18n.m_118938_((String)(follow ? "xaeroplus.gui.off" : "xaeroplus.gui.on"), (Object[])new Object[0])))));
        this.coordinateGotoButton = new GuiTexturedButton(0, this.followButton.m_252907_() - 20, 20, 20, 23, 19, 16, 16, Globals.guiTextures, this::onGotoCoordinatesButton, () -> new CursorBox(this.xaeroPlus$prefix((Component)Component.m_237115_((String)"xaeroplus.gui.world_map.go_to_coordinates"))));
        this.xTextEntryField = new EditBox(Minecraft.m_91087_().f_91062_, 20, this.coordinateGotoButton.m_252907_() - 10, 75, 20, Component.m_130674_((String)"X:"));
        this.xTextEntryField.m_94194_(false);
        this.xTextEntryField.m_94196_(0);
        this.xTextEntryField.m_257771_((Component)Component.m_237113_((String)"X:").m_130940_(ChatFormatting.DARK_GRAY));
        this.zTextEntryField = new EditBox(Minecraft.m_91087_().f_91062_, 20, this.xTextEntryField.m_252907_() + 20, 75, 20, Component.m_130674_((String)"Z:"));
        this.zTextEntryField.m_94194_(false);
        this.zTextEntryField.m_94196_(0);
        this.zTextEntryField.m_257771_((Component)Component.m_237113_((String)"Z:").m_130940_(ChatFormatting.DARK_GRAY));
        this.startDrawingButton = new GuiTexturedButton(0, this.coordinateGotoButton.m_252907_() - 20, 20, 20, 47, 0, 16, 16, Globals.guiTextures, button -> this.onToggleDrawingButton(), () -> new CursorBox(this.xaeroPlus$keybindPrefix(this.xaeroPlus$prefix((Component)Component.m_237115_((String)"xaeroplus.gui.world_map.start_drawing")), Settings.REGISTRY.worldMapToggleDrawingKeybindSetting.getKeyBinding())));
        this.drawLineSegmentButton = new GuiTexturedButton(this.startDrawingButton.m_252754_() + 16, this.startDrawingButton.m_252907_(), 20, 20, 65, 0, 16, 16, Globals.guiTextures, button -> this.setDrawingMode(DrawingMode.LINE_SEGMENT), () -> new CursorBox(this.xaeroPlus$prefix((Component)Component.m_237115_((String)"xaeroplus.gui.world_map.draw_line_segment"))));
        this.drawLineSegmentButton.f_93624_ = false;
        this.drawInfiniteLineButton = new GuiTexturedButton(this.startDrawingButton.m_252754_() + 16, this.drawLineSegmentButton.m_252907_() + 20, 20, 20, 101, 0, 16, 16, Globals.guiTextures, button -> this.setDrawingMode(DrawingMode.INFINITE_LINE), () -> new CursorBox(this.xaeroPlus$prefix((Component)Component.m_237115_((String)"xaeroplus.gui.world_map.draw_infinite_line"))));
        this.drawInfiniteLineButton.f_93624_ = false;
        this.drawHighlightsButton = new GuiTexturedButton(this.startDrawingButton.m_252754_() + 16, this.drawInfiniteLineButton.m_252907_() + 20, 20, 20, 82, 0, 16, 16, Globals.guiTextures, button -> this.setDrawingMode(DrawingMode.HIGHLIGHT), () -> new CursorBox(this.xaeroPlus$prefix((Component)Component.m_237115_((String)"xaeroplus.gui.world_map.draw_highlights"))));
        this.drawHighlightsButton.f_93624_ = false;
        this.drawTextButton = new GuiTexturedButton(this.startDrawingButton.m_252754_() + 16, this.drawHighlightsButton.m_252907_() + 20, 20, 20, 118, 0, 16, 16, Globals.guiTextures, button -> this.setDrawingMode(DrawingMode.TEXT), () -> new CursorBox(this.xaeroPlus$prefix((Component)Component.m_237115_((String)"xaeroplus.gui.world_map.draw_text"))));
        this.drawTextButton.f_93624_ = false;
        this.drawColorCyclerButton = new DrawingColorCyclerButton(this.startDrawingButton.m_252754_() + 16, this.drawTextButton.m_252907_() + 20, () -> new CursorBox(this.xaeroPlus$prefix((Component)Component.m_237115_((String)"xaeroplus.gui.world_map.draw_color"))), ModuleManager.getModule(Drawing.class).getDrawingColorCycler());
        this.drawColorCyclerButton.f_93624_ = false;
        this.drawMeasurementToolButton = new GuiTexturedButton(this.startDrawingButton.m_252754_() + 16, this.drawColorCyclerButton.m_252907_() + 20, 20, 20, 135, 0, 16, 16, Globals.guiTextures, button -> this.setDrawingMode(DrawingMode.MEASUREMENT), () -> new CursorBox(this.xaeroPlus$prefix((Component)Component.m_237115_((String)"xaeroplus.gui.world_map.draw_measurement_tool"))));
        this.drawMeasurementToolButton.f_93624_ = false;
        this.drawTextEntryField = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 150, 20, Component.m_130674_((String)"Text:"));
        this.drawTextEntryField.m_94194_(false);
        this.drawTextEntryField.m_94196_(0);
        this.drawTextEntryField.m_257771_((Component)Component.m_237113_((String)"Text:").m_130940_(ChatFormatting.DARK_GRAY));
        this.switchToEndButton = new GuiTexturedButton(this.f_96543_ - 20, this.zoomInButton.m_252907_() - 20, 20, 20, 117, 19, 16, 16, Globals.guiTextures, button -> this.onSwitchDimensionButton((ResourceKey<Level>)Level.f_46430_), () -> new CursorBox(this.xaeroPlus$keybindPrefix(this.xaeroPlus$prefix((Component)Component.m_237115_((String)"xaeroplus.keybind.switch_to_end")), Settings.REGISTRY.switchToEndSetting.getKeyBinding())));
        this.switchToOverworldButton = new GuiTexturedButton(this.f_96543_ - 20, this.switchToEndButton.m_252907_() - 20, 20, 20, 98, 18, 16, 16, Globals.guiTextures, button -> this.onSwitchDimensionButton((ResourceKey<Level>)Level.f_46428_), () -> new CursorBox(this.xaeroPlus$keybindPrefix(this.xaeroPlus$prefix((Component)Component.m_237115_((String)"xaeroplus.keybind.switch_to_overworld")), Settings.REGISTRY.switchToOverworldSetting.getKeyBinding())));
        this.switchToNetherButton = new GuiTexturedButton(this.f_96543_ - 20, this.switchToOverworldButton.m_252907_() - 20, 20, 20, 79, 19, 16, 16, Globals.guiTextures, button -> this.onSwitchDimensionButton((ResourceKey<Level>)Level.f_46429_), () -> new CursorBox(this.xaeroPlus$keybindPrefix(this.xaeroPlus$prefix((Component)Component.m_237115_((String)"xaeroplus.keybind.switch_to_nether")), Settings.REGISTRY.switchToNetherSetting.getKeyBinding())));
        this.exitButton = new GuiTexturedButton(this.f_96543_ - 34, 2, 32, 32, 0, 0, 0, 0, Globals.guiTextures, button -> this.m_7379_(), () -> new CursorBox(this.xaeroPlus$prefix((Component)Component.m_237115_((String)"xaeroplus.gui.world_map.exit"))));
        this.pan = false;
        this.drawing = false;
        if (!Settings.REGISTRY.worldMapUIAdditions.get()) {
            return;
        }
        if (!SupportMods.pac()) {
            this.m_169411_((GuiEventListener)this.claimsButton);
            this.exportButton.m_253211_(this.claimsButton.m_252907_());
            this.keybindingsButton.m_253211_(this.claimsButton.m_252907_() - 20);
            this.zoomOutButton.m_253211_(this.keybindingsButton.m_252907_() - 20);
            this.zoomInButton.m_253211_(this.zoomOutButton.m_252907_() - 20);
            this.switchToEndButton.m_253211_(this.zoomInButton.m_252907_() - 20);
            this.switchToOverworldButton.m_253211_(this.switchToEndButton.m_252907_() - 20);
            this.switchToNetherButton.m_253211_(this.switchToOverworldButton.m_252907_() - 20);
        }
        this.addButton(this.followButton);
        this.addButton(this.coordinateGotoButton);
        this.m_7787_(this.xTextEntryField);
        this.m_7787_(this.zTextEntryField);
        this.addButton(this.startDrawingButton);
        this.addButton(this.switchToEndButton);
        this.addButton(this.switchToOverworldButton);
        this.addButton(this.switchToNetherButton);
        this.addButton(this.exitButton);
    }

    @Unique
    private void setDrawingMode(DrawingMode drawingMode) {
        this.drawInProgressPos = null;
        ModuleManager.getModule(Drawing.class).removeInProgressLine();
        this.drawingLeftClickDown = false;
        this.drawingRightClickDown = false;
        this.drawTextEntryActive = false;
        this.drawingMode = drawingMode;
    }

    @Unique
    private void onToggleDrawingButton() {
        boolean prevDrawing = this.drawing;
        this.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
        boolean bl = this.drawing = !prevDrawing;
        if (this.drawing) {
            this.addButton(this.drawLineSegmentButton);
            this.addButton(this.drawInfiniteLineButton);
            this.addButton(this.drawHighlightsButton);
            this.addButton(this.drawTextButton);
            this.addButton(this.drawColorCyclerButton);
            this.addButton(this.drawMeasurementToolButton);
            this.drawLineSegmentButton.f_93624_ = true;
            this.drawInfiniteLineButton.f_93624_ = true;
            this.drawHighlightsButton.f_93624_ = true;
            this.drawTextButton.f_93624_ = true;
            this.drawColorCyclerButton.f_93624_ = true;
            this.drawMeasurementToolButton.f_93624_ = true;
        } else {
            this.xaeroPlus$stopDrawing();
        }
    }

    protected void onExit(Screen screen) {
        if (!Settings.REGISTRY.persistMapDimensionSwitchSetting.get()) {
            try {
                ResourceKey<Level> actualDimension = ChunkUtils.getActualDimension();
                if (Globals.getCurrentDimensionId() != actualDimension) {
                    Globals.switchToDimension(actualDimension);
                    if (!Settings.REGISTRY.radarWhileDimensionSwitchedSetting.get()) {
                        WorldMap.settings.minimapRadar = true;
                    }
                }
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.error("Failed to switch back to original dimension", (Throwable)e);
            }
        }
        super.onExit(screen);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lxaero/map/gui/GuiMap;init(Lnet/minecraft/client/Minecraft;II)V", ordinal=0, shift=At.Shift.AFTER)}, remap=true)
    public void toggleRadarWhileDimensionSwitched(CallbackInfo ci, @Local(name={"currentFutureDim"}) MapDimension currentFutureDim) {
        if (!Settings.REGISTRY.radarWhileDimensionSwitchedSetting.get()) {
            WorldMap.settings.minimapRadar = currentFutureDim.getDimId() == ChunkUtils.getActualDimension();
        }
    }

    @Redirect(method={"render"}, at=@At(value="FIELD", target="Lxaero/map/gui/GuiMap;cameraX:D", opcode=181, ordinal=1), remap=true)
    public void fixDimensionSwitchCameraCoordsX(GuiMap owner, double value, @Local(name={"playerDimDiv"}) double playerDimDiv) {
        this.cameraX *= this.prevPlayerDimDiv / playerDimDiv;
    }

    @Redirect(method={"render"}, at=@At(value="FIELD", target="Lxaero/map/gui/GuiMap;cameraZ:D", opcode=181, ordinal=1), remap=true)
    public void fixDimensionSwitchCameraCoordsZ(GuiMap owner, double value, @Local(name={"playerDimDiv"}) double playerDimDiv) {
        this.cameraZ *= this.prevPlayerDimDiv / playerDimDiv;
    }

    @Inject(method={"render"}, at={@At(value="FIELD", target="Lxaero/map/gui/GuiMap;lastStartTime:J", opcode=181, ordinal=0, shift=At.Shift.AFTER)}, remap=true)
    public void injectFollowMode(CallbackInfo ci) {
        if (follow && Objects.isNull(this.cameraDestination) && Objects.isNull(this.cameraDestinationAnimX) && Objects.isNull(this.cameraDestinationAnimZ)) {
            this.cameraDestination = new int[]{(int)ChunkUtils.getPlayerX(), (int)ChunkUtils.getPlayerZ()};
        }
    }

    @ModifyExpressionValue(method={"render"}, at={@At(value="FIELD", target="Lxaero/map/settings/ModSettings;debug:Z", opcode=180)}, remap=true)
    public boolean hideDebugRenderingOnF1(boolean original) {
        return original && !Minecraft.m_91087_().f_91066_.f_92062_;
    }

    @WrapOperation(method={"render"}, slice={@Slice(from=@At(value="FIELD", target="Lxaero/map/gui/GuiMap;prevLoadingLeaves:Z", opcode=181), to=@At(value="INVOKE", target="Lxaero/map/graphics/ImprovedFramebuffer;bindDefaultFramebuffer(Lnet/minecraft/client/Minecraft;)V"))}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;endBatch()V", ordinal=0)}, remap=true)
    public void drawWorldMapFeatures(MultiBufferSource.BufferSource instance, Operation<Void> original, @Local(name={"flooredCameraX"}) int flooredCameraX, @Local(name={"flooredCameraZ"}) int flooredCameraZ, @Local(name={"matrixStack"}) PoseStack matrixStack, @Local(name={"renderTypeBuffers"}) MultiBufferSource.BufferSource renderTypeBuffers, @Local(name={"fboScale"}) double fboScale) {
        original.call(new Object[]{instance});
        if (Minecraft.m_91087_().f_91066_.f_92062_) {
            return;
        }
        Globals.drawManager.drawWorldMapFeatures(flooredCameraX, flooredCameraZ, matrixStack, fboScale, renderTypeBuffers);
    }

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lxaero/map/graphics/MapRenderHelper;renderDynamicHighlight(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;IIIIIIFFFFFFFF)V")}, remap=true)
    public boolean hideHighlightsOnF1(PoseStack matrixStack, VertexConsumer overlayBuffer, int flooredCameraX, int flooredCameraZ, int leftX, int rightX, int topZ, int bottomZ, float sideR, float sideG, float sideB, float sideA, float centerR, float centerG, float centerB, float centerA) {
        return !Minecraft.m_91087_().f_91066_.f_92062_;
    }

    @WrapOperation(method={"render"}, at={@At(value="INVOKE", target="Lxaero/map/element/MapElementRenderHandler;render(Lxaero/map/gui/GuiMap;Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;Lxaero/map/graphics/renderer/multitexture/MultiTextureRenderTypeRendererProvider;DDIIDDDDDFZLxaero/map/element/HoveredMapElementHolder;Lnet/minecraft/client/Minecraft;F)Lxaero/map/element/HoveredMapElementHolder;")}, remap=true)
    public HoveredMapElementHolder<?, ?> hideMapElementsOnF1(MapElementRenderHandler handler, GuiMap mapScreen, GuiGraphics guiGraphics, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, double cameraX, double cameraZ, int width, int height, double screenSizeBasedScale, double scale, double playerDimDiv, double mouseX, double mouseZ, float brightness, boolean cave, HoveredMapElementHolder<?, ?> oldHovered, Minecraft mc, float partialTicks, Operation<HoveredMapElementHolder<?, ?>> original) {
        if (!Minecraft.m_91087_().f_91066_.f_92062_) {
            return (HoveredMapElementHolder)original.call(new Object[]{handler, mapScreen, guiGraphics, renderTypeBuffers, rendererProvider, cameraX, cameraZ, width, height, screenSizeBasedScale, scale, playerDimDiv, mouseX, mouseZ, Float.valueOf(brightness), cave, oldHovered, mc, Float.valueOf(partialTicks)});
        }
        return null;
    }

    @ModifyExpressionValue(method={"render"}, at={@At(value="FIELD", target="Lxaero/map/settings/ModSettings;footsteps:Z", opcode=180)}, remap=true)
    public boolean hideFootstepsOnF1(boolean original) {
        return original && !Minecraft.m_91087_().f_91066_.f_92062_;
    }

    @ModifyExpressionValue(method={"render"}, at={@At(value="FIELD", target="Lxaero/map/settings/ModSettings;renderArrow:Z", opcode=180)}, remap=true)
    public boolean hideArrowOnF1(boolean original) {
        return original && !Minecraft.m_91087_().f_91066_.f_92062_;
    }

    @ModifyArg(method={"render"}, slice=@Slice(from=@At(value="FIELD", opcode=180, target="Lxaero/map/settings/ModSettings;coordinates:Z")), at=@At(value="INVOKE", target="Lxaero/map/graphics/MapRenderHelper;drawCenteredStringWithBackground(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIFFFFLcom/mojang/blaze3d/vertex/VertexConsumer;)V", ordinal=0), index=2)
    public String renderCrossDimensionCursorCoordinates(String original) {
        if (!Settings.REGISTRY.crossDimensionCursorCoordinates.get()) {
            return original;
        }
        ResourceKey<Level> dim = Globals.getCurrentDimensionId();
        if (dim != Level.f_46428_ && dim != Level.f_46429_) {
            return original;
        }
        double dimDiv = dim == Level.f_46429_ ? 0.125 : 8.0;
        int x = (int)((double)this.mouseBlockPosX / dimDiv);
        int z = (int)((double)this.mouseBlockPosZ / dimDiv);
        return original + " [" + x + ", " + z + "]";
    }

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lxaero/map/graphics/MapRenderHelper;drawCenteredStringWithBackground(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIFFFFLcom/mojang/blaze3d/vertex/VertexConsumer;)V")}, remap=true)
    public boolean hideRenderedStringsOnF1(GuiGraphics guiGraphics, Font font, String string, int x, int y, int color, float bgRed, float bgGreen, float bgBlue, float bgAlpha, VertexConsumer backgroundVertexBuffer) {
        return !Minecraft.m_91087_().f_91066_.f_92062_;
    }

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Lnet/minecraft/resources/ResourceLocation;IIIIII)V")}, remap=true)
    public boolean hideCompassOnF1(GuiGraphics instance, ResourceLocation texture, int x, int y, int u, int v, int width, int height) {
        return !Minecraft.m_91087_().f_91066_.f_92062_;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lxaero/map/gui/ScreenBase;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V")}, remap=true)
    public void hideButtonsOnF1(CallbackInfo ci) {
        if (Minecraft.m_91087_().f_91066_.f_92062_) {
            List<Button> buttonList = this.getButtonList();
            if (!buttonList.isEmpty()) {
                this.guiMapButtonTempList.clear();
                this.guiMapButtonTempList.addAll(buttonList);
                this.xTextEntryField.m_94194_(false);
                this.zTextEntryField.m_94194_(false);
                this.clearButtons();
            }
        } else if (!this.guiMapButtonTempList.isEmpty()) {
            this.clearButtons();
            this.guiMapButtonTempList.forEach(this::addButton);
            this.guiMapButtonTempList.clear();
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lxaero/map/graphics/MapRenderHelper;restoreDefaultShaderBlendState()V")}, remap=true)
    public void renderCoordinatesGotoTextEntryFields(GuiGraphics guiGraphics, int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci) {
        if (!Settings.REGISTRY.worldMapUIAdditions.get()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null && mc.f_91080_.getClass().equals(GuiMap.class)) {
            if (this.xTextEntryField.m_94213_() && this.zTextEntryField.m_94213_()) {
                this.xTextEntryField.m_88315_(guiGraphics, scaledMouseX, scaledMouseY, partialTicks);
                this.zTextEntryField.m_88315_(guiGraphics, scaledMouseX, scaledMouseY, partialTicks);
            }
            if (this.drawing && this.drawTextEntryActive && this.drawingMode == DrawingMode.TEXT && this.drawTextEntryField.f_93624_) {
                this.drawTextEntryField.m_88315_(guiGraphics, scaledMouseX, scaledMouseY, partialTicks);
            }
        }
    }

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lxaero/map/graphics/MapRenderHelper;drawCenteredStringWithBackground(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;IIIFFFFLcom/mojang/blaze3d/vertex/VertexConsumer;)V")}, remap=true)
    public boolean hideMoreRenderedStringsOnF1(GuiGraphics guiGraphics, Font font, Component text, int x, int y, int color, float bgRed, float bgGreen, float bgBlue, float bgAlpha, VertexConsumer backgroundVertexBuffer) {
        return !Minecraft.m_91087_().f_91066_.f_92062_;
    }

    @Inject(method={"onDimensionToggleButton"}, at={@At(value="RETURN")})
    public void onDimensionToggleAfter(Button b, CallbackInfo ci) {
        if (!Settings.REGISTRY.radarWhileDimensionSwitchedSetting.get()) {
            WorldMap.settings.minimapRadar = this.mapProcessor.getMapWorld().getFutureDimensionId() == ChunkUtils.getActualDimension();
        }
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")}, remap=true)
    public void onTick(CallbackInfo ci) {
        if (!Settings.REGISTRY.worldMapUIAdditions.get()) {
            return;
        }
        if (!this.drawing) {
            return;
        }
        switch (this.drawingMode) {
            case LINE_SEGMENT: {
                this.startDrawingButton.m_93692_(false);
                this.drawLineSegmentButton.m_93692_(true);
                this.drawInfiniteLineButton.m_93692_(false);
                this.drawHighlightsButton.m_93692_(false);
                this.drawTextButton.m_93692_(false);
                this.drawColorCyclerButton.m_93692_(false);
                this.drawMeasurementToolButton.m_93692_(false);
                break;
            }
            case INFINITE_LINE: {
                this.startDrawingButton.m_93692_(false);
                this.drawLineSegmentButton.m_93692_(false);
                this.drawInfiniteLineButton.m_93692_(true);
                this.drawHighlightsButton.m_93692_(false);
                this.drawTextButton.m_93692_(false);
                this.drawColorCyclerButton.m_93692_(false);
                this.drawMeasurementToolButton.m_93692_(false);
                break;
            }
            case HIGHLIGHT: {
                this.startDrawingButton.m_93692_(false);
                this.drawLineSegmentButton.m_93692_(false);
                this.drawInfiniteLineButton.m_93692_(false);
                this.drawHighlightsButton.m_93692_(true);
                this.drawTextButton.m_93692_(false);
                this.drawColorCyclerButton.m_93692_(false);
                this.drawMeasurementToolButton.m_93692_(false);
                break;
            }
            case TEXT: {
                this.startDrawingButton.m_93692_(false);
                this.drawLineSegmentButton.m_93692_(false);
                this.drawInfiniteLineButton.m_93692_(false);
                this.drawHighlightsButton.m_93692_(false);
                this.drawTextButton.m_93692_(true);
                this.drawColorCyclerButton.m_93692_(false);
                this.drawMeasurementToolButton.m_93692_(false);
                if (!this.drawTextEntryActive) break;
                this.drawTextEntryField.m_94186_(true);
                this.drawTextEntryField.m_93692_(true);
                this.m_7522_((GuiEventListener)this.drawTextEntryField);
                break;
            }
            case MEASUREMENT: {
                this.startDrawingButton.m_93692_(false);
                this.drawLineSegmentButton.m_93692_(false);
                this.drawInfiniteLineButton.m_93692_(false);
                this.drawHighlightsButton.m_93692_(false);
                this.drawTextButton.m_93692_(false);
                this.drawColorCyclerButton.m_93692_(false);
                this.drawMeasurementToolButton.m_93692_(true);
            }
        }
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    public void updateInProgressLine(CallbackInfo ci) {
        if (this.drawing) {
            switch (this.drawingMode) {
                case LINE_SEGMENT: 
                case INFINITE_LINE: {
                    if (this.drawInProgressPos == null) {
                        ModuleManager.getModule(Drawing.class).removeInProgressLine();
                        break;
                    }
                    Line inProgress = ModuleManager.getModule(Drawing.class).snap(this.drawInProgressPos.m_123341_(), this.drawInProgressPos.m_123343_(), this.mouseBlockPosX, this.mouseBlockPosZ, destScale);
                    ModuleManager.getModule(Drawing.class).setInProgressLine(inProgress, this.drawingMode);
                    break;
                }
                case HIGHLIGHT: {
                    ModuleManager.getModule(Drawing.class).removeInProgressLine();
                    if (!this.drawingLeftClickDown) break;
                    ModuleManager.getModule(Drawing.class).addHighlight(ChunkUtils.posToChunkPos(this.mouseBlockPosX), ChunkUtils.posToChunkPos(this.mouseBlockPosZ));
                    break;
                }
                case MEASUREMENT: {
                    if (this.drawInProgressPos == null) {
                        ModuleManager.getModule(Drawing.class).removeInProgressLine();
                        break;
                    }
                    ModuleManager.getModule(Drawing.class).setInProgressLine(new Line(this.drawInProgressPos.m_123341_(), this.drawInProgressPos.m_123343_(), this.mouseBlockPosX, this.mouseBlockPosZ), this.drawingMode);
                }
            }
            if (this.drawingRightClickDown) {
                ModuleManager.getModule(Drawing.class).removeHighlight(ChunkUtils.posToChunkPos(this.mouseBlockPosX), ChunkUtils.posToChunkPos(this.mouseBlockPosZ));
                ModuleManager.getModule(Drawing.class).removeLine(this.mouseBlockPosX, this.mouseBlockPosZ);
                ModuleManager.getModule(Drawing.class).removeText(this.mouseBlockPosX, this.mouseBlockPosZ, this.getFboScale());
            }
        }
    }

    @Inject(method={"render"}, at={@At(value="FIELD", target="Lxaero/map/settings/ModSettings;coordinates:Z", opcode=180, ordinal=0)}, remap=true)
    public void renderMeasurementToolText(GuiGraphics guiGraphics, int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci, @Local(name={"backgroundVertexBuffer"}) VertexConsumer backgroundVertexBuffer) {
        if (!this.drawing) {
            return;
        }
        if (this.drawingMode != DrawingMode.MEASUREMENT) {
            return;
        }
        if (this.drawInProgressPos == null) {
            return;
        }
        Line line = ModuleManager.getModule(Drawing.class).getInProgressLine();
        if (line == null) {
            return;
        }
        int len = Mth.m_14107_((double)line.length());
        int dx = line.x2() - line.x1();
        int dz = line.z2() - line.z1();
        String string = len + " blocks [" + dx + " x " + dz + "]";
        Objects.requireNonNull(this.f_96547_);
        MapRenderHelper.drawCenteredStringWithBackground((GuiGraphics)guiGraphics, (Font)this.f_96547_, (String)string, (int)scaledMouseX, (int)(scaledMouseY - 9), (int)-1, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f, (VertexConsumer)backgroundVertexBuffer);
        String degreeStr = String.format("%.2f", line.angle());
        String string2 = degreeStr + "\u00b0";
        Objects.requireNonNull(this.f_96547_);
        MapRenderHelper.drawCenteredStringWithBackground((GuiGraphics)guiGraphics, (Font)this.f_96547_, (String)string2, (int)scaledMouseX, (int)(scaledMouseY + 9), (int)-1, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f, (VertexConsumer)backgroundVertexBuffer);
    }

    @Unique
    private float getFboScale() {
        float fboScale = this.scale >= 1.0 ? (float)Math.max(1.0, Math.floor(this.scale)) : (float)this.scale;
        return fboScale;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lxaero/map/mods/SupportXaeroMinimap;getSubWorldNameToRender()Ljava/lang/String;")})
    public void renderDrawingStatusText(CallbackInfo ci, @Local(argsOnly=true) GuiGraphics guiGraphics, @Local(name={"backgroundVertexBuffer"}) VertexConsumer backgroundVertexBuffer) {
        if (!this.drawing) {
            return;
        }
        MapRenderHelper.drawCenteredStringWithBackground((GuiGraphics)guiGraphics, (Font)Minecraft.m_91087_().f_91062_, (String)("[XP] " + I18n.m_118938_((String)"xaeroplus.gui.world_map.drawing_mode", (Object[])new Object[0])), (int)(this.f_96543_ / 2), (int)24, (int)-1, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f, (VertexConsumer)backgroundVertexBuffer);
        String[] lines = I18n.m_118938_((String)"xaeroplus.gui.world_map.drawing_mode_controls", (Object[])new Object[0]).split("\n");
        for (int i = 0; i < lines.length; ++i) {
            Font font = Minecraft.m_91087_().f_91062_;
            String string = lines[i].trim();
            int n = lines.length;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            int n2 = this.f_96544_ - 2 - n * (9 + 1);
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            MapRenderHelper.drawStringWithBackground((GuiGraphics)guiGraphics, (Font)font, (String)string, (int)40, (int)(n2 + i * (9 + 1)), (int)-1, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f, (VertexConsumer)backgroundVertexBuffer);
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    public void cancelClicksWhileDrawing(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (!this.drawing) {
            return;
        }
        boolean toReturn = super.m_6375_(mouseX, mouseY, button);
        if (toReturn) {
            cir.setReturnValue((Object)true);
            return;
        }
        if (button == 0) {
            this.drawingLeftClickDown = true;
            switch (this.drawingMode) {
                case LINE_SEGMENT: 
                case INFINITE_LINE: 
                case TEXT: 
                case MEASUREMENT: {
                    this.drawInProgressPos = new BlockPos(this.mouseBlockPosX, 0, this.mouseBlockPosZ);
                }
            }
            if (this.drawingMode == DrawingMode.TEXT) {
                if (this.drawTextEntryActive) {
                    if (this.drawTextEntryField.m_5953_(mouseX, mouseY)) {
                        return;
                    }
                    this.m_169411_((GuiEventListener)this.drawTextEntryField);
                }
                this.drawTextEntryActive = true;
                this.drawTextEntryField.m_252865_(Mth.m_14045_((int)((int)mouseX - this.drawTextEntryField.m_5711_() / 2), (int)5, (int)(this.f_96543_ - this.drawTextEntryField.m_5711_() - 5)));
                this.drawTextEntryField.m_253211_(Mth.m_14045_((int)((int)mouseY - this.drawTextEntryField.m_93694_() / 2), (int)5, (int)(this.f_96544_ - this.drawTextEntryField.m_93694_() - 5)));
                this.m_7787_(this.drawTextEntryField);
                this.drawTextEntryField.m_94194_(true);
                this.drawTextEntryField.m_94196_(0);
                this.drawTextEntryField.m_257771_((Component)Component.m_237113_((String)"Text:").m_130940_(ChatFormatting.DARK_GRAY));
                this.m_7522_((GuiEventListener)this.drawTextEntryField);
            }
            ModuleManager.getModule(Drawing.class).startOperation(Globals.getCurrentDimensionId(), false);
            cir.setReturnValue((Object)true);
        } else if (button == 1) {
            this.drawingRightClickDown = true;
            ModuleManager.getModule(Drawing.class).startOperation(Globals.getCurrentDimensionId(), true);
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"mouseReleased"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    public void drawingClickReleasedHandler(double par1, double par2, int par3, CallbackInfoReturnable<Boolean> cir) {
        if (!this.drawing) {
            return;
        }
        boolean toReturn = super.m_6348_(par1, par2, par3);
        if (toReturn) {
            cir.setReturnValue((Object)true);
            return;
        }
        if (par3 == 0) {
            switch (this.drawingMode) {
                case LINE_SEGMENT: 
                case INFINITE_LINE: {
                    if (this.drawInProgressPos == null) break;
                    Line line = ModuleManager.getModule(Drawing.class).snap(this.drawInProgressPos.m_123341_(), this.drawInProgressPos.m_123343_(), this.mouseBlockPosX, this.mouseBlockPosZ, destScale);
                    switch (this.drawingMode) {
                        case LINE_SEGMENT: {
                            ModuleManager.getModule(Drawing.class).addLine(line);
                            break;
                        }
                        case INFINITE_LINE: {
                            ModuleManager.getModule(Drawing.class).addInfiniteLine(line);
                        }
                    }
                    this.drawInProgressPos = null;
                    ModuleManager.getModule(Drawing.class).endOperation();
                    break;
                }
                case MEASUREMENT: {
                    this.drawInProgressPos = null;
                    break;
                }
                case HIGHLIGHT: {
                    ModuleManager.getModule(Drawing.class).endOperation();
                }
            }
            this.drawingLeftClickDown = false;
            cir.setReturnValue((Object)true);
        } else if (par3 == 1) {
            this.drawingRightClickDown = false;
            if (this.drawInProgressPos != null) {
                return;
            }
            ModuleManager.getModule(Drawing.class).removeLine(this.mouseBlockPosX, this.mouseBlockPosZ);
            ModuleManager.getModule(Drawing.class).removeText(this.mouseBlockPosX, this.mouseBlockPosZ, this.getFboScale());
            ModuleManager.getModule(Drawing.class).endOperation();
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private void xaeroPlus$stopDrawing() {
        this.drawing = false;
        this.drawInProgressPos = null;
        ModuleManager.getModule(Drawing.class).endOperation();
        ModuleManager.getModule(Drawing.class).removeInProgressLine();
        this.drawingLeftClickDown = false;
        this.drawingRightClickDown = false;
        this.drawTextEntryActive = false;
        this.m_169411_((GuiEventListener)this.drawLineSegmentButton);
        this.m_169411_((GuiEventListener)this.drawInfiniteLineButton);
        this.m_169411_((GuiEventListener)this.drawHighlightsButton);
        this.m_169411_((GuiEventListener)this.drawTextButton);
        this.m_169411_((GuiEventListener)this.drawColorCyclerButton);
        this.m_169411_((GuiEventListener)this.drawTextEntryField);
        this.m_169411_((GuiEventListener)this.drawMeasurementToolButton);
        this.drawLineSegmentButton.f_93624_ = false;
        this.drawInfiniteLineButton.f_93624_ = false;
        this.drawHighlightsButton.f_93624_ = false;
        this.drawTextButton.f_93624_ = false;
        this.drawColorCyclerButton.f_93624_ = false;
        this.drawTextEntryField.f_93624_ = false;
        this.drawMeasurementToolButton.f_93624_ = false;
        this.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
    }

    @Inject(method={"keyPressed"}, at={@At(value="RETURN")}, remap=true)
    public void xaeroplus$drawingModeUndo(int code, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (Screen.m_96637_() && code == 90) {
            ModuleManager.getModule(Drawing.class).undoLastOperation();
        }
    }

    @Inject(method={"onInputPress"}, at={@At(value="HEAD")})
    public void panMouseButtonClick(InputConstants.Type type, int code, CallbackInfoReturnable<Boolean> cir) {
        if (type != InputConstants.Type.MOUSE) {
            return;
        }
        if (code != 2) {
            return;
        }
        this.pan = true;
        Minecraft mc = Minecraft.m_91087_();
        this.panMouseStartX = Misc.getMouseX((Minecraft)mc, (boolean)true);
        this.panMouseStartY = Misc.getMouseY((Minecraft)mc, (boolean)true);
    }

    @Inject(method={"onInputRelease"}, at={@At(value="HEAD")}, cancellable=true)
    public void panMouseButtonRelease(InputConstants.Type type, int code, CallbackInfoReturnable<Boolean> cir) {
        if (this.drawing) {
            String value;
            if (type == InputConstants.Type.KEYSYM && code == 256) {
                this.xaeroPlus$stopDrawing();
                cir.setReturnValue((Object)true);
                return;
            }
            if (this.drawTextEntryActive && type == InputConstants.Type.KEYSYM && code == 257 && !(value = this.drawTextEntryField.m_94155_()).isEmpty()) {
                Text text = new Text(value, this.drawInProgressPos.m_123341_(), this.drawInProgressPos.m_123343_(), ColorHelper.getColor(255, 255, 255, 255), 1.0f);
                ModuleManager.getModule(Drawing.class).addText(text);
                this.xaeroPlus$stopDrawing();
                this.onToggleDrawingButton();
                cir.setReturnValue((Object)true);
                return;
            }
        }
        if (type != InputConstants.Type.MOUSE) {
            return;
        }
        if (code != 2) {
            return;
        }
        this.pan = false;
    }

    public boolean m_6913_() {
        return !this.drawing;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    public void panMapOnRender(CallbackInfo ci, @Local(argsOnly=true) float partialTicks) {
        if (!this.pan) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        double mouseX = Misc.getMouseX((Minecraft)mc, (boolean)true);
        double mouseY = Misc.getMouseY((Minecraft)mc, (boolean)true);
        double mouseDeltaX = mouseX - this.panMouseStartX;
        double mouseDeltaY = mouseY - this.panMouseStartY;
        double panDeltaX = (double)partialTicks * mouseDeltaX / destScale;
        double panDeltaZ = (double)partialTicks * mouseDeltaY / destScale;
        this.cameraX += panDeltaX;
        this.cameraZ += panDeltaZ;
    }

    @Inject(method={"render"}, at={@At(value="FIELD", target="Lxaero/map/settings/ModSettings;coordinates:Z", opcode=180, ordinal=0)}, remap=true)
    public void renderTileSelectionSize(GuiGraphics guiGraphics, int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci, @Local(name={"backgroundVertexBuffer"}) VertexConsumer backgroundVertexBuffer) {
        if (!Settings.REGISTRY.worldMapUIAdditions.get()) {
            return;
        }
        MapTileSelection selection = this.mapTileSelection;
        if (selection == null) {
            return;
        }
        int sideLen = Math.abs(selection.getRight() - selection.getLeft()) + 1;
        int heightLen = Math.abs(selection.getBottom() - selection.getTop()) + 1;
        if (sideLen <= 1 && heightLen <= 1) {
            return;
        }
        String string = sideLen + " x " + heightLen;
        Objects.requireNonNull(this.f_96547_);
        MapRenderHelper.drawCenteredStringWithBackground((GuiGraphics)guiGraphics, (Font)this.f_96547_, (String)string, (int)scaledMouseX, (int)(scaledMouseY - 9), (int)-1, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f, (VertexConsumer)backgroundVertexBuffer);
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    public void onInputPress(int code, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (code == 290) {
            Minecraft.m_91087_().f_91066_.f_92062_ = !Minecraft.m_91087_().f_91066_.f_92062_;
            cir.setReturnValue((Object)true);
            return;
        }
        if (this.xTextEntryField.m_94213_() && this.zTextEntryField.m_94213_() && (this.xTextEntryField.m_93696_() || this.zTextEntryField.m_93696_())) {
            if (code == 257) {
                this.onGotoCoordinatesButton(null);
                cir.setReturnValue((Object)true);
                return;
            }
            if (code == 258) {
                if (this.xTextEntryField.m_93696_()) {
                    this.m_7522_((GuiEventListener)this.zTextEntryField);
                } else if (this.zTextEntryField.m_93696_()) {
                    this.m_7522_((GuiEventListener)this.xTextEntryField);
                }
                cir.setReturnValue((Object)true);
                return;
            }
            if (Screen.m_96630_((int)code) && this.xTextEntryField.m_93696_()) {
                String pasteText = Minecraft.m_91087_().f_91068_.m_90876_().trim();
                Matcher xyzSpaces = Pattern.compile("(-?\\d+)\\s(-?\\d+)\\s(-?\\d+)").matcher(pasteText);
                if (xyzSpaces.matches()) {
                    String xText = xyzSpaces.group(1);
                    String zText = xyzSpaces.group(3);
                    this.xTextEntryField.m_94144_(xText);
                    this.zTextEntryField.m_94144_(zText);
                    cir.setReturnValue((Object)true);
                    return;
                }
                Matcher xyzCommaSpaces = Pattern.compile("(-?\\d+),\\s(-?\\d+),\\s(-?\\d+)").matcher(pasteText);
                if (xyzCommaSpaces.matches()) {
                    String xText = xyzCommaSpaces.group(1);
                    String zText = xyzCommaSpaces.group(3);
                    this.xTextEntryField.m_94144_(xText);
                    this.zTextEntryField.m_94144_(zText);
                    cir.setReturnValue((Object)true);
                    return;
                }
                Matcher xzSpaces = Pattern.compile("(-?\\d+)\\s(-?\\d+)").matcher(pasteText);
                if (xzSpaces.matches()) {
                    String xText = xzSpaces.group(1);
                    String zText = xzSpaces.group(2);
                    this.xTextEntryField.m_94144_(xText);
                    this.zTextEntryField.m_94144_(zText);
                    cir.setReturnValue((Object)true);
                    return;
                }
                Matcher xzCommaSpaces = Pattern.compile("(-?\\d+),\\s(-?\\d+)").matcher(pasteText);
                if (xzCommaSpaces.matches()) {
                    String xText = xzCommaSpaces.group(1);
                    String zText = xzCommaSpaces.group(2);
                    this.xTextEntryField.m_94144_(xText);
                    this.zTextEntryField.m_94144_(zText);
                    cir.setReturnValue((Object)true);
                    return;
                }
            }
        }
        if (BaritoneHelper.isBaritonePresent()) {
            if (Settings.REGISTRY.worldMapBaritoneGoalHereKeybindSetting.getKeyBinding().m_90832_(code, scanCode)) {
                BaritoneExecutor.goal(this.mouseBlockPosX, this.mouseBlockPosZ);
                cir.setReturnValue((Object)true);
            } else if (Settings.REGISTRY.worldMapBaritonePathHereKeybindSetting.getKeyBinding().m_90832_(code, scanCode)) {
                BaritoneExecutor.path(this.mouseBlockPosX, this.mouseBlockPosZ);
                cir.setReturnValue((Object)true);
            } else if (BaritoneHelper.isBaritoneElytraPresent() && Settings.REGISTRY.worldMapBaritoneElytraHereKeybindSetting.getKeyBinding().m_90832_(code, scanCode)) {
                BaritoneExecutor.elytra(this.mouseBlockPosX, this.mouseBlockPosZ);
                cir.setReturnValue((Object)true);
            }
        }
        if (Settings.REGISTRY.worldMapToggleDrawingKeybindSetting.getKeyBinding().m_90832_(code, scanCode)) {
            this.onToggleDrawingButton();
            cir.setReturnValue((Object)true);
            return;
        }
    }

    @Inject(method={"getRightClickOptions"}, at={@At(value="RETURN")}, remap=false)
    public void getRightClickOptionsInject(CallbackInfoReturnable<ArrayList<RightClickOption>> cir) {
        if (!Settings.REGISTRY.worldMapUIAdditions.get()) {
            return;
        }
        ArrayList options = (ArrayList)cir.getReturnValue();
        int index = 3;
        options.add(index++, new RightClickOption("xaeroplus.gui.world_map.copy_coordinates", options.size(), this){

            public void onAction(Screen screen) {
                Minecraft.m_91087_().f_91068_.m_90911_(MixinGuiMap.this.rightClickX + " " + MixinGuiMap.this.rightClickY + " " + MixinGuiMap.this.rightClickZ);
            }
        });
        if (BaritoneHelper.isBaritonePresent()) {
            final int goalX = this.rightClickX;
            final int goalZ = this.rightClickZ;
            options.add(index++, new RightClickOption("xaeroplus.gui.world_map.baritone_goal_here", options.size(), this){

                public void onAction(Screen screen) {
                    BaritoneExecutor.goal(goalX, goalZ);
                }
            }.setNameFormatArgs(new Object[]{Misc.getKeyName((KeyMapping)Settings.REGISTRY.worldMapBaritoneGoalHereKeybindSetting.getKeyBinding())}));
            options.add(index++, new RightClickOption("xaeroplus.gui.world_map.baritone_path_here", options.size(), this){

                public void onAction(Screen screen) {
                    BaritoneExecutor.path(goalX, goalZ);
                }
            }.setNameFormatArgs(new Object[]{Misc.getKeyName((KeyMapping)Settings.REGISTRY.worldMapBaritonePathHereKeybindSetting.getKeyBinding())}));
            if (BaritoneHelper.isBaritoneElytraPresent()) {
                options.add(index++, new RightClickOption("xaeroplus.gui.world_map.baritone_elytra_here", options.size(), this){

                    public void onAction(Screen screen) {
                        BaritoneExecutor.elytra(goalX, goalZ);
                    }
                }.setNameFormatArgs(new Object[]{Misc.getKeyName((KeyMapping)Settings.REGISTRY.worldMapBaritoneElytraHereKeybindSetting.getKeyBinding())}));
            }
        }
        boolean tileSelPresent = this.mapTileSelection != null;
        final int delHighlightMinX = tileSelPresent ? this.mapTileSelection.getLeft() : this.rightClickX;
        final int delHighlightMaxX = tileSelPresent ? this.mapTileSelection.getRight() : this.rightClickX;
        final int delHighlightMinZ = tileSelPresent ? this.mapTileSelection.getTop() : this.rightClickZ;
        final int delHighlightMaxZ = tileSelPresent ? this.mapTileSelection.getBottom() : this.rightClickZ;
        options.add(index++, new RightClickOption("xaeroplus.gui.world_map.delete_highlights", options.size(), this){

            public void onAction(Screen screen) {
                ResourceKey<Level> dim = Globals.getCurrentDimensionId();
                for (int x = delHighlightMinX; x <= delHighlightMaxX; ++x) {
                    for (int z = delHighlightMinZ; z <= delHighlightMaxZ; ++z) {
                        LavaColumns lavaColumns;
                        Portals portals;
                        PaletteNewChunks paletteNewChunks;
                        OldChunks oldChunks;
                        OldBiomes oldbiomes;
                        LiquidNewChunks liquidNewChunks;
                        Breadcrumbs breadcrumbs = ModuleManager.getModule(Breadcrumbs.class);
                        if (breadcrumbs.isEnabled()) {
                            breadcrumbs.breadcrumbsCache.get().removeHighlight(x, z, dim);
                        }
                        if ((liquidNewChunks = ModuleManager.getModule(LiquidNewChunks.class)).isEnabled()) {
                            liquidNewChunks.newChunksCache.get().removeHighlight(x, z, dim);
                            liquidNewChunks.inverseNewChunksCache.get().removeHighlight(x, z, dim);
                        }
                        if ((oldbiomes = ModuleManager.getModule(OldBiomes.class)).isEnabled()) {
                            oldbiomes.oldBiomesCache.get().removeHighlight(x, z, dim);
                        }
                        if ((oldChunks = ModuleManager.getModule(OldChunks.class)).isEnabled()) {
                            oldChunks.oldChunksCache.get().removeHighlight(x, z, dim);
                            oldChunks.modernChunksCache.get().removeHighlight(x, z, dim);
                        }
                        if ((paletteNewChunks = ModuleManager.getModule(PaletteNewChunks.class)).isEnabled()) {
                            paletteNewChunks.newChunksCache.get().removeHighlight(x, z, dim);
                            paletteNewChunks.newChunksInverseCache.get().removeHighlight(x, z, dim);
                        }
                        if ((portals = ModuleManager.getModule(Portals.class)).isEnabled()) {
                            portals.portalsCache.get().removeHighlight(x, z, dim);
                        }
                        if ((lavaColumns = ModuleManager.getModule(LavaColumns.class)).isEnabled()) {
                            lavaColumns.lavaColumnsCache.get().removeHighlight(x, z, dim);
                        }
                        ModuleManager.getModule(Drawing.class).removeHighlight(x, z);
                        ModuleManager.getModule(Drawing.class).removeLine(ChunkUtils.chunkCoordToCoord(x), ChunkUtils.chunkCoordToCoord(z));
                        ModuleManager.getModule(Drawing.class).removeText(ChunkUtils.chunkCoordToCoord(x), ChunkUtils.chunkCoordToCoord(z), 1.0f);
                    }
                }
            }
        });
        if (Settings.REGISTRY.disableWaypointSharing.get()) {
            options.removeIf(option -> ((AccessorRightClickOption)option).getName().equals("gui.xaero_right_click_map_share_location"));
        }
        if (!Settings.REGISTRY.showCoordsInRightClickOptions.get()) {
            options.removeIf(option -> {
                String name = ((AccessorRightClickOption)option).getName();
                return name.startsWith("C: (") || name.startsWith("X: ");
            });
        }
    }

    @Unique
    public void onFollowButton(Button b) {
        follow = !follow;
        this.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
    }

    @Unique
    public void onGotoCoordinatesButton(Button b) {
        if (this.xTextEntryField.m_94213_() && this.zTextEntryField.m_94213_()) {
            try {
                int x = Integer.parseInt(this.xTextEntryField.m_94155_());
                int z = Integer.parseInt(this.zTextEntryField.m_94155_());
                this.cameraX = x;
                this.cameraZ = z;
                follow = false;
                this.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
            }
            catch (NumberFormatException e) {
                this.xTextEntryField.m_94144_("");
                this.zTextEntryField.m_94144_("");
                this.xTextEntryField.f_93624_ = false;
                this.zTextEntryField.f_93624_ = false;
            }
        } else {
            this.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
            ForkJoinPool.commonPool().execute(() -> Minecraft.m_91087_().execute(() -> {
                this.xTextEntryField.m_94194_(true);
                this.zTextEntryField.m_94194_(true);
                this.m_7522_((GuiEventListener)this.xTextEntryField);
            }));
        }
    }

    @Unique
    private void onSwitchDimensionButton(ResourceKey<Level> newDimId) {
        Globals.switchToDimension(newDimId);
    }

    @Unique
    public List<Button> getButtonList() {
        return this.m_6702_().stream().filter(child -> child instanceof Button).map(child -> (Button)child).collect(Collectors.toList());
    }

    @Unique
    public void clearButtons() {
        this.getButtonList().forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
    }
}

