/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.highlights;

import net.lenni0451.lambdaevents.EventHandler;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ClientTickEvent;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.highlights.ChunkHighlightCache;
import xaeroplus.feature.highlights.ChunkHighlightLocalCache;
import xaeroplus.feature.highlights.ChunkHighlightSavingCache;

public class SavableHighlightCacheInstance {
    private ChunkHighlightCache cache;
    private final String dbName;

    public SavableHighlightCacheInstance(String dbName) {
        this.dbName = dbName;
        this.cache = new ChunkHighlightLocalCache();
    }

    public ChunkHighlightCache get() {
        return this.cache;
    }

    public synchronized void onEnable() {
        XaeroPlus.EVENT_BUS.register(this);
        this.cache.onEnable();
    }

    public synchronized void onDisable() {
        this.cache.onDisable();
        XaeroPlus.EVENT_BUS.unregister(this);
    }

    public synchronized void setDiskCache(boolean disk, boolean enabled) {
        try {
            this.cache.onDisable();
            ChunkHighlightCache chunkHighlightCache = this.cache;
            if (chunkHighlightCache instanceof ChunkHighlightSavingCache) {
                ChunkHighlightSavingCache savingCache = (ChunkHighlightSavingCache)chunkHighlightCache;
                savingCache.close();
            }
            this.cache = disk ? new ChunkHighlightSavingCache(this.dbName) : new ChunkHighlightLocalCache();
            if (enabled) {
                this.cache.onEnable();
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error setting {} cache [{} {}]", new Object[]{this.dbName, disk, enabled, e});
        }
    }

    @EventHandler
    public void onXaeroWorldChange(XaeroWorldChangeEvent event) {
        try {
            this.cache.handleWorldChange(event);
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error handling world change event for cache: {} event: {}", new Object[]{this.dbName, event, e});
        }
    }

    @EventHandler
    public void onClientTickEvent(ClientTickEvent.Post event) {
        try {
            this.cache.handleTick();
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error handling tick event for cache: {} event: {}", new Object[]{this.dbName, event, e});
        }
    }
}

