/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.Writer;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;

public class FileUtil {
    private FileUtil() {
    }

    public static void safeSave(File outputFile, Consumer<Writer> fileWriter) throws RuntimeException {
        try {
            Path tempFilePath = Files.createTempFile("xaeroplus", ".tmp", new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(tempFilePath, new OpenOption[0]);){
                fileWriter.accept(writer);
            }
            try {
                Files.move(tempFilePath, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException e) {
                Files.move(tempFilePath, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error during safeSave", e);
        }
    }
}

