/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.lenni0451.lambdaevents.EventHandler;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import xaero.common.HudMod;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.shader.MinimapShaders;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.render.DrawFeatureRegistry;
import xaeroplus.feature.render.DrawHelper;
import xaeroplus.feature.render.HighlightShader;
import xaeroplus.feature.render.Line;
import xaeroplus.feature.render.XaeroPlusShaders;
import xaeroplus.util.ColorHelper;

public class DrawManager {
    private final DrawFeatureRegistry registry = new DrawFeatureRegistry();

    public final DrawFeatureRegistry registry() {
        return this.registry;
    }

    public DrawManager() {
        XaeroPlus.EVENT_BUS.register((Object)this);
    }

    @EventHandler
    public void onXaeroWorldChange(XaeroWorldChangeEvent event) {
        this.registry.invalidateCaches();
    }

    public void drawMinimapFeatures(int chunkX, int chunkZ, int tileX, int tileZ, int insideX, int insideZ, class_4587 matrixStack, class_4597.class_4598 renderTypeBuffers) {
        if (HudMod.INSTANCE.isFairPlay()) {
            return;
        }
        matrixStack.method_22903();
        matrixStack.method_46416((float)(-(chunkX * 64) - tileX * 16 - insideX), (float)(-(chunkZ * 64) - tileZ * 16 - insideZ), 0.0f);
        matrixStack.method_22903();
        matrixStack.method_22905(16.0f, 16.0f, 1.0f);
        this.drawChunkHighlights(matrixStack, false);
        matrixStack.method_22909();
        this.drawMinimapLines(matrixStack, renderTypeBuffers);
        matrixStack.method_22909();
    }

    public void drawMinimapLines(class_4587 matrixStack, class_4597.class_4598 renderTypeBuffers) {
        MinimapShaders.ensureShaders();
        this.registry.forEachLineDrawFeature(feature -> {
            int color = feature.colorInt();
            float a = ColorHelper.getA(color);
            if (a == 0.0f) {
                return;
            }
            class_4588 lineBuffer = renderTypeBuffers.getBuffer(CustomRenderTypes.MAP_LINES);
            float lineWidthScale = 16.0f * class_3532.method_15363((float)feature.lineWidth(), (float)(0.1f * (float)Globals.minimapScaleMultiplier), (float)1000.0f);
            RenderSystem.lineWidth((float)lineWidthScale);
            float r = ColorHelper.getR(color);
            float g = ColorHelper.getG(color);
            float b = ColorHelper.getB(color);
            List<Line> lines = feature.getLines();
            for (int j = 0; j < lines.size(); ++j) {
                Line line = lines.get(j);
                int x1 = line.x1();
                int z1 = line.z1();
                int x2 = line.x2();
                int z2 = line.z2();
                if (z2 < z1) {
                    int tz1 = z1;
                    z1 = z2;
                    z2 = tz1;
                    int tx1 = x1;
                    x1 = x2;
                    x2 = tx1;
                }
                DrawHelper.addColoredLineToExistingBuffer(matrixStack.method_23760(), lineBuffer, x1, z1, x2, z2, r, g, b, a);
            }
            renderTypeBuffers.method_22994(CustomRenderTypes.MAP_LINES);
        });
    }

    public void drawWorldMapFeatures(int flooredCameraX, int flooredCameraZ, class_4587 matrixStack, double fboScale, class_4597.class_4598 renderTypeBuffers) {
        if (HudMod.INSTANCE.isFairPlay()) {
            return;
        }
        matrixStack.method_22903();
        matrixStack.method_46416((float)(-flooredCameraX), (float)(-flooredCameraZ), 1.0f);
        matrixStack.method_22903();
        matrixStack.method_22905(16.0f, 16.0f, 1.0f);
        this.drawChunkHighlights(matrixStack, true);
        matrixStack.method_22909();
        this.drawWorldMapLines(matrixStack, fboScale, renderTypeBuffers);
        matrixStack.method_22909();
    }

    public void drawWorldMapLines(class_4587 matrixStack, double fboScale, class_4597.class_4598 renderTypeBuffers) {
        MinimapShaders.ensureShaders();
        class_310 mc = class_310.method_1551();
        MinimapShaders.FRAMEBUFFER_LINES.setFrameSize((float)mc.method_22683().method_4489(), (float)mc.method_22683().method_4506());
        this.registry.forEachLineDrawFeature(feature -> {
            int color = feature.colorInt();
            float a = ColorHelper.getA(color);
            if (a == 0.0f) {
                return;
            }
            class_4588 lineBuffer = renderTypeBuffers.getBuffer(CustomRenderTypes.MAP_LINES);
            float lineWidthScale = 16.0f * (float)class_3532.method_15350((double)((double)feature.lineWidth() * fboScale), (double)0.1f, (double)1000.0);
            RenderSystem.lineWidth((float)lineWidthScale);
            float r = ColorHelper.getR(color);
            float g = ColorHelper.getG(color);
            float b = ColorHelper.getB(color);
            List<Line> lines = feature.getLines();
            for (int j = 0; j < lines.size(); ++j) {
                Line line = lines.get(j);
                int x1 = line.x1();
                int z1 = line.z1();
                int x2 = line.x2();
                int z2 = line.z2();
                if (z2 < z1) {
                    int tz1 = z1;
                    z1 = z2;
                    z2 = tz1;
                    int tx1 = x1;
                    x1 = x2;
                    x2 = tx1;
                }
                DrawHelper.addColoredLineToExistingBuffer(matrixStack.method_23760(), lineBuffer, x2, z2, x1, z1, r, g, b, a);
            }
            renderTypeBuffers.method_22994(CustomRenderTypes.MAP_LINES);
        });
    }

    public void drawChunkHighlights(class_4587 matrixStack, boolean worldmap) {
        XaeroPlusShaders.ensureShaders();
        HighlightShader shader = XaeroPlusShaders.HIGHLIGHT_SHADER;
        if (shader == null) {
            return;
        }
        shader.setMapViewMatrix(matrixStack.method_23760().method_23761());
        RenderSystem.enableBlend();
        this.registry.forEachChunkHighlightDrawFeature(feature -> {
            int color = feature.colorInt();
            float a = ColorHelper.getA(color);
            if (a == 0.0f) {
                return;
            }
            float r = ColorHelper.getR(color);
            float g = ColorHelper.getG(color);
            float b = ColorHelper.getB(color);
            shader.setHighlightColor(r, g, b, a);
            feature.render(worldmap);
        });
        RenderSystem.disableBlend();
    }
}

