/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_5944;
import org.jetbrains.annotations.Nullable;
import xaeroplus.feature.render.HighlightShader;
import xaeroplus.feature.render.XaeroPlusShaders;
import xaeroplus.util.ChunkUtils;

public class HighlightDrawBuffer {
    private boolean stale = true;
    @Nullable
    private class_291 vertexBuffer = null;
    private boolean flipped = false;
    long lastRefreshed = 0L;

    public boolean needsRefresh(boolean needsFlip) {
        return this.vertexBuffer == null || this.vertexBuffer.method_43444() || this.stale || this.flipped != needsFlip;
    }

    public void refresh(Long2LongMap highlights, boolean needsFlip) {
        this.stale = false;
        this.lastRefreshed = System.currentTimeMillis();
        this.flipped = needsFlip;
        if (highlights.isEmpty()) {
            this.close();
            return;
        }
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        for (Long highlight : highlights.keySet()) {
            int chunkPosX = ChunkUtils.longToChunkX(highlight);
            int chunkPosZ = ChunkUtils.longToChunkZ(highlight);
            float x1 = chunkPosX;
            float x2 = chunkPosX + 1;
            float y1 = needsFlip ? (float)(chunkPosZ + 1) : (float)chunkPosZ;
            float y2 = needsFlip ? (float)chunkPosZ : (float)(chunkPosZ + 1);
            bufferBuilder.method_22912((double)x1, (double)y2, 0.0).method_1344();
            bufferBuilder.method_22912((double)x2, (double)y2, 0.0).method_1344();
            bufferBuilder.method_22912((double)x2, (double)y1, 0.0).method_1344();
            bufferBuilder.method_22912((double)x1, (double)y1, 0.0).method_1344();
        }
        if (this.vertexBuffer == null || this.vertexBuffer.method_43444()) {
            this.close();
            this.vertexBuffer = new class_291(class_291.class_8555.field_44794);
        }
        class_287.class_7433 meshData = bufferBuilder.method_1326();
        this.vertexBuffer.method_1353();
        this.vertexBuffer.method_1352(meshData);
    }

    public void render() {
        if (this.vertexBuffer == null || this.vertexBuffer.method_43444()) {
            return;
        }
        HighlightShader shader = XaeroPlusShaders.HIGHLIGHT_SHADER;
        if (shader == null) {
            return;
        }
        this.vertexBuffer.method_1353();
        this.vertexBuffer.method_34427(RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix(), (class_5944)shader);
    }

    public void markStale() {
        this.stale = true;
    }

    public void close() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
    }
}

