/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.waypoint;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.set.WaypointSet;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.container.MinimapWorldContainer;
import xaero.hud.minimap.world.container.MinimapWorldRootContainer;
import xaero.hud.path.XaeroPath;
import xaeroplus.mixin.client.AccessorWaypointSet;

public class WaypointAPI {
    public static MinimapWorld getMinimapWorld(class_5321<class_1937> dim) {
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession == null) {
            return null;
        }
        MinimapWorld currentWorld = minimapSession.getWorldManager().getCurrentWorld();
        if (currentWorld == null) {
            return null;
        }
        if (currentWorld.getDimId() == dim) {
            return currentWorld;
        }
        MinimapWorldRootContainer rootContainer = minimapSession.getWorldManager().getCurrentRootContainer();
        for (MinimapWorld world : rootContainer.getWorlds()) {
            if (world.getDimId() != dim) continue;
            return world;
        }
        String waystoneDimensionDirectoryName = minimapSession.getDimensionHelper().getDimensionDirectoryName(dim);
        String waystoneWpWorldNode = minimapSession.getWorldStateUpdater().getPotentialWorldNode(dim, true);
        XaeroPath waystoneWpContainerPath = minimapSession.getWorldState().getAutoRootContainerPath().resolve(waystoneDimensionDirectoryName).resolve(waystoneWpWorldNode);
        return minimapSession.getWorldManager().getWorld(waystoneWpContainerPath);
    }

    public static WaypointSet getOrCreateWaypointSetInWorld(MinimapWorld minimapWorld, String setName) {
        WaypointSet waypointSet = minimapWorld.getWaypointSet(setName);
        if (waypointSet == null) {
            minimapWorld.addWaypointSet(setName);
            waypointSet = minimapWorld.getWaypointSet(setName);
        }
        return waypointSet;
    }

    public static void forEachWaypointSetInCurrentContainer(Consumer<List<Waypoint>> consumer) {
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession == null) {
            return;
        }
        MinimapWorldRootContainer rootContainer = minimapSession.getWorldManager().getCurrentRootContainer();
        Iterable rootWorlds = rootContainer.getWorlds();
        for (MinimapWorld world : rootWorlds) {
            for (WaypointSet set : world.getIterableWaypointSets()) {
                consumer.accept(((AccessorWaypointSet)set).getList());
            }
        }
        for (MinimapWorldContainer subContainer : rootContainer.getSubContainers()) {
            for (MinimapWorld world : subContainer.getWorlds()) {
                for (WaypointSet set : world.getIterableWaypointSets()) {
                    consumer.accept(((AccessorWaypointSet)set).getList());
                }
            }
        }
    }

    public static WaypointSet getCurrentWaypointSet() {
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession == null) {
            return null;
        }
        MinimapWorld currentWorld = minimapSession.getWorldManager().getCurrentWorld();
        if (currentWorld == null) {
            return null;
        }
        return currentWorld.getCurrentWaypointSet();
    }
}

