/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlight;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_5944;
import xaeroplus.feature.render.DrawContext;
import xaeroplus.feature.render.highlight.AbstractHighlightVertexBuffer;
import xaeroplus.feature.render.highlight.MultiColorHighlightColorFunction;
import xaeroplus.feature.render.shaders.MultiColorHighlightShader;
import xaeroplus.feature.render.shaders.XaeroPlusShaders;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class MultiColorHighlightVertexBuffer
extends AbstractHighlightVertexBuffer {
    private final MultiColorHighlightColorFunction colorFunction;

    public MultiColorHighlightVertexBuffer(MultiColorHighlightColorFunction colorFunction) {
        this.colorFunction = colorFunction;
    }

    @Override
    public void preRender(DrawContext ctx, Long2LongMap highlights, int color) {
        super.preRender(ctx, highlights, color);
        MultiColorHighlightShader shader = XaeroPlusShaders.MULTI_COLOR_HIGHLIGHT_SHADER;
        shader.setMapViewMatrix(ctx.matrixStack().method_23760().method_23761());
    }

    @Override
    public void refresh(DrawContext ctx, Long2LongMap highlights, int colorAlpha) {
        this.stale = false;
        this.lastRefreshed = System.currentTimeMillis();
        this.flipped = ctx.worldmap();
        if (highlights.isEmpty()) {
            this.close();
            return;
        }
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        ObjectIterator it = Long2LongMaps.fastIterator((Long2LongMap)highlights);
        while (it.hasNext()) {
            long foundTime;
            Long2LongMap.Entry entry = (Long2LongMap.Entry)it.next();
            long pos = entry.getLongKey();
            int color = this.colorFunction.getColor(pos, foundTime = entry.getLongValue());
            int alpha = ColorHelper.getIntA(color);
            if (alpha == 0) continue;
            int chunkPosX = ChunkUtils.longToChunkX(pos);
            int chunkPosZ = ChunkUtils.longToChunkZ(pos);
            float x1 = chunkPosX;
            float x2 = chunkPosX + 1;
            float y1 = this.flipped ? (float)(chunkPosZ + 1) : (float)chunkPosZ;
            float y2 = this.flipped ? (float)chunkPosZ : (float)(chunkPosZ + 1);
            bufferBuilder.method_22912((double)x1, (double)y2, 0.0).method_39415(color).method_1344();
            bufferBuilder.method_22912((double)x2, (double)y2, 0.0).method_39415(color).method_1344();
            bufferBuilder.method_22912((double)x2, (double)y1, 0.0).method_39415(color).method_1344();
            bufferBuilder.method_22912((double)x1, (double)y1, 0.0).method_39415(color).method_1344();
        }
        if (this.vertexBuffer == null || this.vertexBuffer.method_43444()) {
            this.close();
            this.vertexBuffer = new class_291(class_291.class_8555.field_44794);
        }
        class_287.class_7433 meshData = bufferBuilder.method_1326();
        this.vertexBuffer.method_1353();
        this.vertexBuffer.method_1352(meshData);
    }

    @Override
    public class_5944 shaderInstance() {
        return XaeroPlusShaders.MULTI_COLOR_HIGHLIGHT_SHADER;
    }
}

