/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.settings;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleConsumer;
import net.minecraft.class_304;
import xaero.common.graphics.CursorBox;
import xaero.common.settings.ModOptions;
import xaeroplus.XaeroPlus;
import xaeroplus.mixin.client.AccessorMinimapModOptions;
import xaeroplus.mixin.client.AccessorWorldMapModOptions;
import xaeroplus.settings.XaeroPlusSetting;

public class DoubleSetting
extends XaeroPlusSetting {
    private final double valueMin;
    private final double valueMax;
    private final double valueStep;
    private double value;
    private DoubleConsumer settingChangeConsumer;

    private DoubleSetting(String settingName, String settingNameTranslationKey, String tooltipTranslationKey, class_304 keyBinding, double valueMin, double valueMax, double valueStep, double defaultValue, DoubleConsumer settingChangeConsumer, BooleanSupplier visibilitySupplier) {
        super(settingName, settingNameTranslationKey, tooltipTranslationKey, keyBinding, visibilitySupplier);
        this.valueMin = valueMin;
        this.valueMax = valueMax;
        this.valueStep = valueStep;
        this.value = defaultValue;
        this.settingChangeConsumer = settingChangeConsumer;
    }

    public static DoubleSetting create(String settingName, String settingNameTranslationKey, double valueMin, double valueMax, double valueStep, double defaultValue) {
        return new DoubleSetting("[XP] " + settingName, settingNameTranslationKey, DoubleSetting.buildTooltipTranslationKey(settingNameTranslationKey), null, valueMin, valueMax, valueStep, defaultValue, null, null);
    }

    public static DoubleSetting create(String settingName, String settingNameTranslationKey, double valueMin, double valueMax, double valueStep, double defaultValue, DoubleConsumer changeConsumer) {
        return new DoubleSetting("[XP] " + settingName, settingNameTranslationKey, DoubleSetting.buildTooltipTranslationKey(settingNameTranslationKey), null, valueMin, valueMax, valueStep, defaultValue, changeConsumer, null);
    }

    public static DoubleSetting create(String settingName, String settingNameTranslationKey, double valueMin, double valueMax, double valueStep, double defaultValue, BooleanSupplier visibilitySupplier) {
        return new DoubleSetting("[XP] " + settingName, settingNameTranslationKey, DoubleSetting.buildTooltipTranslationKey(settingNameTranslationKey), null, valueMin, valueMax, valueStep, defaultValue, null, visibilitySupplier);
    }

    public static DoubleSetting create(String settingName, String settingNameTranslationKey, double valueMin, double valueMax, double valueStep, double defaultValue, DoubleConsumer changeConsumer, BooleanSupplier visibilitySupplier) {
        return new DoubleSetting("[XP] " + settingName, settingNameTranslationKey, DoubleSetting.buildTooltipTranslationKey(settingNameTranslationKey), null, valueMin, valueMax, valueStep, defaultValue, changeConsumer, visibilitySupplier);
    }

    @Override
    public String getSerializedValue() {
        return Double.toString(this.value);
    }

    @Override
    public void deserializeValue(String value) {
        double f = Double.parseDouble(value);
        if (f != this.get()) {
            this.setValue(f);
        }
    }

    @Override
    public ModOptions toMinimapModOptions() {
        return AccessorMinimapModOptions.createDoubleSetting(this.getSettingName(), this.getValueMin(), this.getValueMax(), (float)this.getValueStep(), new CursorBox(this.getTooltipTranslationKey()), this.isIngameOnly());
    }

    @Override
    public xaero.map.settings.ModOptions toWorldMapModOptions() {
        return AccessorWorldMapModOptions.createDoubleSetting(this.getSettingName(), this.getValueMin(), this.getValueMax(), this.getValueStep(), new xaero.map.gui.CursorBox(this.getTooltipTranslationKey()), this.isIngameOnly(), this.isRequiresMinimap(), false);
    }

    public double getValueMin() {
        return this.valueMin;
    }

    public double getValueMax() {
        return this.valueMax;
    }

    public double getValueStep() {
        return this.valueStep;
    }

    public double get() {
        return this.value;
    }

    public int getAsInt() {
        return (int)this.value;
    }

    public void setValue(double value) {
        this.value = value;
        if (Objects.nonNull(this.getSettingChangeConsumer())) {
            try {
                this.getSettingChangeConsumer().accept(value);
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.warn("Error applying setting change consumer for {}", (Object)this.getSettingName(), (Object)e);
            }
        }
    }

    public DoubleConsumer getSettingChangeConsumer() {
        return this.settingChangeConsumer;
    }

    public void setSettingChangeConsumer(DoubleConsumer settingChangeConsumer) {
        this.settingChangeConsumer = settingChangeConsumer;
    }

    @Override
    public void init() {
        if (Objects.nonNull(this.settingChangeConsumer)) {
            this.settingChangeConsumer.accept(this.value);
        }
    }
}

