/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.settings;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_304;
import xaero.common.gui.ConfigSettingEntry;
import xaeroplus.settings.BooleanSetting;
import xaeroplus.settings.DoubleSetting;
import xaeroplus.settings.EnumSetting;
import xaeroplus.settings.SettingLocation;
import xaeroplus.settings.StringSetting;
import xaeroplus.settings.XaeroPlusSetting;

public abstract class SettingRegistry {
    private final Map<SettingLocation, ArrayList<XaeroPlusSetting>> settingLocationMap = new EnumMap<SettingLocation, ArrayList<XaeroPlusSetting>>(SettingLocation.class);
    private final Map<String, XaeroPlusSetting> settingNameMap = new ConcurrentHashMap<String, XaeroPlusSetting>();
    private final Map<class_304, BooleanSetting> keybindingMap = new ConcurrentHashMap<class_304, BooleanSetting>();

    public BooleanSetting register(BooleanSetting setting, SettingLocation settingLocation) {
        this.register0(settingLocation, setting);
        return setting;
    }

    public DoubleSetting register(DoubleSetting setting, SettingLocation settingLocation) {
        this.register0(settingLocation, setting);
        return setting;
    }

    public <E extends Enum<E>> EnumSetting<E> register(EnumSetting<E> setting, SettingLocation settingLocation) {
        this.register0(settingLocation, setting);
        return setting;
    }

    public StringSetting register(StringSetting setting, SettingLocation settingLocation) {
        this.register0(settingLocation, setting);
        return setting;
    }

    private synchronized void register0(SettingLocation settingLocation, XaeroPlusSetting setting) {
        BooleanSetting booleanSetting;
        class_304 kb;
        if (this.settingNameMap.containsKey(setting.getSettingName())) {
            throw new RuntimeException("Setting with name '" + setting.getSettingName() + "' already exists");
        }
        ArrayList<XaeroPlusSetting> settingList = this.settingLocationMap.getOrDefault((Object)settingLocation, new ArrayList());
        settingList.add(setting);
        this.settingLocationMap.put(settingLocation, settingList);
        this.settingNameMap.put(setting.getSettingName(), setting);
        if (setting instanceof BooleanSetting && (kb = (booleanSetting = (BooleanSetting)setting).getKeyBinding()) != null) {
            this.keybindingMap.put(kb, booleanSetting);
        }
    }

    public XaeroPlusSetting getSettingByName(String name) {
        return this.settingNameMap.get(name);
    }

    public Set<class_304> getKeybindings() {
        return this.keybindingMap.keySet();
    }

    public BooleanSetting getKeybindingSetting(class_304 keyMapping) {
        return this.keybindingMap.get(keyMapping);
    }

    public List<XaeroPlusSetting> getAllSettings() {
        return new ArrayList<XaeroPlusSetting>(this.settingNameMap.values());
    }

    public synchronized ConfigSettingEntry[] getMinimapConfigSettingEntries(SettingLocation settingLocation) {
        ArrayList<XaeroPlusSetting> settingList = this.settingLocationMap.get((Object)settingLocation);
        if (settingList != null) {
            ArrayList<ConfigSettingEntry> entries = new ArrayList<ConfigSettingEntry>(settingList.size());
            for (int i = 0; i < settingList.size(); ++i) {
                XaeroPlusSetting xaeroPlusSetting = settingList.get(i);
                ConfigSettingEntry entry = xaeroPlusSetting.toMinimapConfigSettingEntry();
                if (entry == null) continue;
                entries.add(entry);
            }
            return entries.toArray(new ConfigSettingEntry[0]);
        }
        return new ConfigSettingEntry[0];
    }

    public synchronized xaero.map.gui.ConfigSettingEntry[] getWorldmapConfigSettingEntries(SettingLocation settingLocation) {
        ArrayList<XaeroPlusSetting> settingList = this.settingLocationMap.get((Object)settingLocation);
        if (settingList != null) {
            ArrayList<xaero.map.gui.ConfigSettingEntry> entries = new ArrayList<xaero.map.gui.ConfigSettingEntry>(settingList.size());
            for (int i = 0; i < settingList.size(); ++i) {
                XaeroPlusSetting xaeroPlusSetting = settingList.get(i);
                xaero.map.gui.ConfigSettingEntry entry = xaeroPlusSetting.toWorldmapConfigSettingEntry();
                if (entry == null) continue;
                entries.add(entry);
            }
            return entries.toArray(new xaero.map.gui.ConfigSettingEntry[0]);
        }
        return new xaero.map.gui.ConfigSettingEntry[0];
    }
}

