/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlight;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import net.minecraft.client.renderer.ShaderInstance;
import xaeroplus.feature.render.DrawContext;
import xaeroplus.feature.render.highlight.AbstractHighlightVertexBuffer;
import xaeroplus.feature.render.shaders.HighlightShader;
import xaeroplus.feature.render.shaders.XaeroPlusShaders;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class HighlightVertexBuffer
extends AbstractHighlightVertexBuffer {
    @Override
    public ShaderInstance shaderInstance() {
        return XaeroPlusShaders.HIGHLIGHT_SHADER;
    }

    @Override
    public void preRender(DrawContext ctx, Long2LongMap highlights, int color) {
        super.preRender(ctx, highlights, color);
        HighlightShader shader = XaeroPlusShaders.HIGHLIGHT_SHADER;
        shader.setMapViewMatrix(ctx.matrixStack().m_85850_().m_252922_());
        float a = ColorHelper.getA(color);
        float r = ColorHelper.getR(color);
        float g = ColorHelper.getG(color);
        float b = ColorHelper.getB(color);
        shader.setHighlightColor(r, g, b, a);
    }

    @Override
    public void refresh(DrawContext ctx, Long2LongMap highlights, int color) {
        this.stale = false;
        this.lastRefreshed = System.currentTimeMillis();
        this.flipped = ctx.worldmap();
        if (highlights.isEmpty() || ColorHelper.getA(color) == 0.0f) {
            this.close();
            return;
        }
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (Long highlight : highlights.keySet()) {
            int chunkPosX = ChunkUtils.longToChunkX(highlight);
            int chunkPosZ = ChunkUtils.longToChunkZ(highlight);
            float x1 = chunkPosX;
            float x2 = chunkPosX + 1;
            float y1 = this.flipped ? (float)(chunkPosZ + 1) : (float)chunkPosZ;
            float y2 = this.flipped ? (float)chunkPosZ : (float)(chunkPosZ + 1);
            bufferBuilder.m_5483_((double)x1, (double)y2, 0.0).m_5752_();
            bufferBuilder.m_5483_((double)x2, (double)y2, 0.0).m_5752_();
            bufferBuilder.m_5483_((double)x2, (double)y1, 0.0).m_5752_();
            bufferBuilder.m_5483_((double)x1, (double)y1, 0.0).m_5752_();
        }
        if (this.vertexBuffer == null || this.vertexBuffer.m_231230_()) {
            this.close();
            this.vertexBuffer = new VertexBuffer();
        }
        BufferBuilder.RenderedBuffer meshData = bufferBuilder.m_231175_();
        this.vertexBuffer.m_85921_();
        this.vertexBuffer.m_231221_(meshData);
    }
}

